/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class VRScreenshots {
    protected VRScreenshots() {
        throw new UnsupportedOperationException();
    }

    public static int nVRScreenshots_RequestScreenshot(long pOutScreenshotHandle, int type, long pchPreviewFilename, long pchVRFilename) {
        long __functionAddress = OpenVR.VRScreenshots.RequestScreenshot;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(__functionAddress, pOutScreenshotHandle, type, pchPreviewFilename, pchVRFilename);
    }

    public static int VRScreenshots_RequestScreenshot(IntBuffer pOutScreenshotHandle, int type, ByteBuffer pchPreviewFilename, ByteBuffer pchVRFilename) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pOutScreenshotHandle, 1);
            Checks.checkNT1(pchPreviewFilename);
            Checks.checkNT1(pchVRFilename);
        }
        return VRScreenshots.nVRScreenshots_RequestScreenshot(MemoryUtil.memAddress(pOutScreenshotHandle), type, MemoryUtil.memAddress(pchPreviewFilename), MemoryUtil.memAddress(pchVRFilename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VRScreenshots_RequestScreenshot(IntBuffer pOutScreenshotHandle, int type, CharSequence pchPreviewFilename, CharSequence pchVRFilename) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pOutScreenshotHandle, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchPreviewFilenameEncoded = stack.ASCII(pchPreviewFilename);
            ByteBuffer pchVRFilenameEncoded = stack.ASCII(pchVRFilename);
            int n = VRScreenshots.nVRScreenshots_RequestScreenshot(MemoryUtil.memAddress(pOutScreenshotHandle), type, MemoryUtil.memAddress(pchPreviewFilenameEncoded), MemoryUtil.memAddress(pchVRFilenameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRScreenshots_HookScreenshot(long pSupportedTypes, int numTypes) {
        long __functionAddress = OpenVR.VRScreenshots.HookScreenshot;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(__functionAddress, pSupportedTypes, numTypes);
    }

    public static int VRScreenshots_HookScreenshot(IntBuffer pSupportedTypes) {
        return VRScreenshots.nVRScreenshots_HookScreenshot(MemoryUtil.memAddress(pSupportedTypes), pSupportedTypes.remaining());
    }

    public static int nVRScreenshots_GetScreenshotPropertyType(int screenshotHandle, long pError) {
        long __functionAddress = OpenVR.VRScreenshots.GetScreenshotPropertyType;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(__functionAddress, screenshotHandle, pError);
    }

    public static int VRScreenshots_GetScreenshotPropertyType(int screenshotHandle, IntBuffer pError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pError, 1);
        }
        return VRScreenshots.nVRScreenshots_GetScreenshotPropertyType(screenshotHandle, MemoryUtil.memAddress(pError));
    }

    public static int nVRScreenshots_GetScreenshotPropertyFilename(int screenshotHandle, int filenameType, long pchFilename, int cchFilename, long pError) {
        long __functionAddress = OpenVR.VRScreenshots.GetScreenshotPropertyFilename;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(__functionAddress, screenshotHandle, filenameType, pchFilename, cchFilename, pError);
    }

    public static int VRScreenshots_GetScreenshotPropertyFilename(int screenshotHandle, int filenameType, ByteBuffer pchFilename, IntBuffer pError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pError, 1);
        }
        return VRScreenshots.nVRScreenshots_GetScreenshotPropertyFilename(screenshotHandle, filenameType, MemoryUtil.memAddressSafe(pchFilename), Checks.remainingSafe(pchFilename), MemoryUtil.memAddress(pError));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String VRScreenshots_GetScreenshotPropertyFilename(int screenshotHandle, int filenameType, int cchFilename, IntBuffer pError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pError, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchFilename = stack.malloc(cchFilename);
            int __result = VRScreenshots.nVRScreenshots_GetScreenshotPropertyFilename(screenshotHandle, filenameType, MemoryUtil.memAddress(pchFilename), cchFilename, MemoryUtil.memAddress(pError));
            String string = MemoryUtil.memASCII(pchFilename, __result - 1);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int VRScreenshots_UpdateScreenshotProgress(int screenshotHandle, float flProgress) {
        long __functionAddress = OpenVR.VRScreenshots.UpdateScreenshotProgress;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callI(__functionAddress, screenshotHandle, flProgress);
    }

    public static int nVRScreenshots_TakeStereoScreenshot(long pOutScreenshotHandle, long pchPreviewFilename, long pchVRFilename) {
        long __functionAddress = OpenVR.VRScreenshots.TakeStereoScreenshot;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(__functionAddress, pOutScreenshotHandle, pchPreviewFilename, pchVRFilename);
    }

    public static int VRScreenshots_TakeStereoScreenshot(IntBuffer pOutScreenshotHandle, ByteBuffer pchPreviewFilename, ByteBuffer pchVRFilename) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pOutScreenshotHandle, 1);
            Checks.checkNT1(pchPreviewFilename);
            Checks.checkNT1(pchVRFilename);
        }
        return VRScreenshots.nVRScreenshots_TakeStereoScreenshot(MemoryUtil.memAddress(pOutScreenshotHandle), MemoryUtil.memAddress(pchPreviewFilename), MemoryUtil.memAddress(pchVRFilename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VRScreenshots_TakeStereoScreenshot(IntBuffer pOutScreenshotHandle, CharSequence pchPreviewFilename, CharSequence pchVRFilename) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pOutScreenshotHandle, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchPreviewFilenameEncoded = stack.ASCII(pchPreviewFilename);
            ByteBuffer pchVRFilenameEncoded = stack.ASCII(pchVRFilename);
            int n = VRScreenshots.nVRScreenshots_TakeStereoScreenshot(MemoryUtil.memAddress(pOutScreenshotHandle), MemoryUtil.memAddress(pchPreviewFilenameEncoded), MemoryUtil.memAddress(pchVRFilenameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRScreenshots_SubmitScreenshot(int screenshotHandle, int type, long pchSourcePreviewFilename, long pchSourceVRFilename) {
        long __functionAddress = OpenVR.VRScreenshots.SubmitScreenshot;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(__functionAddress, screenshotHandle, type, pchSourcePreviewFilename, pchSourceVRFilename);
    }

    public static int VRScreenshots_SubmitScreenshot(int screenshotHandle, int type, ByteBuffer pchSourcePreviewFilename, ByteBuffer pchSourceVRFilename) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchSourcePreviewFilename);
            Checks.checkNT1(pchSourceVRFilename);
        }
        return VRScreenshots.nVRScreenshots_SubmitScreenshot(screenshotHandle, type, MemoryUtil.memAddress(pchSourcePreviewFilename), MemoryUtil.memAddress(pchSourceVRFilename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VRScreenshots_SubmitScreenshot(int screenshotHandle, int type, CharSequence pchSourcePreviewFilename, CharSequence pchSourceVRFilename) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchSourcePreviewFilenameEncoded = stack.ASCII(pchSourcePreviewFilename);
            ByteBuffer pchSourceVRFilenameEncoded = stack.ASCII(pchSourceVRFilename);
            int n = VRScreenshots.nVRScreenshots_SubmitScreenshot(screenshotHandle, type, MemoryUtil.memAddress(pchSourcePreviewFilenameEncoded), MemoryUtil.memAddress(pchSourceVRFilenameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }
}

