/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRAudioChannelData
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SAMPLES;
    public static final int SAMPLESCOUNT;
    public static final int FREQUENCY;

    OVRAudioChannelData(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRAudioChannelData(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRAudioChannelData.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public FloatBuffer Samples() {
        return OVRAudioChannelData.nSamples(this.address());
    }

    public int SamplesCount() {
        return OVRAudioChannelData.nSamplesCount(this.address());
    }

    public int Frequency() {
        return OVRAudioChannelData.nFrequency(this.address());
    }

    public static OVRAudioChannelData malloc() {
        return OVRAudioChannelData.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRAudioChannelData calloc() {
        return OVRAudioChannelData.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRAudioChannelData create() {
        return new OVRAudioChannelData(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRAudioChannelData create(long address) {
        return address == 0L ? null : new OVRAudioChannelData(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRAudioChannelData.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRAudioChannelData.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRAudioChannelData mallocStack() {
        return OVRAudioChannelData.mallocStack(MemoryStack.stackGet());
    }

    public static OVRAudioChannelData callocStack() {
        return OVRAudioChannelData.callocStack(MemoryStack.stackGet());
    }

    public static OVRAudioChannelData mallocStack(MemoryStack stack) {
        return OVRAudioChannelData.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRAudioChannelData callocStack(MemoryStack stack) {
        return OVRAudioChannelData.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRAudioChannelData.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRAudioChannelData.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRAudioChannelData.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRAudioChannelData.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer nSamples(long struct) {
        return MemoryUtil.memFloatBuffer(MemoryUtil.memGetAddress(struct + (long)SAMPLES), OVRAudioChannelData.nSamplesCount(struct));
    }

    public static int nSamplesCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLESCOUNT);
    }

    public static int nFrequency(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FREQUENCY);
    }

    static {
        Struct.Layout layout = OVRAudioChannelData.__struct(OVRAudioChannelData.__member(POINTER_SIZE), OVRAudioChannelData.__member(4), OVRAudioChannelData.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SAMPLES = layout.offsetof(0);
        SAMPLESCOUNT = layout.offsetof(1);
        FREQUENCY = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<OVRAudioChannelData, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRAudioChannelData newInstance(long address) {
            return new OVRAudioChannelData(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public FloatBuffer Samples() {
            return OVRAudioChannelData.nSamples(this.address());
        }

        public int SamplesCount() {
            return OVRAudioChannelData.nSamplesCount(this.address());
        }

        public int Frequency() {
            return OVRAudioChannelData.nFrequency(this.address());
        }
    }
}

