/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRVector3f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRBoundaryTestResult
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ISTRIGGERING;
    public static final int CLOSESTDISTANCE;
    public static final int CLOSESTPOINT;
    public static final int CLOSESTPOINTNORMAL;

    OVRBoundaryTestResult(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRBoundaryTestResult(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRBoundaryTestResult.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public boolean IsTriggering() {
        return OVRBoundaryTestResult.nIsTriggering(this.address());
    }

    public float ClosestDistance() {
        return OVRBoundaryTestResult.nClosestDistance(this.address());
    }

    public OVRVector3f ClosestPoint() {
        return OVRBoundaryTestResult.nClosestPoint(this.address());
    }

    public OVRVector3f ClosestPointNormal() {
        return OVRBoundaryTestResult.nClosestPointNormal(this.address());
    }

    public static OVRBoundaryTestResult malloc() {
        return OVRBoundaryTestResult.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRBoundaryTestResult calloc() {
        return OVRBoundaryTestResult.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRBoundaryTestResult create() {
        return new OVRBoundaryTestResult(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRBoundaryTestResult create(long address) {
        return address == 0L ? null : new OVRBoundaryTestResult(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRBoundaryTestResult.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRBoundaryTestResult.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRBoundaryTestResult mallocStack() {
        return OVRBoundaryTestResult.mallocStack(MemoryStack.stackGet());
    }

    public static OVRBoundaryTestResult callocStack() {
        return OVRBoundaryTestResult.callocStack(MemoryStack.stackGet());
    }

    public static OVRBoundaryTestResult mallocStack(MemoryStack stack) {
        return OVRBoundaryTestResult.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRBoundaryTestResult callocStack(MemoryStack stack) {
        return OVRBoundaryTestResult.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRBoundaryTestResult.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRBoundaryTestResult.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRBoundaryTestResult.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRBoundaryTestResult.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static boolean nIsTriggering(long struct) {
        return MemoryUtil.memGetByte(struct + (long)ISTRIGGERING) != 0;
    }

    public static float nClosestDistance(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)CLOSESTDISTANCE);
    }

    public static OVRVector3f nClosestPoint(long struct) {
        return OVRVector3f.create(struct + (long)CLOSESTPOINT);
    }

    public static OVRVector3f nClosestPointNormal(long struct) {
        return OVRVector3f.create(struct + (long)CLOSESTPOINTNORMAL);
    }

    static {
        Struct.Layout layout = OVRBoundaryTestResult.__struct(OVRBoundaryTestResult.__member(1), OVRBoundaryTestResult.__member(4), OVRBoundaryTestResult.__member(OVRVector3f.SIZEOF, OVRVector3f.ALIGNOF), OVRBoundaryTestResult.__member(OVRVector3f.SIZEOF, OVRVector3f.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ISTRIGGERING = layout.offsetof(0);
        CLOSESTDISTANCE = layout.offsetof(1);
        CLOSESTPOINT = layout.offsetof(2);
        CLOSESTPOINTNORMAL = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<OVRBoundaryTestResult, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRBoundaryTestResult newInstance(long address) {
            return new OVRBoundaryTestResult(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public boolean IsTriggering() {
            return OVRBoundaryTestResult.nIsTriggering(this.address());
        }

        public float ClosestDistance() {
            return OVRBoundaryTestResult.nClosestDistance(this.address());
        }

        public OVRVector3f ClosestPoint() {
            return OVRBoundaryTestResult.nClosestPoint(this.address());
        }

        public OVRVector3f ClosestPointNormal() {
            return OVRBoundaryTestResult.nClosestPointNormal(this.address());
        }
    }
}

