/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRFovPort
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int UPTAN;
    public static final int DOWNTAN;
    public static final int LEFTTAN;
    public static final int RIGHTTAN;

    OVRFovPort(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRFovPort(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRFovPort.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float UpTan() {
        return OVRFovPort.nUpTan(this.address());
    }

    public float DownTan() {
        return OVRFovPort.nDownTan(this.address());
    }

    public float LeftTan() {
        return OVRFovPort.nLeftTan(this.address());
    }

    public float RightTan() {
        return OVRFovPort.nRightTan(this.address());
    }

    public OVRFovPort UpTan(float value) {
        OVRFovPort.nUpTan(this.address(), value);
        return this;
    }

    public OVRFovPort DownTan(float value) {
        OVRFovPort.nDownTan(this.address(), value);
        return this;
    }

    public OVRFovPort LeftTan(float value) {
        OVRFovPort.nLeftTan(this.address(), value);
        return this;
    }

    public OVRFovPort RightTan(float value) {
        OVRFovPort.nRightTan(this.address(), value);
        return this;
    }

    public OVRFovPort set(float UpTan, float DownTan, float LeftTan, float RightTan) {
        this.UpTan(UpTan);
        this.DownTan(DownTan);
        this.LeftTan(LeftTan);
        this.RightTan(RightTan);
        return this;
    }

    public OVRFovPort set(OVRFovPort src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRFovPort malloc() {
        return OVRFovPort.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRFovPort calloc() {
        return OVRFovPort.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRFovPort create() {
        return new OVRFovPort(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRFovPort create(long address) {
        return address == 0L ? null : new OVRFovPort(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRFovPort.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRFovPort.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRFovPort mallocStack() {
        return OVRFovPort.mallocStack(MemoryStack.stackGet());
    }

    public static OVRFovPort callocStack() {
        return OVRFovPort.callocStack(MemoryStack.stackGet());
    }

    public static OVRFovPort mallocStack(MemoryStack stack) {
        return OVRFovPort.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRFovPort callocStack(MemoryStack stack) {
        return OVRFovPort.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRFovPort.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRFovPort.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRFovPort.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRFovPort.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nUpTan(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)UPTAN);
    }

    public static float nDownTan(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)DOWNTAN);
    }

    public static float nLeftTan(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)LEFTTAN);
    }

    public static float nRightTan(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)RIGHTTAN);
    }

    public static void nUpTan(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)UPTAN, value);
    }

    public static void nDownTan(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)DOWNTAN, value);
    }

    public static void nLeftTan(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)LEFTTAN, value);
    }

    public static void nRightTan(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)RIGHTTAN, value);
    }

    static {
        Struct.Layout layout = OVRFovPort.__struct(OVRFovPort.__member(4), OVRFovPort.__member(4), OVRFovPort.__member(4), OVRFovPort.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        UPTAN = layout.offsetof(0);
        DOWNTAN = layout.offsetof(1);
        LEFTTAN = layout.offsetof(2);
        RIGHTTAN = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<OVRFovPort, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRFovPort newInstance(long address) {
            return new OVRFovPort(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public float UpTan() {
            return OVRFovPort.nUpTan(this.address());
        }

        public float DownTan() {
            return OVRFovPort.nDownTan(this.address());
        }

        public float LeftTan() {
            return OVRFovPort.nLeftTan(this.address());
        }

        public float RightTan() {
            return OVRFovPort.nRightTan(this.address());
        }

        public Buffer UpTan(float value) {
            OVRFovPort.nUpTan(this.address(), value);
            return this;
        }

        public Buffer DownTan(float value) {
            OVRFovPort.nDownTan(this.address(), value);
            return this;
        }

        public Buffer LeftTan(float value) {
            OVRFovPort.nLeftTan(this.address(), value);
            return this;
        }

        public Buffer RightTan(float value) {
            OVRFovPort.nRightTan(this.address(), value);
            return this;
        }
    }
}

