/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRHapticsBuffer
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SAMPLES;
    public static final int SAMPLESCOUNT;
    public static final int SUBMITMODE;

    OVRHapticsBuffer(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRHapticsBuffer(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRHapticsBuffer.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public ByteBuffer Samples(int capacity) {
        return OVRHapticsBuffer.nSamples(this.address(), capacity);
    }

    public int SamplesCount() {
        return OVRHapticsBuffer.nSamplesCount(this.address());
    }

    public int SubmitMode() {
        return OVRHapticsBuffer.nSubmitMode(this.address());
    }

    public OVRHapticsBuffer Samples(ByteBuffer value) {
        OVRHapticsBuffer.nSamples(this.address(), value);
        return this;
    }

    public OVRHapticsBuffer SamplesCount(int value) {
        OVRHapticsBuffer.nSamplesCount(this.address(), value);
        return this;
    }

    public OVRHapticsBuffer SubmitMode(int value) {
        OVRHapticsBuffer.nSubmitMode(this.address(), value);
        return this;
    }

    public OVRHapticsBuffer set(ByteBuffer Samples, int SamplesCount, int SubmitMode) {
        this.Samples(Samples);
        this.SamplesCount(SamplesCount);
        this.SubmitMode(SubmitMode);
        return this;
    }

    public OVRHapticsBuffer set(OVRHapticsBuffer src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRHapticsBuffer malloc() {
        return OVRHapticsBuffer.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRHapticsBuffer calloc() {
        return OVRHapticsBuffer.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRHapticsBuffer create() {
        return new OVRHapticsBuffer(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRHapticsBuffer create(long address) {
        return address == 0L ? null : new OVRHapticsBuffer(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRHapticsBuffer.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRHapticsBuffer.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRHapticsBuffer mallocStack() {
        return OVRHapticsBuffer.mallocStack(MemoryStack.stackGet());
    }

    public static OVRHapticsBuffer callocStack() {
        return OVRHapticsBuffer.callocStack(MemoryStack.stackGet());
    }

    public static OVRHapticsBuffer mallocStack(MemoryStack stack) {
        return OVRHapticsBuffer.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRHapticsBuffer callocStack(MemoryStack stack) {
        return OVRHapticsBuffer.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRHapticsBuffer.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRHapticsBuffer.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRHapticsBuffer.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRHapticsBuffer.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nSamples(long struct, int capacity) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)SAMPLES), capacity);
    }

    public static int nSamplesCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLESCOUNT);
    }

    public static int nSubmitMode(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUBMITMODE);
    }

    public static void nSamples(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)SAMPLES, MemoryUtil.memAddress(value));
    }

    public static void nSamplesCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SAMPLESCOUNT, value);
    }

    public static void nSubmitMode(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SUBMITMODE, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SAMPLES));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            OVRHapticsBuffer.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = OVRHapticsBuffer.__struct(OVRHapticsBuffer.__member(POINTER_SIZE), OVRHapticsBuffer.__member(4), OVRHapticsBuffer.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SAMPLES = layout.offsetof(0);
        SAMPLESCOUNT = layout.offsetof(1);
        SUBMITMODE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<OVRHapticsBuffer, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRHapticsBuffer newInstance(long address) {
            return new OVRHapticsBuffer(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public ByteBuffer Samples(int capacity) {
            return OVRHapticsBuffer.nSamples(this.address(), capacity);
        }

        public int SamplesCount() {
            return OVRHapticsBuffer.nSamplesCount(this.address());
        }

        public int SubmitMode() {
            return OVRHapticsBuffer.nSubmitMode(this.address());
        }

        public Buffer Samples(ByteBuffer value) {
            OVRHapticsBuffer.nSamples(this.address(), value);
            return this;
        }

        public Buffer SamplesCount(int value) {
            OVRHapticsBuffer.nSamplesCount(this.address(), value);
            return this;
        }

        public Buffer SubmitMode(int value) {
            OVRHapticsBuffer.nSubmitMode(this.address(), value);
            return this;
        }
    }
}

