/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRLayerEyeFov;
import org.lwjgl.ovr.OVRLayerHeader;
import org.lwjgl.ovr.OVRLayerQuad;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRLayerUnion
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEADER;
    public static final int EYEFOV;
    public static final int QUAD;

    OVRLayerUnion(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRLayerUnion(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRLayerUnion.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public OVRLayerHeader Header() {
        return OVRLayerUnion.nHeader(this.address());
    }

    public OVRLayerEyeFov EyeFov() {
        return OVRLayerUnion.nEyeFov(this.address());
    }

    public OVRLayerQuad Quad() {
        return OVRLayerUnion.nQuad(this.address());
    }

    public OVRLayerUnion Header(OVRLayerHeader value) {
        OVRLayerUnion.nHeader(this.address(), value);
        return this;
    }

    public OVRLayerUnion EyeFov(OVRLayerEyeFov value) {
        OVRLayerUnion.nEyeFov(this.address(), value);
        return this;
    }

    public OVRLayerUnion Quad(OVRLayerQuad value) {
        OVRLayerUnion.nQuad(this.address(), value);
        return this;
    }

    public OVRLayerUnion set(OVRLayerUnion src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRLayerUnion malloc() {
        return OVRLayerUnion.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRLayerUnion calloc() {
        return OVRLayerUnion.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRLayerUnion create() {
        return new OVRLayerUnion(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRLayerUnion create(long address) {
        return address == 0L ? null : new OVRLayerUnion(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRLayerUnion.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRLayerUnion.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRLayerUnion mallocStack() {
        return OVRLayerUnion.mallocStack(MemoryStack.stackGet());
    }

    public static OVRLayerUnion callocStack() {
        return OVRLayerUnion.callocStack(MemoryStack.stackGet());
    }

    public static OVRLayerUnion mallocStack(MemoryStack stack) {
        return OVRLayerUnion.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRLayerUnion callocStack(MemoryStack stack) {
        return OVRLayerUnion.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRLayerUnion.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRLayerUnion.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRLayerUnion.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRLayerUnion.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static OVRLayerHeader nHeader(long struct) {
        return OVRLayerHeader.create(struct + (long)HEADER);
    }

    public static OVRLayerEyeFov nEyeFov(long struct) {
        return OVRLayerEyeFov.create(struct + (long)EYEFOV);
    }

    public static OVRLayerQuad nQuad(long struct) {
        return OVRLayerQuad.create(struct + (long)QUAD);
    }

    public static void nHeader(long struct, OVRLayerHeader value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HEADER, OVRLayerHeader.SIZEOF);
    }

    public static void nEyeFov(long struct, OVRLayerEyeFov value) {
        MemoryUtil.memCopy(value.address(), struct + (long)EYEFOV, OVRLayerEyeFov.SIZEOF);
    }

    public static void nQuad(long struct, OVRLayerQuad value) {
        MemoryUtil.memCopy(value.address(), struct + (long)QUAD, OVRLayerQuad.SIZEOF);
    }

    static {
        Struct.Layout layout = OVRLayerUnion.__union(OVRLayerUnion.__member(OVRLayerHeader.SIZEOF, OVRLayerHeader.ALIGNOF), OVRLayerUnion.__member(OVRLayerEyeFov.SIZEOF, OVRLayerEyeFov.ALIGNOF), OVRLayerUnion.__member(OVRLayerQuad.SIZEOF, OVRLayerQuad.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEADER = layout.offsetof(0);
        EYEFOV = layout.offsetof(1);
        QUAD = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<OVRLayerUnion, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRLayerUnion newInstance(long address) {
            return new OVRLayerUnion(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public OVRLayerHeader Header() {
            return OVRLayerUnion.nHeader(this.address());
        }

        public OVRLayerEyeFov EyeFov() {
            return OVRLayerUnion.nEyeFov(this.address());
        }

        public OVRLayerQuad Quad() {
            return OVRLayerUnion.nQuad(this.address());
        }

        public Buffer Header(OVRLayerHeader value) {
            OVRLayerUnion.nHeader(this.address(), value);
            return this;
        }

        public Buffer EyeFov(OVRLayerEyeFov value) {
            OVRLayerUnion.nEyeFov(this.address(), value);
            return this;
        }

        public Buffer Quad(OVRLayerQuad value) {
            OVRLayerUnion.nQuad(this.address(), value);
            return this;
        }
    }
}

