/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRPerfStatsPerCompositorFrame;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRPerfStats
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FRAMESTATS;
    public static final int FRAMESTATSCOUNT;
    public static final int ANYFRAMESTATSDROPPED;
    public static final int ADAPTIVEGPUPERFORMANCESCALE;
    public static final int ASWISAVAILABLE;
    public static final int VISIBLEPROCESSID;

    OVRPerfStats(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRPerfStats(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRPerfStats.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public OVRPerfStatsPerCompositorFrame.Buffer FrameStats() {
        return OVRPerfStats.nFrameStats(this.address());
    }

    public OVRPerfStatsPerCompositorFrame FrameStats(int index) {
        return OVRPerfStats.nFrameStats(this.address(), index);
    }

    public int FrameStatsCount() {
        return OVRPerfStats.nFrameStatsCount(this.address());
    }

    public boolean AnyFrameStatsDropped() {
        return OVRPerfStats.nAnyFrameStatsDropped(this.address());
    }

    public float AdaptiveGpuPerformanceScale() {
        return OVRPerfStats.nAdaptiveGpuPerformanceScale(this.address());
    }

    public boolean AswIsAvailable() {
        return OVRPerfStats.nAswIsAvailable(this.address());
    }

    public int VisibleProcessId() {
        return OVRPerfStats.nVisibleProcessId(this.address());
    }

    public static OVRPerfStats malloc() {
        return OVRPerfStats.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRPerfStats calloc() {
        return OVRPerfStats.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRPerfStats create() {
        return new OVRPerfStats(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRPerfStats create(long address) {
        return address == 0L ? null : new OVRPerfStats(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRPerfStats.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRPerfStats.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRPerfStats mallocStack() {
        return OVRPerfStats.mallocStack(MemoryStack.stackGet());
    }

    public static OVRPerfStats callocStack() {
        return OVRPerfStats.callocStack(MemoryStack.stackGet());
    }

    public static OVRPerfStats mallocStack(MemoryStack stack) {
        return OVRPerfStats.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRPerfStats callocStack(MemoryStack stack) {
        return OVRPerfStats.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRPerfStats.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRPerfStats.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRPerfStats.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRPerfStats.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static OVRPerfStatsPerCompositorFrame.Buffer nFrameStats(long struct) {
        return OVRPerfStatsPerCompositorFrame.create(struct + (long)FRAMESTATS, OVRPerfStats.nFrameStatsCount(struct));
    }

    public static OVRPerfStatsPerCompositorFrame nFrameStats(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 5);
        }
        return OVRPerfStatsPerCompositorFrame.create(struct + (long)FRAMESTATS + (long)(index * OVRPerfStatsPerCompositorFrame.SIZEOF));
    }

    public static int nFrameStatsCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FRAMESTATSCOUNT);
    }

    public static boolean nAnyFrameStatsDropped(long struct) {
        return MemoryUtil.memGetByte(struct + (long)ANYFRAMESTATSDROPPED) != 0;
    }

    public static float nAdaptiveGpuPerformanceScale(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)ADAPTIVEGPUPERFORMANCESCALE);
    }

    public static boolean nAswIsAvailable(long struct) {
        return MemoryUtil.memGetByte(struct + (long)ASWISAVAILABLE) != 0;
    }

    public static int nVisibleProcessId(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VISIBLEPROCESSID);
    }

    static {
        Struct.Layout layout = OVRPerfStats.__struct(OVRPerfStats.__array(OVRPerfStatsPerCompositorFrame.SIZEOF, OVRPerfStatsPerCompositorFrame.ALIGNOF, 5), OVRPerfStats.__member(4), OVRPerfStats.__member(1), OVRPerfStats.__member(4), OVRPerfStats.__member(1), OVRPerfStats.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FRAMESTATS = layout.offsetof(0);
        FRAMESTATSCOUNT = layout.offsetof(1);
        ANYFRAMESTATSDROPPED = layout.offsetof(2);
        ADAPTIVEGPUPERFORMANCESCALE = layout.offsetof(3);
        ASWISAVAILABLE = layout.offsetof(4);
        VISIBLEPROCESSID = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<OVRPerfStats, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRPerfStats newInstance(long address) {
            return new OVRPerfStats(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public OVRPerfStatsPerCompositorFrame.Buffer FrameStats() {
            return OVRPerfStats.nFrameStats(this.address());
        }

        public OVRPerfStatsPerCompositorFrame FrameStats(int index) {
            return OVRPerfStats.nFrameStats(this.address(), index);
        }

        public int FrameStatsCount() {
            return OVRPerfStats.nFrameStatsCount(this.address());
        }

        public boolean AnyFrameStatsDropped() {
            return OVRPerfStats.nAnyFrameStatsDropped(this.address());
        }

        public float AdaptiveGpuPerformanceScale() {
            return OVRPerfStats.nAdaptiveGpuPerformanceScale(this.address());
        }

        public boolean AswIsAvailable() {
            return OVRPerfStats.nAswIsAvailable(this.address());
        }

        public int VisibleProcessId() {
            return OVRPerfStats.nVisibleProcessId(this.address());
        }
    }
}

