/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRQuatf;
import org.lwjgl.ovr.OVRVector3f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRPosef
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ORIENTATION;
    public static final int POSITION;

    OVRPosef(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRPosef(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRPosef.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public OVRQuatf Orientation() {
        return OVRPosef.nOrientation(this.address());
    }

    public OVRVector3f Position() {
        return OVRPosef.nPosition(this.address());
    }

    public OVRPosef Orientation(OVRQuatf value) {
        OVRPosef.nOrientation(this.address(), value);
        return this;
    }

    public OVRPosef Position(OVRVector3f value) {
        OVRPosef.nPosition(this.address(), value);
        return this;
    }

    public OVRPosef set(OVRQuatf Orientation, OVRVector3f Position) {
        this.Orientation(Orientation);
        this.Position(Position);
        return this;
    }

    public OVRPosef set(OVRPosef src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRPosef malloc() {
        return OVRPosef.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRPosef calloc() {
        return OVRPosef.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRPosef create() {
        return new OVRPosef(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRPosef create(long address) {
        return address == 0L ? null : new OVRPosef(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRPosef.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRPosef.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRPosef mallocStack() {
        return OVRPosef.mallocStack(MemoryStack.stackGet());
    }

    public static OVRPosef callocStack() {
        return OVRPosef.callocStack(MemoryStack.stackGet());
    }

    public static OVRPosef mallocStack(MemoryStack stack) {
        return OVRPosef.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRPosef callocStack(MemoryStack stack) {
        return OVRPosef.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRPosef.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRPosef.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRPosef.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRPosef.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static OVRQuatf nOrientation(long struct) {
        return OVRQuatf.create(struct + (long)ORIENTATION);
    }

    public static OVRVector3f nPosition(long struct) {
        return OVRVector3f.create(struct + (long)POSITION);
    }

    public static void nOrientation(long struct, OVRQuatf value) {
        MemoryUtil.memCopy(value.address(), struct + (long)ORIENTATION, OVRQuatf.SIZEOF);
    }

    public static void nPosition(long struct, OVRVector3f value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSITION, OVRVector3f.SIZEOF);
    }

    static {
        Struct.Layout layout = OVRPosef.__struct(OVRPosef.__member(OVRQuatf.SIZEOF, OVRQuatf.ALIGNOF), OVRPosef.__member(OVRVector3f.SIZEOF, OVRVector3f.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ORIENTATION = layout.offsetof(0);
        POSITION = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<OVRPosef, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRPosef newInstance(long address) {
            return new OVRPosef(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public OVRQuatf Orientation() {
            return OVRPosef.nOrientation(this.address());
        }

        public OVRVector3f Position() {
            return OVRPosef.nPosition(this.address());
        }

        public Buffer Orientation(OVRQuatf value) {
            OVRPosef.nOrientation(this.address(), value);
            return this;
        }

        public Buffer Position(OVRVector3f value) {
            OVRPosef.nPosition(this.address(), value);
            return this;
        }
    }
}

