/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRTouchHapticsDesc
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SAMPLERATEHZ;
    public static final int SAMPLESIZEINBYTES;
    public static final int QUEUEMINSIZETOAVOIDSTARVATION;
    public static final int SUBMITMINSAMPLES;
    public static final int SUBMITMAXSAMPLES;
    public static final int SUBMITOPTIMALSAMPLES;

    OVRTouchHapticsDesc(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRTouchHapticsDesc(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRTouchHapticsDesc.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int SampleRateHz() {
        return OVRTouchHapticsDesc.nSampleRateHz(this.address());
    }

    public int SampleSizeInBytes() {
        return OVRTouchHapticsDesc.nSampleSizeInBytes(this.address());
    }

    public int QueueMinSizeToAvoidStarvation() {
        return OVRTouchHapticsDesc.nQueueMinSizeToAvoidStarvation(this.address());
    }

    public int SubmitMinSamples() {
        return OVRTouchHapticsDesc.nSubmitMinSamples(this.address());
    }

    public int SubmitMaxSamples() {
        return OVRTouchHapticsDesc.nSubmitMaxSamples(this.address());
    }

    public int SubmitOptimalSamples() {
        return OVRTouchHapticsDesc.nSubmitOptimalSamples(this.address());
    }

    public static OVRTouchHapticsDesc malloc() {
        return OVRTouchHapticsDesc.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRTouchHapticsDesc calloc() {
        return OVRTouchHapticsDesc.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRTouchHapticsDesc create() {
        return new OVRTouchHapticsDesc(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRTouchHapticsDesc create(long address) {
        return address == 0L ? null : new OVRTouchHapticsDesc(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRTouchHapticsDesc.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRTouchHapticsDesc.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRTouchHapticsDesc mallocStack() {
        return OVRTouchHapticsDesc.mallocStack(MemoryStack.stackGet());
    }

    public static OVRTouchHapticsDesc callocStack() {
        return OVRTouchHapticsDesc.callocStack(MemoryStack.stackGet());
    }

    public static OVRTouchHapticsDesc mallocStack(MemoryStack stack) {
        return OVRTouchHapticsDesc.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRTouchHapticsDesc callocStack(MemoryStack stack) {
        return OVRTouchHapticsDesc.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRTouchHapticsDesc.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRTouchHapticsDesc.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRTouchHapticsDesc.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRTouchHapticsDesc.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nSampleRateHz(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLERATEHZ);
    }

    public static int nSampleSizeInBytes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLESIZEINBYTES);
    }

    public static int nQueueMinSizeToAvoidStarvation(long struct) {
        return MemoryUtil.memGetInt(struct + (long)QUEUEMINSIZETOAVOIDSTARVATION);
    }

    public static int nSubmitMinSamples(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUBMITMINSAMPLES);
    }

    public static int nSubmitMaxSamples(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUBMITMAXSAMPLES);
    }

    public static int nSubmitOptimalSamples(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUBMITOPTIMALSAMPLES);
    }

    static {
        Struct.Layout layout = OVRTouchHapticsDesc.__struct(OVRTouchHapticsDesc.__member(4), OVRTouchHapticsDesc.__member(4), OVRTouchHapticsDesc.__member(4), OVRTouchHapticsDesc.__member(4), OVRTouchHapticsDesc.__member(4), OVRTouchHapticsDesc.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SAMPLERATEHZ = layout.offsetof(0);
        SAMPLESIZEINBYTES = layout.offsetof(1);
        QUEUEMINSIZETOAVOIDSTARVATION = layout.offsetof(2);
        SUBMITMINSAMPLES = layout.offsetof(3);
        SUBMITMAXSAMPLES = layout.offsetof(4);
        SUBMITOPTIMALSAMPLES = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<OVRTouchHapticsDesc, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRTouchHapticsDesc newInstance(long address) {
            return new OVRTouchHapticsDesc(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int SampleRateHz() {
            return OVRTouchHapticsDesc.nSampleRateHz(this.address());
        }

        public int SampleSizeInBytes() {
            return OVRTouchHapticsDesc.nSampleSizeInBytes(this.address());
        }

        public int QueueMinSizeToAvoidStarvation() {
            return OVRTouchHapticsDesc.nQueueMinSizeToAvoidStarvation(this.address());
        }

        public int SubmitMinSamples() {
            return OVRTouchHapticsDesc.nSubmitMinSamples(this.address());
        }

        public int SubmitMaxSamples() {
            return OVRTouchHapticsDesc.nSubmitMaxSamples(this.address());
        }

        public int SubmitOptimalSamples() {
            return OVRTouchHapticsDesc.nSubmitOptimalSamples(this.address());
        }
    }
}

