/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.stb.LibSTB;
import org.lwjgl.stb.STBIWriteCallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class STBImageWrite {
    public static final IntBuffer stbi_write_tga_with_rle;

    protected STBImageWrite() {
        throw new UnsupportedOperationException();
    }

    public static native int nstbi_write_png(long var0, int var2, int var3, int var4, long var5, int var7);

    public static boolean stbi_write_png(ByteBuffer filename, int w, int h, int comp, ByteBuffer data, int stride_in_bytes) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
            Checks.check((Buffer)data, w * h * comp);
        }
        return STBImageWrite.nstbi_write_png(MemoryUtil.memAddress(filename), w, h, comp, MemoryUtil.memAddress(data), stride_in_bytes) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean stbi_write_png(CharSequence filename, int w, int h, int comp, ByteBuffer data, int stride_in_bytes) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, w * h * comp);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            boolean bl = STBImageWrite.nstbi_write_png(MemoryUtil.memAddress(filenameEncoded), w, h, comp, MemoryUtil.memAddress(data), stride_in_bytes) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nstbi_write_bmp(long var0, int var2, int var3, int var4, long var5);

    public static boolean stbi_write_bmp(ByteBuffer filename, int w, int h, int comp, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
            Checks.check((Buffer)data, w * h * comp);
        }
        return STBImageWrite.nstbi_write_bmp(MemoryUtil.memAddress(filename), w, h, comp, MemoryUtil.memAddress(data)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean stbi_write_bmp(CharSequence filename, int w, int h, int comp, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, w * h * comp);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            boolean bl = STBImageWrite.nstbi_write_bmp(MemoryUtil.memAddress(filenameEncoded), w, h, comp, MemoryUtil.memAddress(data)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nstbi_write_tga(long var0, int var2, int var3, int var4, long var5);

    public static boolean stbi_write_tga(ByteBuffer filename, int w, int h, int comp, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
            Checks.check((Buffer)data, w * h * comp);
        }
        return STBImageWrite.nstbi_write_tga(MemoryUtil.memAddress(filename), w, h, comp, MemoryUtil.memAddress(data)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean stbi_write_tga(CharSequence filename, int w, int h, int comp, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, w * h * comp);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            boolean bl = STBImageWrite.nstbi_write_tga(MemoryUtil.memAddress(filenameEncoded), w, h, comp, MemoryUtil.memAddress(data)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    private static native long nstbi_write_tga_with_rle();

    private static IntBuffer stbi_write_tga_with_rle() {
        long __result = STBImageWrite.nstbi_write_tga_with_rle();
        return MemoryUtil.memIntBuffer(__result, 1);
    }

    public static native int nstbi_write_hdr(long var0, int var2, int var3, int var4, long var5);

    public static boolean stbi_write_hdr(ByteBuffer filename, int w, int h, int comp, FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
            Checks.check((Buffer)data, w * h * comp);
        }
        return STBImageWrite.nstbi_write_hdr(MemoryUtil.memAddress(filename), w, h, comp, MemoryUtil.memAddress(data)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean stbi_write_hdr(CharSequence filename, int w, int h, int comp, FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, w * h * comp);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            boolean bl = STBImageWrite.nstbi_write_hdr(MemoryUtil.memAddress(filenameEncoded), w, h, comp, MemoryUtil.memAddress(data)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nstbi_write_png_to_func(long var0, long var2, int var4, int var5, int var6, long var7, int var9);

    public static boolean stbi_write_png_to_func(STBIWriteCallbackI func, long context, int w, int h, int comp, ByteBuffer data, int stride_in_bytes) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, w * h * comp);
        }
        return STBImageWrite.nstbi_write_png_to_func(func.address(), context, w, h, comp, MemoryUtil.memAddress(data), stride_in_bytes) != 0;
    }

    public static native int nstbi_write_bmp_to_func(long var0, long var2, int var4, int var5, int var6, long var7);

    public static boolean stbi_write_bmp_to_func(STBIWriteCallbackI func, long context, int w, int h, int comp, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, w * h * comp);
        }
        return STBImageWrite.nstbi_write_bmp_to_func(func.address(), context, w, h, comp, MemoryUtil.memAddress(data)) != 0;
    }

    public static native int nstbi_write_tga_to_func(long var0, long var2, int var4, int var5, int var6, long var7);

    public static boolean stbi_write_tga_to_func(STBIWriteCallbackI func, long context, int w, int h, int comp, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, w * h * comp);
        }
        return STBImageWrite.nstbi_write_tga_to_func(func.address(), context, w, h, comp, MemoryUtil.memAddress(data)) != 0;
    }

    public static native int nstbi_write_hdr_to_func(long var0, long var2, int var4, int var5, int var6, long var7);

    public static boolean stbi_write_hdr_to_func(STBIWriteCallbackI func, long context, int w, int h, int comp, FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, w * h * comp);
        }
        return STBImageWrite.nstbi_write_hdr_to_func(func.address(), context, w, h, comp, MemoryUtil.memAddress(data)) != 0;
    }

    public static native int nstbi_write_hdr(long var0, int var2, int var3, int var4, float[] var5);

    public static boolean stbi_write_hdr(ByteBuffer filename, int w, int h, int comp, float[] data) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
            Checks.check(data, w * h * comp);
        }
        return STBImageWrite.nstbi_write_hdr(MemoryUtil.memAddress(filename), w, h, comp, data) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean stbi_write_hdr(CharSequence filename, int w, int h, int comp, float[] data) {
        if (Checks.CHECKS) {
            Checks.check(data, w * h * comp);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            boolean bl = STBImageWrite.nstbi_write_hdr(MemoryUtil.memAddress(filenameEncoded), w, h, comp, data) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nstbi_write_hdr_to_func(long var0, long var2, int var4, int var5, int var6, float[] var7);

    public static boolean stbi_write_hdr_to_func(STBIWriteCallbackI func, long context, int w, int h, int comp, float[] data) {
        if (Checks.CHECKS) {
            Checks.check(data, w * h * comp);
        }
        return STBImageWrite.nstbi_write_hdr_to_func(func.address(), context, w, h, comp, data) != 0;
    }

    static {
        LibSTB.initialize();
        stbi_write_tga_with_rle = STBImageWrite.stbi_write_tga_with_rle();
    }
}

