/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class STBTTPackedchar
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X0;
    public static final int Y0;
    public static final int X1;
    public static final int Y1;
    public static final int XOFF;
    public static final int YOFF;
    public static final int XADVANCE;
    public static final int XOFF2;
    public static final int YOFF2;

    STBTTPackedchar(long address, ByteBuffer container) {
        super(address, container);
    }

    public STBTTPackedchar(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), STBTTPackedchar.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public short x0() {
        return STBTTPackedchar.nx0(this.address());
    }

    public short y0() {
        return STBTTPackedchar.ny0(this.address());
    }

    public short x1() {
        return STBTTPackedchar.nx1(this.address());
    }

    public short y1() {
        return STBTTPackedchar.ny1(this.address());
    }

    public float xoff() {
        return STBTTPackedchar.nxoff(this.address());
    }

    public float yoff() {
        return STBTTPackedchar.nyoff(this.address());
    }

    public float xadvance() {
        return STBTTPackedchar.nxadvance(this.address());
    }

    public float xoff2() {
        return STBTTPackedchar.nxoff2(this.address());
    }

    public float yoff2() {
        return STBTTPackedchar.nyoff2(this.address());
    }

    public static STBTTPackedchar malloc() {
        return STBTTPackedchar.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static STBTTPackedchar calloc() {
        return STBTTPackedchar.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static STBTTPackedchar create() {
        return new STBTTPackedchar(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static STBTTPackedchar create(long address) {
        return address == 0L ? null : new STBTTPackedchar(address, null);
    }

    public static Buffer malloc(int capacity) {
        return STBTTPackedchar.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return STBTTPackedchar.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static STBTTPackedchar mallocStack() {
        return STBTTPackedchar.mallocStack(MemoryStack.stackGet());
    }

    public static STBTTPackedchar callocStack() {
        return STBTTPackedchar.callocStack(MemoryStack.stackGet());
    }

    public static STBTTPackedchar mallocStack(MemoryStack stack) {
        return STBTTPackedchar.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static STBTTPackedchar callocStack(MemoryStack stack) {
        return STBTTPackedchar.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return STBTTPackedchar.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return STBTTPackedchar.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return STBTTPackedchar.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return STBTTPackedchar.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static short nx0(long struct) {
        return MemoryUtil.memGetShort(struct + (long)X0);
    }

    public static short ny0(long struct) {
        return MemoryUtil.memGetShort(struct + (long)Y0);
    }

    public static short nx1(long struct) {
        return MemoryUtil.memGetShort(struct + (long)X1);
    }

    public static short ny1(long struct) {
        return MemoryUtil.memGetShort(struct + (long)Y1);
    }

    public static float nxoff(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)XOFF);
    }

    public static float nyoff(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)YOFF);
    }

    public static float nxadvance(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)XADVANCE);
    }

    public static float nxoff2(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)XOFF2);
    }

    public static float nyoff2(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)YOFF2);
    }

    static {
        Struct.Layout layout = STBTTPackedchar.__struct(STBTTPackedchar.__member(2), STBTTPackedchar.__member(2), STBTTPackedchar.__member(2), STBTTPackedchar.__member(2), STBTTPackedchar.__member(4), STBTTPackedchar.__member(4), STBTTPackedchar.__member(4), STBTTPackedchar.__member(4), STBTTPackedchar.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X0 = layout.offsetof(0);
        Y0 = layout.offsetof(1);
        X1 = layout.offsetof(2);
        Y1 = layout.offsetof(3);
        XOFF = layout.offsetof(4);
        YOFF = layout.offsetof(5);
        XADVANCE = layout.offsetof(6);
        XOFF2 = layout.offsetof(7);
        YOFF2 = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<STBTTPackedchar, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected STBTTPackedchar newInstance(long address) {
            return new STBTTPackedchar(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public short x0() {
            return STBTTPackedchar.nx0(this.address());
        }

        public short y0() {
            return STBTTPackedchar.ny0(this.address());
        }

        public short x1() {
            return STBTTPackedchar.nx1(this.address());
        }

        public short y1() {
            return STBTTPackedchar.ny1(this.address());
        }

        public float xoff() {
            return STBTTPackedchar.nxoff(this.address());
        }

        public float yoff() {
            return STBTTPackedchar.nyoff(this.address());
        }

        public float xadvance() {
            return STBTTPackedchar.nxadvance(this.address());
        }

        public float xoff2() {
            return STBTTPackedchar.nxoff2(this.address());
        }

        public float yoff2() {
            return STBTTPackedchar.nyoff2(this.address());
        }
    }
}

