/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class STBTTVertex
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int CX;
    public static final int CY;
    public static final int CX1;
    public static final int CY1;
    public static final int TYPE;

    STBTTVertex(long address, ByteBuffer container) {
        super(address, container);
    }

    public STBTTVertex(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), STBTTVertex.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public short x() {
        return STBTTVertex.nx(this.address());
    }

    public short y() {
        return STBTTVertex.ny(this.address());
    }

    public short cx() {
        return STBTTVertex.ncx(this.address());
    }

    public short cy() {
        return STBTTVertex.ncy(this.address());
    }

    public short cx1() {
        return STBTTVertex.ncx1(this.address());
    }

    public short cy1() {
        return STBTTVertex.ncy1(this.address());
    }

    public byte type() {
        return STBTTVertex.ntype(this.address());
    }

    public static STBTTVertex malloc() {
        return STBTTVertex.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static STBTTVertex calloc() {
        return STBTTVertex.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static STBTTVertex create() {
        return new STBTTVertex(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static STBTTVertex create(long address) {
        return address == 0L ? null : new STBTTVertex(address, null);
    }

    public static Buffer malloc(int capacity) {
        return STBTTVertex.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return STBTTVertex.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static STBTTVertex mallocStack() {
        return STBTTVertex.mallocStack(MemoryStack.stackGet());
    }

    public static STBTTVertex callocStack() {
        return STBTTVertex.callocStack(MemoryStack.stackGet());
    }

    public static STBTTVertex mallocStack(MemoryStack stack) {
        return STBTTVertex.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static STBTTVertex callocStack(MemoryStack stack) {
        return STBTTVertex.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return STBTTVertex.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return STBTTVertex.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return STBTTVertex.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return STBTTVertex.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static short nx(long struct) {
        return MemoryUtil.memGetShort(struct + (long)X);
    }

    public static short ny(long struct) {
        return MemoryUtil.memGetShort(struct + (long)Y);
    }

    public static short ncx(long struct) {
        return MemoryUtil.memGetShort(struct + (long)CX);
    }

    public static short ncy(long struct) {
        return MemoryUtil.memGetShort(struct + (long)CY);
    }

    public static short ncx1(long struct) {
        return MemoryUtil.memGetShort(struct + (long)CX1);
    }

    public static short ncy1(long struct) {
        return MemoryUtil.memGetShort(struct + (long)CY1);
    }

    public static byte ntype(long struct) {
        return MemoryUtil.memGetByte(struct + (long)TYPE);
    }

    static {
        Struct.Layout layout = STBTTVertex.__struct(STBTTVertex.__member(2), STBTTVertex.__member(2), STBTTVertex.__member(2), STBTTVertex.__member(2), STBTTVertex.__member(2), STBTTVertex.__member(2), STBTTVertex.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        CX = layout.offsetof(2);
        CY = layout.offsetof(3);
        CX1 = layout.offsetof(4);
        CY1 = layout.offsetof(5);
        TYPE = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<STBTTVertex, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected STBTTVertex newInstance(long address) {
            return new STBTTVertex(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public short x() {
            return STBTTVertex.nx(this.address());
        }

        public short y() {
            return STBTTVertex.ny(this.address());
        }

        public short cx() {
            return STBTTVertex.ncx(this.address());
        }

        public short cy() {
            return STBTTVertex.ncy(this.address());
        }

        public short cx1() {
            return STBTTVertex.ncx1(this.address());
        }

        public short cy1() {
            return STBTTVertex.ncy1(this.address());
        }

        public byte type() {
            return STBTTVertex.ntype(this.address());
        }
    }
}

