/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.linux.LinuxLibrary;
import org.lwjgl.system.macosx.MacOSXLibrary;
import org.lwjgl.system.windows.WindowsLibrary;

public final class APIUtil {
    public static final PrintStream DEBUG_STREAM = APIUtil.getDebugStream();

    private static PrintStream getDebugStream() {
        PrintStream debugStream = System.err;
        Object state = Configuration.DEBUG_STREAM.get();
        if (state instanceof String) {
            try {
                Supplier factory = (Supplier)Class.forName((String)state).getConstructor(new Class[0]).newInstance(new Object[0]);
                debugStream = (PrintStream)factory.get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (state instanceof Supplier) {
            debugStream = (PrintStream)((Supplier)state).get();
        } else if (state instanceof PrintStream) {
            debugStream = (PrintStream)state;
        }
        return debugStream;
    }

    private APIUtil() {
    }

    public static void apiLog(CharSequence msg) {
        if (Checks.DEBUG) {
            DEBUG_STREAM.print("[LWJGL] ");
            DEBUG_STREAM.println(msg);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<String> apiGetManifestValue(String attributeName) {
        URL url = APIUtil.class.getClassLoader().getResource("org/lwjgl/system/APIUtil.class");
        if (url == null) return Optional.empty();
        String classURL = url.toString();
        if (!classURL.startsWith("jar:")) return Optional.empty();
        try (InputStream stream = new URL(classURL.substring(0, classURL.lastIndexOf("!") + 1) + '/' + "META-INF/MANIFEST.MF").openStream();){
            Optional<String> optional = Optional.ofNullable(new Manifest(stream).getAttributes("org/lwjgl/")).map(attr -> attr.getValue(attributeName));
            return optional;
        }
        catch (Exception e) {
            e.printStackTrace(DEBUG_STREAM);
        }
        return Optional.empty();
    }

    public static SharedLibrary apiCreateLibrary(String name) {
        switch (Platform.get()) {
            case WINDOWS: {
                return new WindowsLibrary(name);
            }
            case LINUX: {
                return new LinuxLibrary(name);
            }
            case MACOSX: {
                return MacOSXLibrary.create(name);
            }
        }
        throw new IllegalStateException();
    }

    public static long apiGetFunctionAddress(FunctionProvider provider, String functionName) {
        return Checks.check(provider.getFunctionAddress(functionName));
    }

    public static ByteBuffer apiGetMappedBuffer(ByteBuffer buffer, long mappedAddress, int capacity) {
        return buffer == null || MemoryUtil.memAddress(buffer) != mappedAddress || buffer.capacity() != capacity ? MemoryUtil.memByteBuffer(mappedAddress, capacity) : buffer;
    }

    public static APIVersion apiParseVersion(Configuration<?> option) {
        Object state = option.get();
        APIVersion version = state instanceof String ? APIUtil.apiParseVersion((String)state, null) : (state instanceof APIVersion ? (APIVersion)state : null);
        return version;
    }

    public static APIVersion apiParseVersion(String version) {
        return APIUtil.apiParseVersion(version, null);
    }

    public static APIVersion apiParseVersion(String version, String prefix) {
        Matcher matcher;
        String pattern = "([0-9]+)[.]([0-9]+)([.]\\S+)?\\s*(.+)?";
        if (prefix != null) {
            pattern = "(?:" + prefix + "\\s+)?" + pattern;
        }
        if (!(matcher = Pattern.compile(pattern).matcher(version)).matches()) {
            throw new IllegalArgumentException(String.format("Malformed API version string [%s]", version));
        }
        return new APIVersion(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), matcher.group(3), matcher.group(4));
    }

    public static String apiUnknownToken(int token) {
        return APIUtil.apiUnknownToken("Unknown", token);
    }

    public static String apiUnknownToken(String description, int token) {
        return String.format("%s [0x%X]", description, token);
    }

    public static Map<Integer, String> apiClassTokens(BiPredicate<Field, Integer> filter, Map<Integer, String> target, Class<?> ... tokenClasses) {
        if (target == null) {
            target = new HashMap<Integer, String>(64);
        }
        int TOKEN_MODIFIERS = 25;
        for (Class<?> tokenClass : tokenClasses) {
            if (tokenClass == null) continue;
            for (Field field : tokenClass.getDeclaredFields()) {
                if ((field.getModifiers() & TOKEN_MODIFIERS) != TOKEN_MODIFIERS || field.getType() != Integer.TYPE) continue;
                try {
                    Integer value = field.getInt(null);
                    if (filter != null && !filter.test(field, value)) continue;
                    String name = target.get(value);
                    target.put(value, name == null ? field.getName() : name + "|" + field.getName());
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        return target;
    }

    public static long apiArray(MemoryStack stack, long ... addresses) {
        PointerBuffer pointers = stack.mallocPointer(addresses.length);
        for (long address : addresses) {
            pointers.put(address);
        }
        return MemoryUtil.memAddress0(pointers);
    }

    public static long apiArray(MemoryStack stack, ByteBuffer ... buffers) {
        PointerBuffer pointers = stack.mallocPointer(buffers.length);
        for (ByteBuffer buffer : buffers) {
            pointers.put(buffer);
        }
        return MemoryUtil.memAddress0(pointers);
    }

    public static long apiArrayp(MemoryStack stack, ByteBuffer ... buffers) {
        long pointers = APIUtil.apiArray(stack, buffers);
        PointerBuffer lengths = stack.mallocPointer(buffers.length);
        for (ByteBuffer buffer : buffers) {
            lengths.put(buffer.remaining());
        }
        return pointers;
    }

    public static long apiArray(MemoryStack stack, Encoder encoder, CharSequence ... strings) {
        PointerBuffer pointers = stack.mallocPointer(strings.length);
        for (CharSequence s : strings) {
            pointers.put(encoder.encode(s, true));
        }
        return MemoryUtil.memAddress0(pointers);
    }

    public static long apiArrayi(MemoryStack stack, Encoder encoder, CharSequence ... strings) {
        PointerBuffer pointers = stack.mallocPointer(strings.length);
        IntBuffer lengths = stack.mallocInt(strings.length);
        for (CharSequence s : strings) {
            ByteBuffer buffer = encoder.encode(s, false);
            pointers.put(buffer);
            lengths.put(buffer.capacity());
        }
        return MemoryUtil.memAddress0(pointers);
    }

    public static long apiArrayp(MemoryStack stack, Encoder encoder, CharSequence ... strings) {
        PointerBuffer pointers = stack.mallocPointer(strings.length);
        PointerBuffer lengths = stack.mallocPointer(strings.length);
        for (CharSequence s : strings) {
            ByteBuffer buffer = encoder.encode(s, false);
            pointers.put(buffer);
            lengths.put(buffer.capacity());
        }
        return MemoryUtil.memAddress0(pointers);
    }

    public static void apiArrayFree(long pointers, int length) {
        int i = length;
        while (--i >= 0) {
            MemoryUtil.nmemFree(MemoryUtil.memGetAddress(pointers + (long)(i << Pointer.POINTER_SHIFT)));
        }
    }

    public static interface Encoder {
        public ByteBuffer encode(CharSequence var1, boolean var2);
    }

    public static class APIVersion {
        public final int major;
        public final int minor;
        public final String revision;
        public final String implementation;

        public APIVersion(int major, int minor) {
            this(major, minor, null, null);
        }

        public APIVersion(int major, int minor, String revision, String implementation) {
            this.major = major;
            this.minor = minor;
            this.revision = revision;
            this.implementation = implementation;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(16);
            sb.append(this.major).append('.').append(this.minor);
            if (this.revision != null) {
                sb.append('.').append(this.revision);
            }
            if (this.implementation != null) {
                sb.append(" (").append(this.implementation).append(')');
            }
            return sb.toString();
        }
    }
}

