/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.ByteBuffer;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;

public abstract class StructBuffer<T extends Struct, SELF extends StructBuffer<T, SELF>>
extends CustomBuffer<SELF> {
    protected StructBuffer(ByteBuffer container, int remaining) {
        this(MemoryUtil.memAddress(container), container, -1, 0, remaining, remaining);
    }

    protected StructBuffer(long address, ByteBuffer container, int mark, int position, int limit, int capacity) {
        super(address, container, mark, position, limit, capacity);
    }

    public T get() {
        return this.newInstance(this.address + (long)(this.nextGetIndex() * this.sizeof()));
    }

    public SELF get(T value) {
        MemoryUtil.memCopy(this.address + (long)(this.nextGetIndex() * this.sizeof()), ((Pointer.Default)value).address(), this.sizeof());
        return (SELF)((StructBuffer)this.self());
    }

    @Override
    public SELF put(T value) {
        MemoryUtil.memCopy(((Pointer.Default)value).address(), this.address + (long)(this.nextPutIndex() * this.sizeof()), this.sizeof());
        return (SELF)((StructBuffer)this.self());
    }

    public T get(int index) {
        return this.newInstance(this.address + (long)(this.checkIndex(index) * this.sizeof()));
    }

    public SELF get(int index, T value) {
        MemoryUtil.memCopy(this.address + (long)(this.checkIndex(index) * this.sizeof()), ((Pointer.Default)value).address(), this.sizeof());
        return (SELF)((StructBuffer)this.self());
    }

    public SELF put(int index, T value) {
        MemoryUtil.memCopy(((Pointer.Default)value).address(), this.address + (long)(this.checkIndex(index) * this.sizeof()), this.sizeof());
        return (SELF)((StructBuffer)this.self());
    }

    protected abstract T newInstance(long var1);
}

