/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.dyncall;

import java.nio.ByteBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class DynCallback {
    public static final char DCB_SIGCHAR_CC_PREFIX = '_';
    public static final char DCB_SIGCHAR_CC_ELLIPSIS = 'e';
    public static final char DCB_SIGCHAR_CC_STDCALL = 's';
    public static final char DCB_SIGCHAR_CC_FASTCALL_GNU = 'f';
    public static final char DCB_SIGCHAR_CC_FASTCALL_MS = 'F';
    public static final char DCB_SIGCHAR_CC_THISCALL_MS = '+';

    protected DynCallback() {
        throw new UnsupportedOperationException();
    }

    public static native long ndcbNewCallback(long var0, long var2, long var4);

    public static long dcbNewCallback(ByteBuffer signature, long funcptr, long userdata) {
        if (Checks.CHECKS) {
            Checks.checkNT1(signature);
            Checks.check(funcptr);
            Checks.check(userdata);
        }
        return DynCallback.ndcbNewCallback(MemoryUtil.memAddress(signature), funcptr, userdata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long dcbNewCallback(CharSequence signature, long funcptr, long userdata) {
        if (Checks.CHECKS) {
            Checks.check(funcptr);
            Checks.check(userdata);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer signatureEncoded = stack.ASCII(signature);
            long l = DynCallback.ndcbNewCallback(MemoryUtil.memAddress(signatureEncoded), funcptr, userdata);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void ndcbInitCallback(long var0, long var2, long var4, long var6);

    public static void dcbInitCallback(long pcb, ByteBuffer signature, long handler, long userdata) {
        if (Checks.CHECKS) {
            Checks.check(pcb);
            Checks.checkNT1(signature);
            Checks.check(handler);
            Checks.check(userdata);
        }
        DynCallback.ndcbInitCallback(pcb, MemoryUtil.memAddress(signature), handler, userdata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dcbInitCallback(long pcb, CharSequence signature, long handler, long userdata) {
        if (Checks.CHECKS) {
            Checks.check(pcb);
            Checks.check(handler);
            Checks.check(userdata);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer signatureEncoded = stack.ASCII(signature);
            DynCallback.ndcbInitCallback(pcb, MemoryUtil.memAddress(signatureEncoded), handler, userdata);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void ndcbFreeCallback(long var0);

    public static void dcbFreeCallback(long pcb) {
        if (Checks.CHECKS) {
            Checks.check(pcb);
        }
        DynCallback.ndcbFreeCallback(pcb);
    }

    public static native long ndcbGetUserData(long var0);

    public static long dcbGetUserData(long pcb) {
        if (Checks.CHECKS) {
            Checks.check(pcb);
        }
        return DynCallback.ndcbGetUserData(pcb);
    }

    public static native int ndcbArgBool(long var0);

    public static boolean dcbArgBool(long args) {
        if (Checks.CHECKS) {
            Checks.check(args);
        }
        return DynCallback.ndcbArgBool(args) != 0;
    }

    public static native byte ndcbArgChar(long var0);

    public static byte dcbArgChar(long args) {
        if (Checks.CHECKS) {
            Checks.check(args);
        }
        return DynCallback.ndcbArgChar(args);
    }

    public static native short ndcbArgShort(long var0);

    public static short dcbArgShort(long args) {
        if (Checks.CHECKS) {
            Checks.check(args);
        }
        return DynCallback.ndcbArgShort(args);
    }

    public static native int ndcbArgInt(long var0);

    public static int dcbArgInt(long args) {
        if (Checks.CHECKS) {
            Checks.check(args);
        }
        return DynCallback.ndcbArgInt(args);
    }

    public static native int ndcbArgLong(long var0);

    public static int dcbArgLong(long args) {
        if (Checks.CHECKS) {
            Checks.check(args);
        }
        return DynCallback.ndcbArgLong(args);
    }

    public static native long ndcbArgLongLong(long var0);

    public static long dcbArgLongLong(long args) {
        if (Checks.CHECKS) {
            Checks.check(args);
        }
        return DynCallback.ndcbArgLongLong(args);
    }

    public static native byte ndcbArgUChar(long var0);

    public static byte dcbArgUChar(long args) {
        if (Checks.CHECKS) {
            Checks.check(args);
        }
        return DynCallback.ndcbArgUChar(args);
    }

    public static native short ndcbArgUShort(long var0);

    public static short dcbArgUShort(long args) {
        if (Checks.CHECKS) {
            Checks.check(args);
        }
        return DynCallback.ndcbArgUShort(args);
    }

    public static native int ndcbArgUInt(long var0);

    public static int dcbArgUInt(long args) {
        if (Checks.CHECKS) {
            Checks.check(args);
        }
        return DynCallback.ndcbArgUInt(args);
    }

    public static native int ndcbArgULong(long var0);

    public static int dcbArgULong(long args) {
        if (Checks.CHECKS) {
            Checks.check(args);
        }
        return DynCallback.ndcbArgULong(args);
    }

    public static native long ndcbArgULongLong(long var0);

    public static long dcbArgULongLong(long args) {
        if (Checks.CHECKS) {
            Checks.check(args);
        }
        return DynCallback.ndcbArgULongLong(args);
    }

    public static native float ndcbArgFloat(long var0);

    public static float dcbArgFloat(long args) {
        if (Checks.CHECKS) {
            Checks.check(args);
        }
        return DynCallback.ndcbArgFloat(args);
    }

    public static native double ndcbArgDouble(long var0);

    public static double dcbArgDouble(long args) {
        if (Checks.CHECKS) {
            Checks.check(args);
        }
        return DynCallback.ndcbArgDouble(args);
    }

    public static native long ndcbArgPointer(long var0);

    public static long dcbArgPointer(long args) {
        if (Checks.CHECKS) {
            Checks.check(args);
        }
        return DynCallback.ndcbArgPointer(args);
    }

    static {
        Library.initialize();
    }
}

