/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.jawt;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class JAWT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VERSION;
    public static final int GETDRAWINGSURFACE;
    public static final int FREEDRAWINGSURFACE;
    public static final int LOCK;
    public static final int UNLOCK;
    public static final int GETCOMPONENT;
    public static final int CREATEEMBEDDEDFRAME;
    public static final int SETBOUNDS;
    public static final int SYNTHESIZEWINDOWACTIVATION;

    JAWT(long address, ByteBuffer container) {
        super(address, container);
    }

    public JAWT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), JAWT.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int version() {
        return JAWT.nversion(this.address());
    }

    public long GetDrawingSurface() {
        return JAWT.nGetDrawingSurface(this.address());
    }

    public long FreeDrawingSurface() {
        return JAWT.nFreeDrawingSurface(this.address());
    }

    public long Lock() {
        return JAWT.nLock(this.address());
    }

    public long Unlock() {
        return JAWT.nUnlock(this.address());
    }

    public long GetComponent() {
        return JAWT.nGetComponent(this.address());
    }

    public long CreateEmbeddedFrame() {
        return JAWT.nCreateEmbeddedFrame(this.address());
    }

    public long SetBounds() {
        return JAWT.nSetBounds(this.address());
    }

    public long SynthesizeWindowActivation() {
        return JAWT.nSynthesizeWindowActivation(this.address());
    }

    public JAWT version(int value) {
        JAWT.nversion(this.address(), value);
        return this;
    }

    public JAWT GetDrawingSurface(long value) {
        JAWT.nGetDrawingSurface(this.address(), value);
        return this;
    }

    public JAWT FreeDrawingSurface(long value) {
        JAWT.nFreeDrawingSurface(this.address(), value);
        return this;
    }

    public JAWT Lock(long value) {
        JAWT.nLock(this.address(), value);
        return this;
    }

    public JAWT Unlock(long value) {
        JAWT.nUnlock(this.address(), value);
        return this;
    }

    public JAWT GetComponent(long value) {
        JAWT.nGetComponent(this.address(), value);
        return this;
    }

    public JAWT CreateEmbeddedFrame(long value) {
        JAWT.nCreateEmbeddedFrame(this.address(), value);
        return this;
    }

    public JAWT SetBounds(long value) {
        JAWT.nSetBounds(this.address(), value);
        return this;
    }

    public JAWT SynthesizeWindowActivation(long value) {
        JAWT.nSynthesizeWindowActivation(this.address(), value);
        return this;
    }

    public JAWT set(int version, long GetDrawingSurface, long FreeDrawingSurface, long Lock, long Unlock, long GetComponent, long CreateEmbeddedFrame, long SetBounds, long SynthesizeWindowActivation) {
        this.version(version);
        this.GetDrawingSurface(GetDrawingSurface);
        this.FreeDrawingSurface(FreeDrawingSurface);
        this.Lock(Lock);
        this.Unlock(Unlock);
        this.GetComponent(GetComponent);
        this.CreateEmbeddedFrame(CreateEmbeddedFrame);
        this.SetBounds(SetBounds);
        this.SynthesizeWindowActivation(SynthesizeWindowActivation);
        return this;
    }

    public JAWT set(JAWT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static JAWT malloc() {
        return JAWT.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static JAWT calloc() {
        return JAWT.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static JAWT create() {
        return new JAWT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static JAWT create(long address) {
        return address == 0L ? null : new JAWT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return JAWT.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return JAWT.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static JAWT mallocStack() {
        return JAWT.mallocStack(MemoryStack.stackGet());
    }

    public static JAWT callocStack() {
        return JAWT.callocStack(MemoryStack.stackGet());
    }

    public static JAWT mallocStack(MemoryStack stack) {
        return JAWT.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static JAWT callocStack(MemoryStack stack) {
        return JAWT.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return JAWT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return JAWT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return JAWT.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return JAWT.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nversion(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VERSION);
    }

    public static long nGetDrawingSurface(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)GETDRAWINGSURFACE);
    }

    public static long nFreeDrawingSurface(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)FREEDRAWINGSURFACE);
    }

    public static long nLock(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)LOCK);
    }

    public static long nUnlock(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)UNLOCK);
    }

    public static long nGetComponent(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)GETCOMPONENT);
    }

    public static long nCreateEmbeddedFrame(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CREATEEMBEDDEDFRAME);
    }

    public static long nSetBounds(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SETBOUNDS);
    }

    public static long nSynthesizeWindowActivation(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SYNTHESIZEWINDOWACTIVATION);
    }

    public static void nversion(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VERSION, value);
    }

    public static void nGetDrawingSurface(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)GETDRAWINGSURFACE, value);
    }

    public static void nFreeDrawingSurface(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)FREEDRAWINGSURFACE, value);
    }

    public static void nLock(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)LOCK, value);
    }

    public static void nUnlock(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)UNLOCK, value);
    }

    public static void nGetComponent(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)GETCOMPONENT, value);
    }

    public static void nCreateEmbeddedFrame(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)CREATEEMBEDDEDFRAME, value);
    }

    public static void nSetBounds(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SETBOUNDS, value);
    }

    public static void nSynthesizeWindowActivation(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SYNTHESIZEWINDOWACTIVATION, value);
    }

    static {
        Struct.Layout layout = JAWT.__struct(JAWT.__member(4), JAWT.__member(POINTER_SIZE), JAWT.__member(POINTER_SIZE), JAWT.__member(POINTER_SIZE), JAWT.__member(POINTER_SIZE), JAWT.__member(POINTER_SIZE), JAWT.__member(POINTER_SIZE), JAWT.__member(POINTER_SIZE), JAWT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VERSION = layout.offsetof(0);
        GETDRAWINGSURFACE = layout.offsetof(1);
        FREEDRAWINGSURFACE = layout.offsetof(2);
        LOCK = layout.offsetof(3);
        UNLOCK = layout.offsetof(4);
        GETCOMPONENT = layout.offsetof(5);
        CREATEEMBEDDEDFRAME = layout.offsetof(6);
        SETBOUNDS = layout.offsetof(7);
        SYNTHESIZEWINDOWACTIVATION = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<JAWT, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected JAWT newInstance(long address) {
            return new JAWT(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int version() {
            return JAWT.nversion(this.address());
        }

        public long GetDrawingSurface() {
            return JAWT.nGetDrawingSurface(this.address());
        }

        public long FreeDrawingSurface() {
            return JAWT.nFreeDrawingSurface(this.address());
        }

        public long Lock() {
            return JAWT.nLock(this.address());
        }

        public long Unlock() {
            return JAWT.nUnlock(this.address());
        }

        public long GetComponent() {
            return JAWT.nGetComponent(this.address());
        }

        public long CreateEmbeddedFrame() {
            return JAWT.nCreateEmbeddedFrame(this.address());
        }

        public long SetBounds() {
            return JAWT.nSetBounds(this.address());
        }

        public long SynthesizeWindowActivation() {
            return JAWT.nSynthesizeWindowActivation(this.address());
        }

        public Buffer version(int value) {
            JAWT.nversion(this.address(), value);
            return this;
        }

        public Buffer GetDrawingSurface(long value) {
            JAWT.nGetDrawingSurface(this.address(), value);
            return this;
        }

        public Buffer FreeDrawingSurface(long value) {
            JAWT.nFreeDrawingSurface(this.address(), value);
            return this;
        }

        public Buffer Lock(long value) {
            JAWT.nLock(this.address(), value);
            return this;
        }

        public Buffer Unlock(long value) {
            JAWT.nUnlock(this.address(), value);
            return this;
        }

        public Buffer GetComponent(long value) {
            JAWT.nGetComponent(this.address(), value);
            return this;
        }

        public Buffer CreateEmbeddedFrame(long value) {
            JAWT.nCreateEmbeddedFrame(this.address(), value);
            return this;
        }

        public Buffer SetBounds(long value) {
            JAWT.nSetBounds(this.address(), value);
            return this;
        }

        public Buffer SynthesizeWindowActivation(long value) {
            JAWT.nSynthesizeWindowActivation(this.address(), value);
            return this;
        }
    }
}

