/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.jawt;

import java.nio.ByteBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class JAWTDrawingSurface
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ENV;
    public static final int TARGET;
    public static final int LOCK;
    public static final int GETDRAWINGSURFACEINFO;
    public static final int FREEDRAWINGSURFACEINFO;
    public static final int UNLOCK;

    JAWTDrawingSurface(long address, ByteBuffer container) {
        super(address, container);
    }

    public JAWTDrawingSurface(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), JAWTDrawingSurface.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long env() {
        return JAWTDrawingSurface.nenv(this.address());
    }

    public long target() {
        return JAWTDrawingSurface.ntarget(this.address());
    }

    public long Lock() {
        return JAWTDrawingSurface.nLock(this.address());
    }

    public long GetDrawingSurfaceInfo() {
        return JAWTDrawingSurface.nGetDrawingSurfaceInfo(this.address());
    }

    public long FreeDrawingSurfaceInfo() {
        return JAWTDrawingSurface.nFreeDrawingSurfaceInfo(this.address());
    }

    public long Unlock() {
        return JAWTDrawingSurface.nUnlock(this.address());
    }

    public static JAWTDrawingSurface create(long address) {
        return address == 0L ? null : new JAWTDrawingSurface(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static long nenv(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)ENV);
    }

    public static long ntarget(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)TARGET);
    }

    public static long nLock(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)LOCK);
    }

    public static long nGetDrawingSurfaceInfo(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)GETDRAWINGSURFACEINFO);
    }

    public static long nFreeDrawingSurfaceInfo(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)FREEDRAWINGSURFACEINFO);
    }

    public static long nUnlock(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)UNLOCK);
    }

    static {
        Struct.Layout layout = JAWTDrawingSurface.__struct(JAWTDrawingSurface.__member(POINTER_SIZE), JAWTDrawingSurface.__member(POINTER_SIZE), JAWTDrawingSurface.__member(POINTER_SIZE), JAWTDrawingSurface.__member(POINTER_SIZE), JAWTDrawingSurface.__member(POINTER_SIZE), JAWTDrawingSurface.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ENV = layout.offsetof(0);
        TARGET = layout.offsetof(1);
        LOCK = layout.offsetof(2);
        GETDRAWINGSURFACEINFO = layout.offsetof(3);
        FREEDRAWINGSURFACEINFO = layout.offsetof(4);
        UNLOCK = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<JAWTDrawingSurface, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected JAWTDrawingSurface newInstance(long address) {
            return new JAWTDrawingSurface(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long env() {
            return JAWTDrawingSurface.nenv(this.address());
        }

        public long target() {
            return JAWTDrawingSurface.ntarget(this.address());
        }

        public long Lock() {
            return JAWTDrawingSurface.nLock(this.address());
        }

        public long GetDrawingSurfaceInfo() {
            return JAWTDrawingSurface.nGetDrawingSurfaceInfo(this.address());
        }

        public long FreeDrawingSurfaceInfo() {
            return JAWTDrawingSurface.nFreeDrawingSurfaceInfo(this.address());
        }

        public long Unlock() {
            return JAWTDrawingSurface.nUnlock(this.address());
        }
    }
}

