/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.jawt;

import java.nio.ByteBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.jawt.JAWTDrawingSurface;
import org.lwjgl.system.jawt.JAWTRectangle;

public class JAWTDrawingSurfaceInfo
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PLATFORMINFO;
    public static final int DS;
    public static final int BOUNDS;
    public static final int CLIPSIZE;
    public static final int CLIP;

    JAWTDrawingSurfaceInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public JAWTDrawingSurfaceInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), JAWTDrawingSurfaceInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long platformInfo() {
        return JAWTDrawingSurfaceInfo.nplatformInfo(this.address());
    }

    public JAWTDrawingSurface ds() {
        return JAWTDrawingSurfaceInfo.nds(this.address());
    }

    public JAWTRectangle bounds() {
        return JAWTDrawingSurfaceInfo.nbounds(this.address());
    }

    public int clipSize() {
        return JAWTDrawingSurfaceInfo.nclipSize(this.address());
    }

    public JAWTRectangle.Buffer clip() {
        return JAWTDrawingSurfaceInfo.nclip(this.address());
    }

    public static JAWTDrawingSurfaceInfo create(long address) {
        return address == 0L ? null : new JAWTDrawingSurfaceInfo(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static long nplatformInfo(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PLATFORMINFO);
    }

    public static JAWTDrawingSurface nds(long struct) {
        return JAWTDrawingSurface.create(MemoryUtil.memGetAddress(struct + (long)DS));
    }

    public static JAWTRectangle nbounds(long struct) {
        return JAWTRectangle.create(struct + (long)BOUNDS);
    }

    public static int nclipSize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CLIPSIZE);
    }

    public static JAWTRectangle.Buffer nclip(long struct) {
        return JAWTRectangle.create(MemoryUtil.memGetAddress(struct + (long)CLIP), JAWTDrawingSurfaceInfo.nclipSize(struct));
    }

    static {
        Struct.Layout layout = JAWTDrawingSurfaceInfo.__struct(JAWTDrawingSurfaceInfo.__member(POINTER_SIZE), JAWTDrawingSurfaceInfo.__member(POINTER_SIZE), JAWTDrawingSurfaceInfo.__member(JAWTRectangle.SIZEOF, JAWTRectangle.ALIGNOF), JAWTDrawingSurfaceInfo.__member(4), JAWTDrawingSurfaceInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PLATFORMINFO = layout.offsetof(0);
        DS = layout.offsetof(1);
        BOUNDS = layout.offsetof(2);
        CLIPSIZE = layout.offsetof(3);
        CLIP = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<JAWTDrawingSurfaceInfo, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected JAWTDrawingSurfaceInfo newInstance(long address) {
            return new JAWTDrawingSurfaceInfo(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long platformInfo() {
            return JAWTDrawingSurfaceInfo.nplatformInfo(this.address());
        }

        public JAWTDrawingSurface ds() {
            return JAWTDrawingSurfaceInfo.nds(this.address());
        }

        public JAWTRectangle bounds() {
            return JAWTDrawingSurfaceInfo.nbounds(this.address());
        }

        public int clipSize() {
            return JAWTDrawingSurfaceInfo.nclipSize(this.address());
        }

        public JAWTRectangle.Buffer clip() {
            return JAWTDrawingSurfaceInfo.nclip(this.address());
        }
    }
}

