/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.jni;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.jni.JNINativeMethod;

public class JNINativeInterface {
    public static final int JNI_VERSION_1_1 = 65537;
    public static final int JNI_VERSION_1_2 = 65538;
    public static final int JNI_VERSION_1_4 = 65540;
    public static final int JNI_VERSION_1_6 = 65542;
    public static final int JNI_VERSION_1_8 = 65544;
    public static final int JNI_VERSION_9 = 589824;
    public static final int JNIInvalidRefType = 0;
    public static final int JNILocalRefType = 1;
    public static final int JNIGlobalRefType = 2;
    public static final int JNIWeakGlobalRefType = 3;
    public static final int JNI_FALSE = 0;
    public static final int JNI_TRUE = 1;
    public static final int JNI_OK = 0;
    public static final int JNI_ERR = -1;
    public static final int JNI_EDETACHED = -2;
    public static final int JNI_EVERSION = -3;
    public static final int JNI_ENOMEM = -4;
    public static final int JNI_EEXIST = -5;
    public static final int JNI_EINVAL = -6;
    public static final int JNI_COMMIT = 1;
    public static final int JNI_ABORT = 2;

    protected JNINativeInterface() {
        throw new UnsupportedOperationException();
    }

    public static native int GetVersion();

    public static native long FromReflectedMethod(Method var0);

    public static native long FromReflectedField(Field var0);

    public static native Method nToReflectedMethod(Class<?> var0, long var1, boolean var3);

    public static Method ToReflectedMethod(Class<?> cls, long methodID, boolean isStatic) {
        if (Checks.CHECKS) {
            Checks.check(methodID);
        }
        return JNINativeInterface.nToReflectedMethod(cls, methodID, isStatic);
    }

    public static native Method nToReflectedField(Class<?> var0, long var1, boolean var3);

    public static Method ToReflectedField(Class<?> cls, long fieldID, boolean isStatic) {
        if (Checks.CHECKS) {
            Checks.check(fieldID);
        }
        return JNINativeInterface.nToReflectedField(cls, fieldID, isStatic);
    }

    public static native long NewGlobalRef(Object var0);

    public static native void nDeleteGlobalRef(long var0);

    public static void DeleteGlobalRef(long globalRef) {
        if (Checks.CHECKS) {
            Checks.check(globalRef);
        }
        JNINativeInterface.nDeleteGlobalRef(globalRef);
    }

    public static native long nGetBooleanArrayElements(byte[] var0, long var1);

    public static ByteBuffer GetBooleanArrayElements(byte[] array, ByteBuffer isCopy) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)isCopy, 1);
        }
        long __result = JNINativeInterface.nGetBooleanArrayElements(array, MemoryUtil.memAddressSafe(isCopy));
        return MemoryUtil.memByteBuffer(__result, array.length);
    }

    public static native void nReleaseBooleanArrayElements(byte[] var0, long var1, int var3);

    public static void ReleaseBooleanArrayElements(byte[] array, ByteBuffer elems, int mode) {
        JNINativeInterface.nReleaseBooleanArrayElements(array, MemoryUtil.memAddress(elems), mode);
    }

    public static native long nGetByteArrayElements(byte[] var0, long var1);

    public static ByteBuffer GetByteArrayElements(byte[] array, ByteBuffer isCopy) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)isCopy, 1);
        }
        long __result = JNINativeInterface.nGetByteArrayElements(array, MemoryUtil.memAddressSafe(isCopy));
        return MemoryUtil.memByteBuffer(__result, array.length);
    }

    public static native void nReleaseByteArrayElements(byte[] var0, long var1, int var3);

    public static void ReleaseByteArrayElements(byte[] array, ByteBuffer elems, int mode) {
        JNINativeInterface.nReleaseByteArrayElements(array, MemoryUtil.memAddress(elems), mode);
    }

    public static native long nGetCharArrayElements(char[] var0, long var1);

    public static ShortBuffer GetCharArrayElements(char[] array, ByteBuffer isCopy) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)isCopy, 1);
        }
        long __result = JNINativeInterface.nGetCharArrayElements(array, MemoryUtil.memAddressSafe(isCopy));
        return MemoryUtil.memShortBuffer(__result, array.length);
    }

    public static native void nReleaseCharArrayElements(char[] var0, long var1, int var3);

    public static void ReleaseCharArrayElements(char[] array, ShortBuffer elems, int mode) {
        JNINativeInterface.nReleaseCharArrayElements(array, MemoryUtil.memAddress(elems), mode);
    }

    public static native long nGetShortArrayElements(short[] var0, long var1);

    public static ShortBuffer GetShortArrayElements(short[] array, ByteBuffer isCopy) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)isCopy, 1);
        }
        long __result = JNINativeInterface.nGetShortArrayElements(array, MemoryUtil.memAddressSafe(isCopy));
        return MemoryUtil.memShortBuffer(__result, array.length);
    }

    public static native void nReleaseShortArrayElements(short[] var0, long var1, int var3);

    public static void ReleaseShortArrayElements(short[] array, ShortBuffer elems, int mode) {
        JNINativeInterface.nReleaseShortArrayElements(array, MemoryUtil.memAddress(elems), mode);
    }

    public static native long nGetIntArrayElements(int[] var0, long var1);

    public static IntBuffer GetIntArrayElements(int[] array, ByteBuffer isCopy) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)isCopy, 1);
        }
        long __result = JNINativeInterface.nGetIntArrayElements(array, MemoryUtil.memAddressSafe(isCopy));
        return MemoryUtil.memIntBuffer(__result, array.length);
    }

    public static native void nReleaseIntArrayElements(int[] var0, long var1, int var3);

    public static void ReleaseIntArrayElements(int[] array, IntBuffer elems, int mode) {
        JNINativeInterface.nReleaseIntArrayElements(array, MemoryUtil.memAddress(elems), mode);
    }

    public static native long nGetLongArrayElements(long[] var0, long var1);

    public static LongBuffer GetLongArrayElements(long[] array, ByteBuffer isCopy) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)isCopy, 1);
        }
        long __result = JNINativeInterface.nGetLongArrayElements(array, MemoryUtil.memAddressSafe(isCopy));
        return MemoryUtil.memLongBuffer(__result, array.length);
    }

    public static native void nReleaseLongArrayElements(long[] var0, long var1, int var3);

    public static void ReleaseLongArrayElements(long[] array, LongBuffer elems, int mode) {
        JNINativeInterface.nReleaseLongArrayElements(array, MemoryUtil.memAddress(elems), mode);
    }

    public static native long nGetFloatArrayElements(float[] var0, long var1);

    public static FloatBuffer GetFloatArrayElements(float[] array, ByteBuffer isCopy) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)isCopy, 1);
        }
        long __result = JNINativeInterface.nGetFloatArrayElements(array, MemoryUtil.memAddressSafe(isCopy));
        return MemoryUtil.memFloatBuffer(__result, array.length);
    }

    public static native void nReleaseFloatArrayElements(float[] var0, long var1, int var3);

    public static void ReleaseFloatArrayElements(float[] array, FloatBuffer elems, int mode) {
        JNINativeInterface.nReleaseFloatArrayElements(array, MemoryUtil.memAddress(elems), mode);
    }

    public static native long nGetDoubleArrayElements(double[] var0, long var1);

    public static DoubleBuffer GetDoubleArrayElements(double[] array, ByteBuffer isCopy) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)isCopy, 1);
        }
        long __result = JNINativeInterface.nGetDoubleArrayElements(array, MemoryUtil.memAddressSafe(isCopy));
        return MemoryUtil.memDoubleBuffer(__result, array.length);
    }

    public static native void nReleaseDoubleArrayElements(double[] var0, long var1, int var3);

    public static void ReleaseDoubleArrayElements(double[] array, DoubleBuffer elems, int mode) {
        JNINativeInterface.nReleaseDoubleArrayElements(array, MemoryUtil.memAddress(elems), mode);
    }

    public static native void nGetBooleanArrayRegion(byte[] var0, int var1, int var2, long var3);

    public static void GetBooleanArrayRegion(byte[] array, int start, ByteBuffer buf) {
        JNINativeInterface.nGetBooleanArrayRegion(array, start, buf.remaining(), MemoryUtil.memAddress(buf));
    }

    public static native void nSetBooleanArrayRegion(byte[] var0, int var1, int var2, long var3);

    public static void SetBooleanArrayRegion(byte[] array, int start, ByteBuffer buf) {
        JNINativeInterface.nSetBooleanArrayRegion(array, start, buf.remaining(), MemoryUtil.memAddress(buf));
    }

    public static native void nGetByteArrayRegion(byte[] var0, int var1, int var2, long var3);

    public static void GetByteArrayRegion(byte[] array, int start, ByteBuffer buf) {
        JNINativeInterface.nGetByteArrayRegion(array, start, buf.remaining(), MemoryUtil.memAddress(buf));
    }

    public static native void nSetByteArrayRegion(byte[] var0, int var1, int var2, long var3);

    public static void SetByteArrayRegion(byte[] array, int start, ByteBuffer buf) {
        JNINativeInterface.nSetByteArrayRegion(array, start, buf.remaining(), MemoryUtil.memAddress(buf));
    }

    public static native void nGetCharArrayRegion(char[] var0, int var1, int var2, long var3);

    public static void GetCharArrayRegion(char[] array, int start, ShortBuffer buf) {
        JNINativeInterface.nGetCharArrayRegion(array, start, buf.remaining(), MemoryUtil.memAddress(buf));
    }

    public static native void nSetCharArrayRegion(char[] var0, int var1, int var2, long var3);

    public static void SetCharArrayRegion(char[] array, int start, ShortBuffer buf) {
        JNINativeInterface.nSetCharArrayRegion(array, start, buf.remaining(), MemoryUtil.memAddress(buf));
    }

    public static native void nGetShortArrayRegion(short[] var0, int var1, int var2, long var3);

    public static void GetShortArrayRegion(short[] array, int start, ShortBuffer buf) {
        JNINativeInterface.nGetShortArrayRegion(array, start, buf.remaining(), MemoryUtil.memAddress(buf));
    }

    public static native void nSetShortArrayRegion(short[] var0, int var1, int var2, long var3);

    public static void SetShortArrayRegion(short[] array, int start, ShortBuffer buf) {
        JNINativeInterface.nSetShortArrayRegion(array, start, buf.remaining(), MemoryUtil.memAddress(buf));
    }

    public static native void nGetIntArrayRegion(int[] var0, int var1, int var2, long var3);

    public static void GetIntArrayRegion(int[] array, int start, IntBuffer buf) {
        JNINativeInterface.nGetIntArrayRegion(array, start, buf.remaining(), MemoryUtil.memAddress(buf));
    }

    public static native void nSetIntArrayRegion(int[] var0, int var1, int var2, long var3);

    public static void SetIntArrayRegion(int[] array, int start, IntBuffer buf) {
        JNINativeInterface.nSetIntArrayRegion(array, start, buf.remaining(), MemoryUtil.memAddress(buf));
    }

    public static native void nGetLongArrayRegion(long[] var0, int var1, int var2, long var3);

    public static void GetLongArrayRegion(long[] array, int start, LongBuffer buf) {
        JNINativeInterface.nGetLongArrayRegion(array, start, buf.remaining(), MemoryUtil.memAddress(buf));
    }

    public static native void nSetLongArrayRegion(long[] var0, int var1, int var2, long var3);

    public static void SetLongArrayRegion(long[] array, int start, LongBuffer buf) {
        JNINativeInterface.nSetLongArrayRegion(array, start, buf.remaining(), MemoryUtil.memAddress(buf));
    }

    public static native void nGetFloatArrayRegion(float[] var0, int var1, int var2, long var3);

    public static void GetFloatArrayRegion(float[] array, int start, FloatBuffer buf) {
        JNINativeInterface.nGetFloatArrayRegion(array, start, buf.remaining(), MemoryUtil.memAddress(buf));
    }

    public static native void nSetFloatArrayRegion(float[] var0, int var1, int var2, long var3);

    public static void SetFloatArrayRegion(float[] array, int start, FloatBuffer buf) {
        JNINativeInterface.nSetFloatArrayRegion(array, start, buf.remaining(), MemoryUtil.memAddress(buf));
    }

    public static native void nGetDoubleArrayRegion(double[] var0, int var1, int var2, long var3);

    public static void GetDoubleArrayRegion(double[] array, int start, DoubleBuffer buf) {
        JNINativeInterface.nGetDoubleArrayRegion(array, start, buf.remaining(), MemoryUtil.memAddress(buf));
    }

    public static native void nSetDoubleArrayRegion(double[] var0, int var1, int var2, long var3);

    public static void SetDoubleArrayRegion(double[] array, int start, DoubleBuffer buf) {
        JNINativeInterface.nSetDoubleArrayRegion(array, start, buf.remaining(), MemoryUtil.memAddress(buf));
    }

    public static native int nRegisterNatives(Class<?> var0, long var1, int var3);

    public static int RegisterNatives(Class<?> targetClass, JNINativeMethod.Buffer methods) {
        if (Checks.CHECKS) {
            JNINativeMethod.validate(methods.address(), methods.remaining());
        }
        return JNINativeInterface.nRegisterNatives(targetClass, methods.address(), methods.remaining());
    }

    public static native int UnregisterNatives(Class<?> var0);

    public static native int nGetJavaVM(long var0);

    public static int GetJavaVM(PointerBuffer vm) {
        if (Checks.CHECKS) {
            Checks.check(vm, 1);
        }
        return JNINativeInterface.nGetJavaVM(MemoryUtil.memAddress(vm));
    }

    public static native void nGetStringRegion(String var0, int var1, int var2, long var3);

    public static void GetStringRegion(String str, int start, ByteBuffer buf) {
        JNINativeInterface.nGetStringRegion(str, start, buf.remaining() >> 1, MemoryUtil.memAddress(buf));
    }

    public static native void nGetStringUTFRegion(String var0, int var1, int var2, long var3);

    public static void GetStringUTFRegion(String str, int start, int len, ByteBuffer buf) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)buf, len);
        }
        JNINativeInterface.nGetStringUTFRegion(str, start, len, MemoryUtil.memAddress(buf));
    }

    public static native long NewWeakGlobalRef(Object var0);

    public static native void nDeleteWeakGlobalRef(long var0);

    public static void DeleteWeakGlobalRef(long weakGlobalRef) {
        if (Checks.CHECKS) {
            Checks.check(weakGlobalRef);
        }
        JNINativeInterface.nDeleteWeakGlobalRef(weakGlobalRef);
    }

    public static native ByteBuffer nNewDirectByteBuffer(long var0, long var2);

    public static ByteBuffer NewDirectByteBuffer(long address, long capacity) {
        if (Checks.CHECKS) {
            Checks.check(address);
        }
        return JNINativeInterface.nNewDirectByteBuffer(address, capacity);
    }

    public static native long GetDirectBufferAddress(Buffer var0);

    public static native int GetObjectRefType(Object var0);

    static {
        Library.initialize();
    }
}

