/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.jni;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class JNINativeMethod
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int SIGNATURE;
    public static final int FNPTR;

    JNINativeMethod(long address, ByteBuffer container) {
        super(address, container);
    }

    public JNINativeMethod(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), JNINativeMethod.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public ByteBuffer name() {
        return JNINativeMethod.nname(this.address());
    }

    public String nameString() {
        return JNINativeMethod.nnameString(this.address());
    }

    public ByteBuffer signature() {
        return JNINativeMethod.nsignature(this.address());
    }

    public String signatureString() {
        return JNINativeMethod.nsignatureString(this.address());
    }

    public long fnPtr() {
        return JNINativeMethod.nfnPtr(this.address());
    }

    public JNINativeMethod name(ByteBuffer value) {
        JNINativeMethod.nname(this.address(), value);
        return this;
    }

    public JNINativeMethod signature(ByteBuffer value) {
        JNINativeMethod.nsignature(this.address(), value);
        return this;
    }

    public JNINativeMethod fnPtr(long value) {
        JNINativeMethod.nfnPtr(this.address(), value);
        return this;
    }

    public JNINativeMethod set(ByteBuffer name, ByteBuffer signature, long fnPtr) {
        this.name(name);
        this.signature(signature);
        this.fnPtr(fnPtr);
        return this;
    }

    public JNINativeMethod set(JNINativeMethod src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static JNINativeMethod malloc() {
        return JNINativeMethod.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static JNINativeMethod calloc() {
        return JNINativeMethod.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static JNINativeMethod create() {
        return new JNINativeMethod(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static JNINativeMethod create(long address) {
        return address == 0L ? null : new JNINativeMethod(address, null);
    }

    public static Buffer malloc(int capacity) {
        return JNINativeMethod.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return JNINativeMethod.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static JNINativeMethod mallocStack() {
        return JNINativeMethod.mallocStack(MemoryStack.stackGet());
    }

    public static JNINativeMethod callocStack() {
        return JNINativeMethod.callocStack(MemoryStack.stackGet());
    }

    public static JNINativeMethod mallocStack(MemoryStack stack) {
        return JNINativeMethod.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static JNINativeMethod callocStack(MemoryStack stack) {
        return JNINativeMethod.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return JNINativeMethod.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return JNINativeMethod.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return JNINativeMethod.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return JNINativeMethod.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static ByteBuffer nsignature(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)SIGNATURE));
    }

    public static String nsignatureString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)SIGNATURE));
    }

    public static long nfnPtr(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)FNPTR);
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(value);
        }
        MemoryUtil.memPutAddress(struct + (long)NAME, MemoryUtil.memAddress(value));
    }

    public static void nsignature(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(value);
        }
        MemoryUtil.memPutAddress(struct + (long)SIGNATURE, MemoryUtil.memAddress(value));
    }

    public static void nfnPtr(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)FNPTR, Checks.check(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)NAME));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SIGNATURE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)FNPTR));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            JNINativeMethod.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = JNINativeMethod.__struct(JNINativeMethod.__member(POINTER_SIZE), JNINativeMethod.__member(POINTER_SIZE), JNINativeMethod.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        SIGNATURE = layout.offsetof(1);
        FNPTR = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<JNINativeMethod, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected JNINativeMethod newInstance(long address) {
            return new JNINativeMethod(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public ByteBuffer name() {
            return JNINativeMethod.nname(this.address());
        }

        public String nameString() {
            return JNINativeMethod.nnameString(this.address());
        }

        public ByteBuffer signature() {
            return JNINativeMethod.nsignature(this.address());
        }

        public String signatureString() {
            return JNINativeMethod.nsignatureString(this.address());
        }

        public long fnPtr() {
            return JNINativeMethod.nfnPtr(this.address());
        }

        public Buffer name(ByteBuffer value) {
            JNINativeMethod.nname(this.address(), value);
            return this;
        }

        public Buffer signature(ByteBuffer value) {
            JNINativeMethod.nsignature(this.address(), value);
            return this;
        }

        public Buffer fnPtr(long value) {
            JNINativeMethod.nfnPtr(this.address(), value);
            return this;
        }
    }
}

