/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.libc;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;

public class LibCStdlib {
    protected LibCStdlib() {
        throw new UnsupportedOperationException();
    }

    public static native long nmalloc(long var0);

    public static ByteBuffer malloc(long size) {
        long __result = LibCStdlib.nmalloc(size);
        return MemoryUtil.memByteBuffer(__result, (int)size);
    }

    public static native long ncalloc(long var0, long var2);

    public static ByteBuffer calloc(long nmemb, long size) {
        long __result = LibCStdlib.ncalloc(nmemb, size);
        return MemoryUtil.memByteBuffer(__result, (int)nmemb * (int)size);
    }

    public static native long nrealloc(long var0, long var2);

    public static ByteBuffer realloc(ByteBuffer ptr, long size) {
        long __result = LibCStdlib.nrealloc(MemoryUtil.memAddressSafe(ptr), size);
        return MemoryUtil.memByteBuffer(__result, (int)size);
    }

    public static native void nfree(long var0);

    public static void free(ByteBuffer ptr) {
        LibCStdlib.nfree(MemoryUtil.memAddressSafe(ptr));
    }

    public static void free(ShortBuffer ptr) {
        LibCStdlib.nfree(MemoryUtil.memAddressSafe(ptr));
    }

    public static void free(IntBuffer ptr) {
        LibCStdlib.nfree(MemoryUtil.memAddressSafe(ptr));
    }

    public static void free(LongBuffer ptr) {
        LibCStdlib.nfree(MemoryUtil.memAddressSafe(ptr));
    }

    public static void free(FloatBuffer ptr) {
        LibCStdlib.nfree(MemoryUtil.memAddressSafe(ptr));
    }

    public static void free(DoubleBuffer ptr) {
        LibCStdlib.nfree(MemoryUtil.memAddressSafe(ptr));
    }

    public static void free(PointerBuffer ptr) {
        LibCStdlib.nfree(MemoryUtil.memAddressSafe(ptr));
    }

    public static native long naligned_alloc(long var0, long var2);

    public static ByteBuffer aligned_alloc(long alignment, long size) {
        long __result = LibCStdlib.naligned_alloc(alignment, size);
        return MemoryUtil.memByteBuffer(__result, (int)size);
    }

    public static native void naligned_free(long var0);

    public static void aligned_free(ByteBuffer ptr) {
        LibCStdlib.naligned_free(MemoryUtil.memAddressSafe(ptr));
    }

    public static void aligned_free(ShortBuffer ptr) {
        LibCStdlib.naligned_free(MemoryUtil.memAddressSafe(ptr));
    }

    public static void aligned_free(IntBuffer ptr) {
        LibCStdlib.naligned_free(MemoryUtil.memAddressSafe(ptr));
    }

    public static void aligned_free(LongBuffer ptr) {
        LibCStdlib.naligned_free(MemoryUtil.memAddressSafe(ptr));
    }

    public static void aligned_free(FloatBuffer ptr) {
        LibCStdlib.naligned_free(MemoryUtil.memAddressSafe(ptr));
    }

    public static void aligned_free(DoubleBuffer ptr) {
        LibCStdlib.naligned_free(MemoryUtil.memAddressSafe(ptr));
    }

    public static void aligned_free(PointerBuffer ptr) {
        LibCStdlib.naligned_free(MemoryUtil.memAddressSafe(ptr));
    }

    static {
        Library.initialize();
    }
}

