/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.libc;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;

public class LibCString {
    protected LibCString() {
        throw new UnsupportedOperationException();
    }

    public static native long nmemset(long var0, int var2, long var3);

    public static long memset(ByteBuffer dest, int c) {
        return LibCString.nmemset(MemoryUtil.memAddress(dest), c, (long)dest.remaining());
    }

    public static long memset(ShortBuffer dest, int c) {
        return LibCString.nmemset(MemoryUtil.memAddress(dest), c, (long)(dest.remaining() << 1));
    }

    public static long memset(IntBuffer dest, int c) {
        return LibCString.nmemset(MemoryUtil.memAddress(dest), c, (long)(dest.remaining() << 2));
    }

    public static long memset(LongBuffer dest, int c) {
        return LibCString.nmemset(MemoryUtil.memAddress(dest), c, (long)(dest.remaining() << 3));
    }

    public static long memset(FloatBuffer dest, int c) {
        return LibCString.nmemset(MemoryUtil.memAddress(dest), c, (long)(dest.remaining() << 2));
    }

    public static long memset(DoubleBuffer dest, int c) {
        return LibCString.nmemset(MemoryUtil.memAddress(dest), c, (long)(dest.remaining() << 3));
    }

    public static native long nmemcpy(long var0, long var2, long var4);

    public static long memcpy(ByteBuffer dest, ByteBuffer src) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)src, dest.remaining());
        }
        return LibCString.nmemcpy(MemoryUtil.memAddress(dest), MemoryUtil.memAddress(src), (long)dest.remaining());
    }

    public static long memcpy(ShortBuffer dest, ShortBuffer src) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)src, dest.remaining());
        }
        return LibCString.nmemcpy(MemoryUtil.memAddress(dest), MemoryUtil.memAddress(src), (long)(src.remaining() << 1));
    }

    public static long memcpy(IntBuffer dest, IntBuffer src) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)src, dest.remaining());
        }
        return LibCString.nmemcpy(MemoryUtil.memAddress(dest), MemoryUtil.memAddress(src), (long)(src.remaining() << 2));
    }

    public static long memcpy(LongBuffer dest, LongBuffer src) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)src, dest.remaining());
        }
        return LibCString.nmemcpy(MemoryUtil.memAddress(dest), MemoryUtil.memAddress(src), (long)(src.remaining() << 3));
    }

    public static long memcpy(FloatBuffer dest, FloatBuffer src) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)src, dest.remaining());
        }
        return LibCString.nmemcpy(MemoryUtil.memAddress(dest), MemoryUtil.memAddress(src), (long)(src.remaining() << 2));
    }

    public static long memcpy(DoubleBuffer dest, DoubleBuffer src) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)src, dest.remaining());
        }
        return LibCString.nmemcpy(MemoryUtil.memAddress(dest), MemoryUtil.memAddress(src), (long)(src.remaining() << 3));
    }

    public static native long nmemset(byte[] var0, int var1, long var2);

    public static long memset(byte[] dest, int c) {
        return LibCString.nmemset(dest, c, (long)(dest.length << 0));
    }

    public static native long nmemset(short[] var0, int var1, long var2);

    public static long memset(short[] dest, int c) {
        return LibCString.nmemset(dest, c, (long)(dest.length << 1));
    }

    public static native long nmemset(int[] var0, int var1, long var2);

    public static long memset(int[] dest, int c) {
        return LibCString.nmemset(dest, c, (long)(dest.length << 2));
    }

    public static native long nmemset(long[] var0, int var1, long var2);

    public static long memset(long[] dest, int c) {
        return LibCString.nmemset(dest, c, (long)(dest.length << 3));
    }

    public static native long nmemset(float[] var0, int var1, long var2);

    public static long memset(float[] dest, int c) {
        return LibCString.nmemset(dest, c, (long)(dest.length << 2));
    }

    public static native long nmemset(double[] var0, int var1, long var2);

    public static long memset(double[] dest, int c) {
        return LibCString.nmemset(dest, c, (long)(dest.length << 3));
    }

    public static native long nmemcpy(byte[] var0, byte[] var1, long var2);

    public static long memcpy(byte[] dest, byte[] src) {
        if (Checks.CHECKS) {
            Checks.check(src, dest.length);
        }
        return LibCString.nmemcpy(dest, src, (long)(dest.length << 0));
    }

    public static native long nmemcpy(short[] var0, short[] var1, long var2);

    public static long memcpy(short[] dest, short[] src) {
        if (Checks.CHECKS) {
            Checks.check(src, dest.length);
        }
        return LibCString.nmemcpy(dest, src, (long)(dest.length << 1));
    }

    public static native long nmemcpy(int[] var0, int[] var1, long var2);

    public static long memcpy(int[] dest, int[] src) {
        if (Checks.CHECKS) {
            Checks.check(src, dest.length);
        }
        return LibCString.nmemcpy(dest, src, (long)(dest.length << 2));
    }

    public static native long nmemcpy(long[] var0, long[] var1, long var2);

    public static long memcpy(long[] dest, long[] src) {
        if (Checks.CHECKS) {
            Checks.check(src, dest.length);
        }
        return LibCString.nmemcpy(dest, src, (long)(dest.length << 3));
    }

    public static native long nmemcpy(float[] var0, float[] var1, long var2);

    public static long memcpy(float[] dest, float[] src) {
        if (Checks.CHECKS) {
            Checks.check(src, dest.length);
        }
        return LibCString.nmemcpy(dest, src, (long)(dest.length << 2));
    }

    public static native long nmemcpy(double[] var0, double[] var1, long var2);

    public static long memcpy(double[] dest, double[] src) {
        if (Checks.CHECKS) {
            Checks.check(src, dest.length);
        }
        return LibCString.nmemcpy(dest, src, (long)(dest.length << 3));
    }

    static {
        Library.initialize();
    }
}

