/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class WinBase {
    public static final int FALSE = 0;
    public static final int TRUE = 1;

    protected WinBase() {
        throw new UnsupportedOperationException();
    }

    public static native int GetLastError();

    public static native int getLastError();

    public static native long nGetModuleHandle(long var0);

    public static long GetModuleHandle(ByteBuffer moduleName) {
        if (Checks.CHECKS) {
            Checks.checkNT2Safe(moduleName);
        }
        return WinBase.nGetModuleHandle(MemoryUtil.memAddressSafe(moduleName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long GetModuleHandle(CharSequence moduleName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer moduleNameEncoded = stack.UTF16(moduleName);
            long l = WinBase.nGetModuleHandle(MemoryUtil.memAddressSafe(moduleNameEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nLoadLibrary(long var0);

    public static long LoadLibrary(ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT2(name);
        }
        return WinBase.nLoadLibrary(MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long LoadLibrary(CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF16(name);
            long l = WinBase.nLoadLibrary(MemoryUtil.memAddress(nameEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nGetProcAddress(long var0, long var2);

    public static long GetProcAddress(long handle, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.check(handle);
            Checks.checkNT1(name);
        }
        return WinBase.nGetProcAddress(handle, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long GetProcAddress(long handle, CharSequence name) {
        if (Checks.CHECKS) {
            Checks.check(handle);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            long l = WinBase.nGetProcAddress(handle, MemoryUtil.memAddress(nameEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nFreeLibrary(long var0);

    public static boolean FreeLibrary(long handle) {
        if (Checks.CHECKS) {
            Checks.check(handle);
        }
        return WinBase.nFreeLibrary(handle) != 0;
    }

    static {
        Library.initialize();
    }
}

