/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lmdb;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;
import org.lwjgl.util.lmdb.MDBCmpFuncI;
import org.lwjgl.util.lmdb.MDBEnvInfo;
import org.lwjgl.util.lmdb.MDBMsgFuncI;
import org.lwjgl.util.lmdb.MDBRelFuncI;
import org.lwjgl.util.lmdb.MDBStat;
import org.lwjgl.util.lmdb.MDBVal;

public class LMDB {
    public static final int MDB_FIXEDMAP = 1;
    public static final int MDB_NOSUBDIR = 16384;
    public static final int MDB_NOSYNC = 65536;
    public static final int MDB_RDONLY = 131072;
    public static final int MDB_NOMETASYNC = 262144;
    public static final int MDB_WRITEMAP = 524288;
    public static final int MDB_MAPASYNC = 0x100000;
    public static final int MDB_NOTLS = 0x200000;
    public static final int MDB_NOLOCK = 0x400000;
    public static final int MDB_NORDAHEAD = 0x800000;
    public static final int MDB_NOMEMINIT = 0x1000000;
    public static final int MDB_REVERSEKEY = 2;
    public static final int MDB_DUPSORT = 4;
    public static final int MDB_INTEGERKEY = 8;
    public static final int MDB_DUPFIXED = 16;
    public static final int MDB_INTEGERDUP = 32;
    public static final int MDB_REVERSEDUP = 64;
    public static final int MDB_CREATE = 262144;
    public static final int MDB_NOOVERWRITE = 16;
    public static final int MDB_NODUPDATA = 32;
    public static final int MDB_CURRENT = 64;
    public static final int MDB_RESERVE = 65536;
    public static final int MDB_APPEND = 131072;
    public static final int MDB_APPENDDUP = 262144;
    public static final int MDB_MULTIPLE = 524288;
    public static final int MDB_CP_COMPACT = 1;
    public static final int MDB_FIRST = 0;
    public static final int MDB_FIRST_DUP = 1;
    public static final int MDB_GET_BOTH = 2;
    public static final int MDB_GET_BOTH_RANGE = 3;
    public static final int MDB_GET_CURRENT = 4;
    public static final int MDB_GET_MULTIPLE = 5;
    public static final int MDB_LAST = 6;
    public static final int MDB_LAST_DUP = 7;
    public static final int MDB_NEXT = 8;
    public static final int MDB_NEXT_DUP = 9;
    public static final int MDB_NEXT_MULTIPLE = 10;
    public static final int MDB_NEXT_NODUP = 11;
    public static final int MDB_PREV = 12;
    public static final int MDB_PREV_DUP = 13;
    public static final int MDB_PREV_NODUP = 14;
    public static final int MDB_SET = 15;
    public static final int MDB_SET_KEY = 16;
    public static final int MDB_SET_RANGE = 17;
    public static final int MDB_PREV_MULTIPLE = 18;
    public static final int MDB_SUCCESS = 0;
    public static final int MDB_KEYEXIST = -30799;
    public static final int MDB_NOTFOUND = -30798;
    public static final int MDB_PAGE_NOTFOUND = -30797;
    public static final int MDB_CORRUPTED = -30796;
    public static final int MDB_PANIC = -30795;
    public static final int MDB_VERSION_MISMATCH = -30794;
    public static final int MDB_INVALID = -30793;
    public static final int MDB_MAP_FULL = -30792;
    public static final int MDB_DBS_FULL = -30791;
    public static final int MDB_READERS_FULL = -30790;
    public static final int MDB_TLS_FULL = -30789;
    public static final int MDB_TXN_FULL = -30788;
    public static final int MDB_CURSOR_FULL = -30787;
    public static final int MDB_PAGE_FULL = -30786;
    public static final int MDB_MAP_RESIZED = -30785;
    public static final int MDB_INCOMPATIBLE = -30784;
    public static final int MDB_BAD_RSLOT = -30783;
    public static final int MDB_BAD_TXN = -30782;
    public static final int MDB_BAD_VALSIZE = -30781;
    public static final int MDB_BAD_DBI = -30780;
    public static final int MDB_PROBLEM = -30779;
    public static final int MDB_LAST_ERRCODE = -30779;

    protected LMDB() {
        throw new UnsupportedOperationException();
    }

    public static native long nmdb_version(long var0, long var2, long var4);

    public static String mdb_version(IntBuffer major, IntBuffer minor, IntBuffer patch) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)major, 1);
            Checks.checkSafe((Buffer)minor, 1);
            Checks.checkSafe((Buffer)patch, 1);
        }
        long __result = LMDB.nmdb_version(MemoryUtil.memAddressSafe(major), MemoryUtil.memAddressSafe(minor), MemoryUtil.memAddressSafe(patch));
        return MemoryUtil.memASCII(__result);
    }

    public static native long nmdb_strerror(int var0);

    public static String mdb_strerror(int err) {
        long __result = LMDB.nmdb_strerror(err);
        return MemoryUtil.memASCII(__result);
    }

    public static native int nmdb_env_create(long var0);

    public static int mdb_env_create(PointerBuffer env) {
        if (Checks.CHECKS) {
            Checks.check(env, 1);
        }
        return LMDB.nmdb_env_create(MemoryUtil.memAddress(env));
    }

    public static native int nmdb_env_open(long var0, long var2, int var4, int var5);

    public static int mdb_env_open(long env, ByteBuffer path, int flags, int mode) {
        if (Checks.CHECKS) {
            Checks.check(env);
            Checks.checkNT1(path);
        }
        return LMDB.nmdb_env_open(env, MemoryUtil.memAddress(path), flags, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int mdb_env_open(long env, CharSequence path, int flags, int mode) {
        if (Checks.CHECKS) {
            Checks.check(env);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pathEncoded = stack.UTF8(path);
            int n = LMDB.nmdb_env_open(env, MemoryUtil.memAddress(pathEncoded), flags, mode);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nmdb_env_copy(long var0, long var2);

    public static int mdb_env_copy(long env, ByteBuffer path) {
        if (Checks.CHECKS) {
            Checks.check(env);
            Checks.checkNT1(path);
        }
        return LMDB.nmdb_env_copy(env, MemoryUtil.memAddress(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int mdb_env_copy(long env, CharSequence path) {
        if (Checks.CHECKS) {
            Checks.check(env);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pathEncoded = stack.UTF8(path);
            int n = LMDB.nmdb_env_copy(env, MemoryUtil.memAddress(pathEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nmdb_env_copy2(long var0, long var2, int var4);

    public static int mdb_env_copy2(long env, ByteBuffer path, int flags) {
        if (Checks.CHECKS) {
            Checks.check(env);
            Checks.checkNT1(path);
        }
        return LMDB.nmdb_env_copy2(env, MemoryUtil.memAddress(path), flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int mdb_env_copy2(long env, CharSequence path, int flags) {
        if (Checks.CHECKS) {
            Checks.check(env);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pathEncoded = stack.UTF8(path);
            int n = LMDB.nmdb_env_copy2(env, MemoryUtil.memAddress(pathEncoded), flags);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nmdb_env_stat(long var0, long var2);

    public static int mdb_env_stat(long env, MDBStat stat) {
        if (Checks.CHECKS) {
            Checks.check(env);
        }
        return LMDB.nmdb_env_stat(env, stat.address());
    }

    public static native int nmdb_env_info(long var0, long var2);

    public static int mdb_env_info(long env, MDBEnvInfo stat) {
        if (Checks.CHECKS) {
            Checks.check(env);
        }
        return LMDB.nmdb_env_info(env, stat.address());
    }

    public static native int nmdb_env_sync(long var0, int var2);

    public static int mdb_env_sync(long env, boolean force) {
        if (Checks.CHECKS) {
            Checks.check(env);
        }
        return LMDB.nmdb_env_sync(env, force ? 1 : 0);
    }

    public static native void nmdb_env_close(long var0);

    public static void mdb_env_close(long env) {
        if (Checks.CHECKS) {
            Checks.check(env);
        }
        LMDB.nmdb_env_close(env);
    }

    public static native int nmdb_env_set_flags(long var0, int var2, int var3);

    public static int mdb_env_set_flags(long env, int flags, boolean onoff) {
        if (Checks.CHECKS) {
            Checks.check(env);
        }
        return LMDB.nmdb_env_set_flags(env, flags, onoff ? 1 : 0);
    }

    public static native int nmdb_env_get_flags(long var0, long var2);

    public static int mdb_env_get_flags(long env, IntBuffer flags) {
        if (Checks.CHECKS) {
            Checks.check(env);
            Checks.check((Buffer)flags, 1);
        }
        return LMDB.nmdb_env_get_flags(env, MemoryUtil.memAddress(flags));
    }

    public static native int nmdb_env_get_path(long var0, long var2);

    public static int mdb_env_get_path(long env, PointerBuffer path) {
        if (Checks.CHECKS) {
            Checks.check(env);
            Checks.check(path, 1);
        }
        return LMDB.nmdb_env_get_path(env, MemoryUtil.memAddress(path));
    }

    public static native int nmdb_env_set_mapsize(long var0, long var2);

    public static int mdb_env_set_mapsize(long env, long size) {
        if (Checks.CHECKS) {
            Checks.check(env);
        }
        return LMDB.nmdb_env_set_mapsize(env, size);
    }

    public static native int nmdb_env_set_maxreaders(long var0, int var2);

    public static int mdb_env_set_maxreaders(long env, int readers) {
        if (Checks.CHECKS) {
            Checks.check(env);
        }
        return LMDB.nmdb_env_set_maxreaders(env, readers);
    }

    public static native int nmdb_env_get_maxreaders(long var0, long var2);

    public static int mdb_env_get_maxreaders(long env, IntBuffer readers) {
        if (Checks.CHECKS) {
            Checks.check(env);
            Checks.check((Buffer)readers, 1);
        }
        return LMDB.nmdb_env_get_maxreaders(env, MemoryUtil.memAddress(readers));
    }

    public static native int nmdb_env_set_maxdbs(long var0, int var2);

    public static int mdb_env_set_maxdbs(long env, int dbs) {
        if (Checks.CHECKS) {
            Checks.check(env);
        }
        return LMDB.nmdb_env_set_maxdbs(env, dbs);
    }

    public static native int nmdb_env_get_maxkeysize(long var0);

    public static int mdb_env_get_maxkeysize(long env) {
        if (Checks.CHECKS) {
            Checks.check(env);
        }
        return LMDB.nmdb_env_get_maxkeysize(env);
    }

    public static native int nmdb_env_set_userctx(long var0, long var2);

    public static int mdb_env_set_userctx(long env, long ctx) {
        if (Checks.CHECKS) {
            Checks.check(env);
            Checks.check(ctx);
        }
        return LMDB.nmdb_env_set_userctx(env, ctx);
    }

    public static native long nmdb_env_get_userctx(long var0);

    public static long mdb_env_get_userctx(long env) {
        if (Checks.CHECKS) {
            Checks.check(env);
        }
        return LMDB.nmdb_env_get_userctx(env);
    }

    public static native int nmdb_txn_begin(long var0, long var2, int var4, long var5);

    public static int mdb_txn_begin(long env, long parent, int flags, PointerBuffer txn) {
        if (Checks.CHECKS) {
            Checks.check(env);
            Checks.check(txn, 1);
        }
        return LMDB.nmdb_txn_begin(env, parent, flags, MemoryUtil.memAddress(txn));
    }

    public static native long nmdb_txn_env(long var0);

    public static long mdb_txn_env(long txn) {
        if (Checks.CHECKS) {
            Checks.check(txn);
        }
        return LMDB.nmdb_txn_env(txn);
    }

    public static native long nmdb_txn_id(long var0);

    public static long mdb_txn_id(long txn) {
        if (Checks.CHECKS) {
            Checks.check(txn);
        }
        return LMDB.nmdb_txn_id(txn);
    }

    public static native int nmdb_txn_commit(long var0);

    public static int mdb_txn_commit(long txn) {
        if (Checks.CHECKS) {
            Checks.check(txn);
        }
        return LMDB.nmdb_txn_commit(txn);
    }

    public static native void nmdb_txn_abort(long var0);

    public static void mdb_txn_abort(long txn) {
        if (Checks.CHECKS) {
            Checks.check(txn);
        }
        LMDB.nmdb_txn_abort(txn);
    }

    public static native void nmdb_txn_reset(long var0);

    public static void mdb_txn_reset(long txn) {
        if (Checks.CHECKS) {
            Checks.check(txn);
        }
        LMDB.nmdb_txn_reset(txn);
    }

    public static native int nmdb_txn_renew(long var0);

    public static int mdb_txn_renew(long txn) {
        if (Checks.CHECKS) {
            Checks.check(txn);
        }
        return LMDB.nmdb_txn_renew(txn);
    }

    public static native int nmdb_dbi_open(long var0, long var2, int var4, long var5);

    public static int mdb_dbi_open(long txn, ByteBuffer name, int flags, IntBuffer dbi) {
        if (Checks.CHECKS) {
            Checks.check(txn);
            Checks.checkNT1Safe(name);
            Checks.check((Buffer)dbi, 1);
        }
        return LMDB.nmdb_dbi_open(txn, MemoryUtil.memAddressSafe(name), flags, MemoryUtil.memAddress(dbi));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int mdb_dbi_open(long txn, CharSequence name, int flags, IntBuffer dbi) {
        if (Checks.CHECKS) {
            Checks.check(txn);
            Checks.check((Buffer)dbi, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            int n = LMDB.nmdb_dbi_open(txn, MemoryUtil.memAddressSafe(nameEncoded), flags, MemoryUtil.memAddress(dbi));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nmdb_stat(long var0, int var2, long var3);

    public static int mdb_stat(long txn, int dbi, MDBStat stat) {
        if (Checks.CHECKS) {
            Checks.check(txn);
        }
        return LMDB.nmdb_stat(txn, dbi, stat.address());
    }

    public static native int nmdb_dbi_flags(long var0, int var2, long var3);

    public static int mdb_dbi_flags(long txn, int dbi, IntBuffer flags) {
        if (Checks.CHECKS) {
            Checks.check(txn);
            Checks.check((Buffer)flags, 1);
        }
        return LMDB.nmdb_dbi_flags(txn, dbi, MemoryUtil.memAddress(flags));
    }

    public static native void nmdb_dbi_close(long var0, int var2);

    public static void mdb_dbi_close(long env, int dbi) {
        if (Checks.CHECKS) {
            Checks.check(env);
        }
        LMDB.nmdb_dbi_close(env, dbi);
    }

    public static native int nmdb_drop(long var0, int var2, int var3);

    public static int mdb_drop(long txn, int dbi, boolean del) {
        if (Checks.CHECKS) {
            Checks.check(txn);
        }
        return LMDB.nmdb_drop(txn, dbi, del ? 1 : 0);
    }

    public static native int nmdb_set_compare(long var0, int var2, long var3);

    public static int mdb_set_compare(long txn, int dbi, MDBCmpFuncI cmp) {
        if (Checks.CHECKS) {
            Checks.check(txn);
        }
        return LMDB.nmdb_set_compare(txn, dbi, cmp.address());
    }

    public static native int nmdb_set_dupsort(long var0, int var2, long var3);

    public static int mdb_set_dupsort(long txn, int dbi, MDBCmpFuncI cmp) {
        if (Checks.CHECKS) {
            Checks.check(txn);
        }
        return LMDB.nmdb_set_dupsort(txn, dbi, cmp.address());
    }

    public static native int nmdb_set_relfunc(long var0, int var2, long var3);

    public static int mdb_set_relfunc(long txn, int dbi, MDBRelFuncI rel) {
        if (Checks.CHECKS) {
            Checks.check(txn);
        }
        return LMDB.nmdb_set_relfunc(txn, dbi, rel.address());
    }

    public static native int nmdb_set_relctx(long var0, int var2, long var3);

    public static int mdb_set_relctx(long txn, int dbi, long ctx) {
        if (Checks.CHECKS) {
            Checks.check(txn);
            Checks.check(ctx);
        }
        return LMDB.nmdb_set_relctx(txn, dbi, ctx);
    }

    public static native int nmdb_get(long var0, int var2, long var3, long var5);

    public static int mdb_get(long txn, int dbi, MDBVal key, MDBVal data) {
        if (Checks.CHECKS) {
            Checks.check(txn);
        }
        return LMDB.nmdb_get(txn, dbi, key.address(), data.address());
    }

    public static native int nmdb_put(long var0, int var2, long var3, long var5, int var7);

    public static int mdb_put(long txn, int dbi, MDBVal key, MDBVal data, int flags) {
        if (Checks.CHECKS) {
            Checks.check(txn);
        }
        return LMDB.nmdb_put(txn, dbi, key.address(), data.address(), flags);
    }

    public static native int nmdb_del(long var0, int var2, long var3, long var5);

    public static int mdb_del(long txn, int dbi, MDBVal key, MDBVal data) {
        if (Checks.CHECKS) {
            Checks.check(txn);
        }
        return LMDB.nmdb_del(txn, dbi, key.address(), MemoryUtil.memAddressSafe(data));
    }

    public static native int nmdb_cursor_open(long var0, int var2, long var3);

    public static int mdb_cursor_open(long txn, int dbi, PointerBuffer cursor) {
        if (Checks.CHECKS) {
            Checks.check(txn);
            Checks.check(cursor, 1);
        }
        return LMDB.nmdb_cursor_open(txn, dbi, MemoryUtil.memAddress(cursor));
    }

    public static native void nmdb_cursor_close(long var0);

    public static void mdb_cursor_close(long cursor) {
        if (Checks.CHECKS) {
            Checks.check(cursor);
        }
        LMDB.nmdb_cursor_close(cursor);
    }

    public static native int nmdb_cursor_renew(long var0, long var2);

    public static int mdb_cursor_renew(long txn, long cursor) {
        if (Checks.CHECKS) {
            Checks.check(txn);
            Checks.check(cursor);
        }
        return LMDB.nmdb_cursor_renew(txn, cursor);
    }

    public static native long nmdb_cursor_txn(long var0);

    public static long mdb_cursor_txn(long cursor) {
        if (Checks.CHECKS) {
            Checks.check(cursor);
        }
        return LMDB.nmdb_cursor_txn(cursor);
    }

    public static native int nmdb_cursor_dbi(long var0);

    public static int mdb_cursor_dbi(long cursor) {
        if (Checks.CHECKS) {
            Checks.check(cursor);
        }
        return LMDB.nmdb_cursor_dbi(cursor);
    }

    public static native int nmdb_cursor_get(long var0, long var2, long var4, int var6);

    public static int mdb_cursor_get(long cursor, MDBVal key, MDBVal data, int op) {
        if (Checks.CHECKS) {
            Checks.check(cursor);
        }
        return LMDB.nmdb_cursor_get(cursor, key.address(), data.address(), op);
    }

    public static native int nmdb_cursor_put(long var0, long var2, long var4, int var6);

    public static int mdb_cursor_put(long cursor, MDBVal key, MDBVal data, int flags) {
        if (Checks.CHECKS) {
            Checks.check(cursor);
        }
        return LMDB.nmdb_cursor_put(cursor, key.address(), data.address(), flags);
    }

    public static native int nmdb_cursor_del(long var0, int var2);

    public static int mdb_cursor_del(long cursor, int flags) {
        if (Checks.CHECKS) {
            Checks.check(cursor);
        }
        return LMDB.nmdb_cursor_del(cursor, flags);
    }

    public static native int nmdb_cursor_count(long var0, long var2);

    public static int mdb_cursor_count(long cursor, PointerBuffer countp) {
        if (Checks.CHECKS) {
            Checks.check(cursor);
            Checks.check(countp, 1);
        }
        return LMDB.nmdb_cursor_count(cursor, MemoryUtil.memAddress(countp));
    }

    public static native int nmdb_cmp(long var0, int var2, long var3, long var5);

    public static int mdb_cmp(long txn, int dbi, MDBVal a, MDBVal b) {
        if (Checks.CHECKS) {
            Checks.check(txn);
        }
        return LMDB.nmdb_cmp(txn, dbi, a.address(), b.address());
    }

    public static native int nmdb_dcmp(long var0, int var2, long var3, long var5);

    public static int mdb_dcmp(long txn, int dbi, MDBVal a, MDBVal b) {
        if (Checks.CHECKS) {
            Checks.check(txn);
        }
        return LMDB.nmdb_dcmp(txn, dbi, a.address(), b.address());
    }

    public static native int nmdb_reader_list(long var0, long var2, long var4);

    public static int mdb_reader_list(long env, MDBMsgFuncI func, long ctx) {
        if (Checks.CHECKS) {
            Checks.check(env);
            Checks.check(ctx);
        }
        return LMDB.nmdb_reader_list(env, func.address(), ctx);
    }

    public static native int nmdb_reader_check(long var0, long var2);

    public static int mdb_reader_check(long env, IntBuffer dead) {
        if (Checks.CHECKS) {
            Checks.check(env);
            Checks.check((Buffer)dead, 1);
        }
        return LMDB.nmdb_reader_check(env, MemoryUtil.memAddress(dead));
    }

    public static native long nmdb_version(int[] var0, int[] var1, int[] var2);

    public static String mdb_version(int[] major, int[] minor, int[] patch) {
        if (Checks.CHECKS) {
            Checks.checkSafe(major, 1);
            Checks.checkSafe(minor, 1);
            Checks.checkSafe(patch, 1);
        }
        long __result = LMDB.nmdb_version(major, minor, patch);
        return MemoryUtil.memASCII(__result);
    }

    public static native int nmdb_env_get_flags(long var0, int[] var2);

    public static int mdb_env_get_flags(long env, int[] flags) {
        if (Checks.CHECKS) {
            Checks.check(env);
            Checks.check(flags, 1);
        }
        return LMDB.nmdb_env_get_flags(env, flags);
    }

    public static native int nmdb_env_get_maxreaders(long var0, int[] var2);

    public static int mdb_env_get_maxreaders(long env, int[] readers) {
        if (Checks.CHECKS) {
            Checks.check(env);
            Checks.check(readers, 1);
        }
        return LMDB.nmdb_env_get_maxreaders(env, readers);
    }

    public static native int nmdb_dbi_open(long var0, long var2, int var4, int[] var5);

    public static int mdb_dbi_open(long txn, ByteBuffer name, int flags, int[] dbi) {
        if (Checks.CHECKS) {
            Checks.check(txn);
            Checks.checkNT1Safe(name);
            Checks.check(dbi, 1);
        }
        return LMDB.nmdb_dbi_open(txn, MemoryUtil.memAddressSafe(name), flags, dbi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int mdb_dbi_open(long txn, CharSequence name, int flags, int[] dbi) {
        if (Checks.CHECKS) {
            Checks.check(txn);
            Checks.check(dbi, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            int n = LMDB.nmdb_dbi_open(txn, MemoryUtil.memAddressSafe(nameEncoded), flags, dbi);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nmdb_dbi_flags(long var0, int var2, int[] var3);

    public static int mdb_dbi_flags(long txn, int dbi, int[] flags) {
        if (Checks.CHECKS) {
            Checks.check(txn);
            Checks.check(flags, 1);
        }
        return LMDB.nmdb_dbi_flags(txn, dbi, flags);
    }

    public static native int nmdb_reader_check(long var0, int[] var2);

    public static int mdb_reader_check(long env, int[] dead) {
        if (Checks.CHECKS) {
            Checks.check(env);
            Checks.check(dead, 1);
        }
        return LMDB.nmdb_reader_check(env, dead);
    }

    static {
        Library.loadSystem(System::load, System::loadLibrary, LMDB.class, Platform.mapLibraryNameBundled("lwjgl_lmdb"));
    }
}

