/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lmdb;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class MDBStat
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MS_PSIZE;
    public static final int MS_DEPTH;
    public static final int MS_BRANCH_PAGES;
    public static final int MS_LEAF_PAGES;
    public static final int MS_OVERFLOW_PAGES;
    public static final int MS_ENTRIES;

    MDBStat(long address, ByteBuffer container) {
        super(address, container);
    }

    public MDBStat(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), MDBStat.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int ms_psize() {
        return MDBStat.nms_psize(this.address());
    }

    public int ms_depth() {
        return MDBStat.nms_depth(this.address());
    }

    public long ms_branch_pages() {
        return MDBStat.nms_branch_pages(this.address());
    }

    public long ms_leaf_pages() {
        return MDBStat.nms_leaf_pages(this.address());
    }

    public long ms_overflow_pages() {
        return MDBStat.nms_overflow_pages(this.address());
    }

    public long ms_entries() {
        return MDBStat.nms_entries(this.address());
    }

    public static MDBStat malloc() {
        return MDBStat.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static MDBStat calloc() {
        return MDBStat.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static MDBStat create() {
        return new MDBStat(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static MDBStat create(long address) {
        return address == 0L ? null : new MDBStat(address, null);
    }

    public static Buffer malloc(int capacity) {
        return MDBStat.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return MDBStat.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static MDBStat mallocStack() {
        return MDBStat.mallocStack(MemoryStack.stackGet());
    }

    public static MDBStat callocStack() {
        return MDBStat.callocStack(MemoryStack.stackGet());
    }

    public static MDBStat mallocStack(MemoryStack stack) {
        return MDBStat.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static MDBStat callocStack(MemoryStack stack) {
        return MDBStat.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return MDBStat.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return MDBStat.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return MDBStat.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return MDBStat.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nms_psize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MS_PSIZE);
    }

    public static int nms_depth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MS_DEPTH);
    }

    public static long nms_branch_pages(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)MS_BRANCH_PAGES);
    }

    public static long nms_leaf_pages(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)MS_LEAF_PAGES);
    }

    public static long nms_overflow_pages(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)MS_OVERFLOW_PAGES);
    }

    public static long nms_entries(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)MS_ENTRIES);
    }

    static {
        Struct.Layout layout = MDBStat.__struct(MDBStat.__member(4), MDBStat.__member(4), MDBStat.__member(POINTER_SIZE), MDBStat.__member(POINTER_SIZE), MDBStat.__member(POINTER_SIZE), MDBStat.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MS_PSIZE = layout.offsetof(0);
        MS_DEPTH = layout.offsetof(1);
        MS_BRANCH_PAGES = layout.offsetof(2);
        MS_LEAF_PAGES = layout.offsetof(3);
        MS_OVERFLOW_PAGES = layout.offsetof(4);
        MS_ENTRIES = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<MDBStat, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected MDBStat newInstance(long address) {
            return new MDBStat(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int ms_psize() {
            return MDBStat.nms_psize(this.address());
        }

        public int ms_depth() {
            return MDBStat.nms_depth(this.address());
        }

        public long ms_branch_pages() {
            return MDBStat.nms_branch_pages(this.address());
        }

        public long ms_leaf_pages() {
            return MDBStat.nms_leaf_pages(this.address());
        }

        public long ms_overflow_pages() {
            return MDBStat.nms_overflow_pages(this.address());
        }

        public long ms_entries() {
            return MDBStat.nms_entries(this.address());
        }
    }
}

