/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.tinyexr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class EXRAttribute
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int TYPE;
    public static final int VALUE;
    public static final int SIZE;

    EXRAttribute(long address, ByteBuffer container) {
        super(address, container);
    }

    public EXRAttribute(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), EXRAttribute.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public ByteBuffer name() {
        return EXRAttribute.nname(this.address());
    }

    public String nameString() {
        return EXRAttribute.nnameString(this.address());
    }

    public ByteBuffer type() {
        return EXRAttribute.ntype(this.address());
    }

    public String typeString() {
        return EXRAttribute.ntypeString(this.address());
    }

    public ByteBuffer value() {
        return EXRAttribute.nvalue(this.address());
    }

    public int size() {
        return EXRAttribute.nsize(this.address());
    }

    public EXRAttribute name(ByteBuffer value) {
        EXRAttribute.nname(this.address(), value);
        return this;
    }

    public EXRAttribute type(ByteBuffer value) {
        EXRAttribute.ntype(this.address(), value);
        return this;
    }

    public EXRAttribute value(ByteBuffer value) {
        EXRAttribute.nvalue(this.address(), value);
        return this;
    }

    public EXRAttribute set(ByteBuffer name, ByteBuffer type, ByteBuffer value) {
        this.name(name);
        this.type(type);
        this.value(value);
        return this;
    }

    public EXRAttribute set(EXRAttribute src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static EXRAttribute malloc() {
        return EXRAttribute.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static EXRAttribute calloc() {
        return EXRAttribute.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static EXRAttribute create() {
        return new EXRAttribute(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static EXRAttribute create(long address) {
        return address == 0L ? null : new EXRAttribute(address, null);
    }

    public static Buffer malloc(int capacity) {
        return EXRAttribute.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return EXRAttribute.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static EXRAttribute mallocStack() {
        return EXRAttribute.mallocStack(MemoryStack.stackGet());
    }

    public static EXRAttribute callocStack() {
        return EXRAttribute.callocStack(MemoryStack.stackGet());
    }

    public static EXRAttribute mallocStack(MemoryStack stack) {
        return EXRAttribute.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static EXRAttribute callocStack(MemoryStack stack) {
        return EXRAttribute.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return EXRAttribute.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return EXRAttribute.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return EXRAttribute.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return EXRAttribute.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)NAME, 256);
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memASCII(struct + (long)NAME);
    }

    public static ByteBuffer ntype(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)TYPE, 256);
    }

    public static String ntypeString(long struct) {
        return MemoryUtil.memASCII(struct + (long)TYPE);
    }

    public static ByteBuffer nvalue(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)VALUE), EXRAttribute.nsize(struct));
    }

    public static int nsize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SIZE);
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
            Checks.checkGT(value, 256);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)NAME, value.remaining());
    }

    public static void ntype(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
            Checks.checkGT(value, 256);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)TYPE, value.remaining());
    }

    public static void nvalue(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)VALUE, MemoryUtil.memAddressSafe(value));
        EXRAttribute.nsize(struct, value == null ? 0 : value.remaining());
    }

    public static void nsize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SIZE, value);
    }

    public static void validate(long struct) {
        if (EXRAttribute.nsize(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)VALUE));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            EXRAttribute.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = EXRAttribute.__struct(EXRAttribute.__array(1, 256), EXRAttribute.__array(1, 256), EXRAttribute.__member(POINTER_SIZE), EXRAttribute.__member(4), EXRAttribute.__padding(4, true));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        TYPE = layout.offsetof(1);
        VALUE = layout.offsetof(2);
        SIZE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<EXRAttribute, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected EXRAttribute newInstance(long address) {
            return new EXRAttribute(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public ByteBuffer name() {
            return EXRAttribute.nname(this.address());
        }

        public String nameString() {
            return EXRAttribute.nnameString(this.address());
        }

        public ByteBuffer type() {
            return EXRAttribute.ntype(this.address());
        }

        public String typeString() {
            return EXRAttribute.ntypeString(this.address());
        }

        public ByteBuffer value() {
            return EXRAttribute.nvalue(this.address());
        }

        public int size() {
            return EXRAttribute.nsize(this.address());
        }

        public Buffer name(ByteBuffer value) {
            EXRAttribute.nname(this.address(), value);
            return this;
        }

        public Buffer type(ByteBuffer value) {
            EXRAttribute.ntype(this.address(), value);
            return this;
        }

        public Buffer value(ByteBuffer value) {
            EXRAttribute.nvalue(this.address(), value);
            return this;
        }
    }
}

