/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.tinyexr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class EXRChannelInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int PIXEL_TYPE;
    public static final int X_SAMPLING;
    public static final int Y_SAMPLING;
    public static final int P_LINEAR;

    EXRChannelInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public EXRChannelInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), EXRChannelInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public ByteBuffer name() {
        return EXRChannelInfo.nname(this.address());
    }

    public String nameString() {
        return EXRChannelInfo.nnameString(this.address());
    }

    public int pixel_type() {
        return EXRChannelInfo.npixel_type(this.address());
    }

    public int x_sampling() {
        return EXRChannelInfo.nx_sampling(this.address());
    }

    public int y_sampling() {
        return EXRChannelInfo.ny_sampling(this.address());
    }

    public byte p_linear() {
        return EXRChannelInfo.np_linear(this.address());
    }

    public EXRChannelInfo name(ByteBuffer value) {
        EXRChannelInfo.nname(this.address(), value);
        return this;
    }

    public EXRChannelInfo pixel_type(int value) {
        EXRChannelInfo.npixel_type(this.address(), value);
        return this;
    }

    public EXRChannelInfo x_sampling(int value) {
        EXRChannelInfo.nx_sampling(this.address(), value);
        return this;
    }

    public EXRChannelInfo y_sampling(int value) {
        EXRChannelInfo.ny_sampling(this.address(), value);
        return this;
    }

    public EXRChannelInfo p_linear(byte value) {
        EXRChannelInfo.np_linear(this.address(), value);
        return this;
    }

    public EXRChannelInfo set(ByteBuffer name, int pixel_type, int x_sampling, int y_sampling, byte p_linear) {
        this.name(name);
        this.pixel_type(pixel_type);
        this.x_sampling(x_sampling);
        this.y_sampling(y_sampling);
        this.p_linear(p_linear);
        return this;
    }

    public EXRChannelInfo set(EXRChannelInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static EXRChannelInfo malloc() {
        return EXRChannelInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static EXRChannelInfo calloc() {
        return EXRChannelInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static EXRChannelInfo create() {
        return new EXRChannelInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static EXRChannelInfo create(long address) {
        return address == 0L ? null : new EXRChannelInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return EXRChannelInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return EXRChannelInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static EXRChannelInfo mallocStack() {
        return EXRChannelInfo.mallocStack(MemoryStack.stackGet());
    }

    public static EXRChannelInfo callocStack() {
        return EXRChannelInfo.callocStack(MemoryStack.stackGet());
    }

    public static EXRChannelInfo mallocStack(MemoryStack stack) {
        return EXRChannelInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static EXRChannelInfo callocStack(MemoryStack stack) {
        return EXRChannelInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return EXRChannelInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return EXRChannelInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return EXRChannelInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return EXRChannelInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)NAME, 256);
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memASCII(struct + (long)NAME);
    }

    public static int npixel_type(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PIXEL_TYPE);
    }

    public static int nx_sampling(long struct) {
        return MemoryUtil.memGetInt(struct + (long)X_SAMPLING);
    }

    public static int ny_sampling(long struct) {
        return MemoryUtil.memGetInt(struct + (long)Y_SAMPLING);
    }

    public static byte np_linear(long struct) {
        return MemoryUtil.memGetByte(struct + (long)P_LINEAR);
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
            Checks.checkGT(value, 256);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)NAME, value.remaining());
    }

    public static void npixel_type(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PIXEL_TYPE, value);
    }

    public static void nx_sampling(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)X_SAMPLING, value);
    }

    public static void ny_sampling(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)Y_SAMPLING, value);
    }

    public static void np_linear(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)P_LINEAR, value);
    }

    static {
        Struct.Layout layout = EXRChannelInfo.__struct(EXRChannelInfo.__array(1, 256), EXRChannelInfo.__member(4), EXRChannelInfo.__member(4), EXRChannelInfo.__member(4), EXRChannelInfo.__member(1), EXRChannelInfo.__padding(3, true));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        PIXEL_TYPE = layout.offsetof(1);
        X_SAMPLING = layout.offsetof(2);
        Y_SAMPLING = layout.offsetof(3);
        P_LINEAR = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<EXRChannelInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected EXRChannelInfo newInstance(long address) {
            return new EXRChannelInfo(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public ByteBuffer name() {
            return EXRChannelInfo.nname(this.address());
        }

        public String nameString() {
            return EXRChannelInfo.nnameString(this.address());
        }

        public int pixel_type() {
            return EXRChannelInfo.npixel_type(this.address());
        }

        public int x_sampling() {
            return EXRChannelInfo.nx_sampling(this.address());
        }

        public int y_sampling() {
            return EXRChannelInfo.ny_sampling(this.address());
        }

        public byte p_linear() {
            return EXRChannelInfo.np_linear(this.address());
        }

        public Buffer name(ByteBuffer value) {
            EXRChannelInfo.nname(this.address(), value);
            return this;
        }

        public Buffer pixel_type(int value) {
            EXRChannelInfo.npixel_type(this.address(), value);
            return this;
        }

        public Buffer x_sampling(int value) {
            EXRChannelInfo.nx_sampling(this.address(), value);
            return this;
        }

        public Buffer y_sampling(int value) {
            EXRChannelInfo.ny_sampling(this.address(), value);
            return this;
        }

        public Buffer p_linear(byte value) {
            EXRChannelInfo.np_linear(this.address(), value);
            return this;
        }
    }
}

