/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.tinyexr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class EXRVersion
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VERSION;
    public static final int TILED;
    public static final int LONG_NAME;
    public static final int NON_IMAGE;
    public static final int MULTIPART;

    EXRVersion(long address, ByteBuffer container) {
        super(address, container);
    }

    public EXRVersion(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), EXRVersion.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int version() {
        return EXRVersion.nversion(this.address());
    }

    public boolean tiled() {
        return EXRVersion.ntiled(this.address()) != 0;
    }

    public boolean long_name() {
        return EXRVersion.nlong_name(this.address()) != 0;
    }

    public boolean non_image() {
        return EXRVersion.nnon_image(this.address()) != 0;
    }

    public boolean multipart() {
        return EXRVersion.nmultipart(this.address()) != 0;
    }

    public EXRVersion version(int value) {
        EXRVersion.nversion(this.address(), value);
        return this;
    }

    public EXRVersion tiled(boolean value) {
        EXRVersion.ntiled(this.address(), value ? 1 : 0);
        return this;
    }

    public EXRVersion long_name(boolean value) {
        EXRVersion.nlong_name(this.address(), value ? 1 : 0);
        return this;
    }

    public EXRVersion non_image(boolean value) {
        EXRVersion.nnon_image(this.address(), value ? 1 : 0);
        return this;
    }

    public EXRVersion multipart(boolean value) {
        EXRVersion.nmultipart(this.address(), value ? 1 : 0);
        return this;
    }

    public EXRVersion set(int version, boolean tiled, boolean long_name, boolean non_image, boolean multipart) {
        this.version(version);
        this.tiled(tiled);
        this.long_name(long_name);
        this.non_image(non_image);
        this.multipart(multipart);
        return this;
    }

    public EXRVersion set(EXRVersion src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static EXRVersion malloc() {
        return EXRVersion.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static EXRVersion calloc() {
        return EXRVersion.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static EXRVersion create() {
        return new EXRVersion(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static EXRVersion create(long address) {
        return address == 0L ? null : new EXRVersion(address, null);
    }

    public static Buffer malloc(int capacity) {
        return EXRVersion.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return EXRVersion.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static EXRVersion mallocStack() {
        return EXRVersion.mallocStack(MemoryStack.stackGet());
    }

    public static EXRVersion callocStack() {
        return EXRVersion.callocStack(MemoryStack.stackGet());
    }

    public static EXRVersion mallocStack(MemoryStack stack) {
        return EXRVersion.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static EXRVersion callocStack(MemoryStack stack) {
        return EXRVersion.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return EXRVersion.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return EXRVersion.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return EXRVersion.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return EXRVersion.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nversion(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VERSION);
    }

    public static int ntiled(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TILED);
    }

    public static int nlong_name(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LONG_NAME);
    }

    public static int nnon_image(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NON_IMAGE);
    }

    public static int nmultipart(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MULTIPART);
    }

    public static void nversion(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VERSION, value);
    }

    public static void ntiled(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TILED, value);
    }

    public static void nlong_name(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LONG_NAME, value);
    }

    public static void nnon_image(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NON_IMAGE, value);
    }

    public static void nmultipart(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MULTIPART, value);
    }

    static {
        Struct.Layout layout = EXRVersion.__struct(EXRVersion.__member(4), EXRVersion.__member(4), EXRVersion.__member(4), EXRVersion.__member(4), EXRVersion.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VERSION = layout.offsetof(0);
        TILED = layout.offsetof(1);
        LONG_NAME = layout.offsetof(2);
        NON_IMAGE = layout.offsetof(3);
        MULTIPART = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<EXRVersion, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected EXRVersion newInstance(long address) {
            return new EXRVersion(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int version() {
            return EXRVersion.nversion(this.address());
        }

        public boolean tiled() {
            return EXRVersion.ntiled(this.address()) != 0;
        }

        public boolean long_name() {
            return EXRVersion.nlong_name(this.address()) != 0;
        }

        public boolean non_image() {
            return EXRVersion.nnon_image(this.address()) != 0;
        }

        public boolean multipart() {
            return EXRVersion.nmultipart(this.address()) != 0;
        }

        public Buffer version(int value) {
            EXRVersion.nversion(this.address(), value);
            return this;
        }

        public Buffer tiled(boolean value) {
            EXRVersion.ntiled(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer long_name(boolean value) {
            EXRVersion.nlong_name(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer non_image(boolean value) {
            EXRVersion.nnon_image(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer multipart(boolean value) {
            EXRVersion.nmultipart(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

