/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.tinyfd;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;

public class TinyFileDialogs {
    public static final String tinyfd_version;
    public static final IntBuffer tinyfd_forceConsole;

    protected TinyFileDialogs() {
        throw new UnsupportedOperationException();
    }

    private static native long ntinyfd_version();

    private static String tinyfd_version() {
        long __result = TinyFileDialogs.ntinyfd_version();
        return MemoryUtil.memASCII(__result);
    }

    private static native long ntinyfd_winUtf8();

    private static IntBuffer tinyfd_winUtf8() {
        long __result = TinyFileDialogs.ntinyfd_winUtf8();
        return MemoryUtil.memIntBuffer(__result, 1);
    }

    private static native long ntinyfd_forceConsole();

    private static IntBuffer tinyfd_forceConsole() {
        long __result = TinyFileDialogs.ntinyfd_forceConsole();
        return MemoryUtil.memIntBuffer(__result, 1);
    }

    public static native long ntinyfd_response();

    public static String tinyfd_response() {
        long __result = TinyFileDialogs.ntinyfd_response();
        return MemoryUtil.memUTF8(__result);
    }

    public static native int ntinyfd_messageBox(long var0, long var2, long var4, long var6, int var8);

    public static boolean tinyfd_messageBox(ByteBuffer aTitle, ByteBuffer aMessage, ByteBuffer aDialogType, ByteBuffer aIconType, boolean aDefaultButton) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(aTitle);
            Checks.checkNT1Safe(aMessage);
            Checks.checkNT1(aDialogType);
            Checks.checkNT1(aIconType);
        }
        return TinyFileDialogs.ntinyfd_messageBox(MemoryUtil.memAddressSafe(aTitle), MemoryUtil.memAddressSafe(aMessage), MemoryUtil.memAddress(aDialogType), MemoryUtil.memAddress(aIconType), aDefaultButton ? 1 : 0) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tinyfd_messageBox(CharSequence aTitle, CharSequence aMessage, CharSequence aDialogType, CharSequence aIconType, boolean aDefaultButton) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer aTitleEncoded = stack.UTF8(aTitle);
            ByteBuffer aMessageEncoded = stack.UTF8(aMessage);
            ByteBuffer aDialogTypeEncoded = stack.ASCII(aDialogType);
            ByteBuffer aIconTypeEncoded = stack.ASCII(aIconType);
            boolean bl = TinyFileDialogs.ntinyfd_messageBox(MemoryUtil.memAddressSafe(aTitleEncoded), MemoryUtil.memAddressSafe(aMessageEncoded), MemoryUtil.memAddress(aDialogTypeEncoded), MemoryUtil.memAddress(aIconTypeEncoded), aDefaultButton ? 1 : 0) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long ntinyfd_inputBox(long var0, long var2, long var4);

    public static String tinyfd_inputBox(ByteBuffer aTitle, ByteBuffer aMessage, ByteBuffer aDefaultInput) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(aTitle);
            Checks.checkNT1Safe(aMessage);
            Checks.checkNT1Safe(aDefaultInput);
        }
        long __result = TinyFileDialogs.ntinyfd_inputBox(MemoryUtil.memAddressSafe(aTitle), MemoryUtil.memAddressSafe(aMessage), MemoryUtil.memAddressSafe(aDefaultInput));
        return MemoryUtil.memUTF8(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String tinyfd_inputBox(CharSequence aTitle, CharSequence aMessage, CharSequence aDefaultInput) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer aTitleEncoded = stack.UTF8(aTitle);
            ByteBuffer aMessageEncoded = stack.UTF8(aMessage);
            ByteBuffer aDefaultInputEncoded = stack.UTF8(aDefaultInput);
            long __result = TinyFileDialogs.ntinyfd_inputBox(MemoryUtil.memAddressSafe(aTitleEncoded), MemoryUtil.memAddressSafe(aMessageEncoded), MemoryUtil.memAddressSafe(aDefaultInputEncoded));
            String string = MemoryUtil.memUTF8(__result);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long ntinyfd_saveFileDialog(long var0, long var2, int var4, long var5, long var7);

    public static String tinyfd_saveFileDialog(ByteBuffer aTitle, ByteBuffer aDefaultPathAndFile, PointerBuffer aFilterPatterns, ByteBuffer aSingleFilterDescription) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(aTitle);
            Checks.checkNT1Safe(aDefaultPathAndFile);
            Checks.checkNT1Safe(aSingleFilterDescription);
        }
        long __result = TinyFileDialogs.ntinyfd_saveFileDialog(MemoryUtil.memAddressSafe(aTitle), MemoryUtil.memAddressSafe(aDefaultPathAndFile), Checks.remainingSafe(aFilterPatterns), MemoryUtil.memAddressSafe(aFilterPatterns), MemoryUtil.memAddressSafe(aSingleFilterDescription));
        return MemoryUtil.memUTF8(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String tinyfd_saveFileDialog(CharSequence aTitle, CharSequence aDefaultPathAndFile, PointerBuffer aFilterPatterns, CharSequence aSingleFilterDescription) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer aTitleEncoded = stack.UTF8(aTitle);
            ByteBuffer aDefaultPathAndFileEncoded = stack.UTF8(aDefaultPathAndFile);
            ByteBuffer aSingleFilterDescriptionEncoded = stack.UTF8(aSingleFilterDescription);
            long __result = TinyFileDialogs.ntinyfd_saveFileDialog(MemoryUtil.memAddressSafe(aTitleEncoded), MemoryUtil.memAddressSafe(aDefaultPathAndFileEncoded), Checks.remainingSafe(aFilterPatterns), MemoryUtil.memAddressSafe(aFilterPatterns), MemoryUtil.memAddressSafe(aSingleFilterDescriptionEncoded));
            String string = MemoryUtil.memUTF8(__result);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long ntinyfd_openFileDialog(long var0, long var2, int var4, long var5, long var7, int var9);

    public static String tinyfd_openFileDialog(ByteBuffer aTitle, ByteBuffer aDefaultPathAndFile, PointerBuffer aFilterPatterns, ByteBuffer aSingleFilterDescription, boolean aAllowMultipleSelects) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(aTitle);
            Checks.checkNT1Safe(aDefaultPathAndFile);
            Checks.checkNT1Safe(aSingleFilterDescription);
        }
        long __result = TinyFileDialogs.ntinyfd_openFileDialog(MemoryUtil.memAddressSafe(aTitle), MemoryUtil.memAddressSafe(aDefaultPathAndFile), Checks.remainingSafe(aFilterPatterns), MemoryUtil.memAddressSafe(aFilterPatterns), MemoryUtil.memAddressSafe(aSingleFilterDescription), aAllowMultipleSelects ? 1 : 0);
        return MemoryUtil.memUTF8(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String tinyfd_openFileDialog(CharSequence aTitle, CharSequence aDefaultPathAndFile, PointerBuffer aFilterPatterns, CharSequence aSingleFilterDescription, boolean aAllowMultipleSelects) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer aTitleEncoded = stack.UTF8(aTitle);
            ByteBuffer aDefaultPathAndFileEncoded = stack.UTF8(aDefaultPathAndFile);
            ByteBuffer aSingleFilterDescriptionEncoded = stack.UTF8(aSingleFilterDescription);
            long __result = TinyFileDialogs.ntinyfd_openFileDialog(MemoryUtil.memAddressSafe(aTitleEncoded), MemoryUtil.memAddressSafe(aDefaultPathAndFileEncoded), Checks.remainingSafe(aFilterPatterns), MemoryUtil.memAddressSafe(aFilterPatterns), MemoryUtil.memAddressSafe(aSingleFilterDescriptionEncoded), aAllowMultipleSelects ? 1 : 0);
            String string = MemoryUtil.memUTF8(__result);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long ntinyfd_selectFolderDialog(long var0, long var2);

    public static String tinyfd_selectFolderDialog(ByteBuffer aTitle, ByteBuffer aDefaultPath) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(aTitle);
            Checks.checkNT1(aDefaultPath);
        }
        long __result = TinyFileDialogs.ntinyfd_selectFolderDialog(MemoryUtil.memAddressSafe(aTitle), MemoryUtil.memAddress(aDefaultPath));
        return MemoryUtil.memUTF8(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String tinyfd_selectFolderDialog(CharSequence aTitle, CharSequence aDefaultPath) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer aTitleEncoded = stack.UTF8(aTitle);
            ByteBuffer aDefaultPathEncoded = stack.UTF8(aDefaultPath);
            long __result = TinyFileDialogs.ntinyfd_selectFolderDialog(MemoryUtil.memAddressSafe(aTitleEncoded), MemoryUtil.memAddress(aDefaultPathEncoded));
            String string = MemoryUtil.memUTF8(__result);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long ntinyfd_colorChooser(long var0, long var2, long var4, long var6);

    public static String tinyfd_colorChooser(ByteBuffer aTitle, ByteBuffer aDefaultHexRGB, ByteBuffer aDefaultRGB, ByteBuffer aoResultRGB) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(aTitle);
            Checks.checkNT1Safe(aDefaultHexRGB);
            Checks.checkSafe((Buffer)aDefaultRGB, 3);
            Checks.check((Buffer)aoResultRGB, 3);
        }
        long __result = TinyFileDialogs.ntinyfd_colorChooser(MemoryUtil.memAddressSafe(aTitle), MemoryUtil.memAddressSafe(aDefaultHexRGB), MemoryUtil.memAddressSafe(aDefaultRGB), MemoryUtil.memAddress(aoResultRGB));
        return MemoryUtil.memUTF8(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String tinyfd_colorChooser(CharSequence aTitle, CharSequence aDefaultHexRGB, ByteBuffer aDefaultRGB, ByteBuffer aoResultRGB) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)aDefaultRGB, 3);
            Checks.check((Buffer)aoResultRGB, 3);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer aTitleEncoded = stack.UTF8(aTitle);
            ByteBuffer aDefaultHexRGBEncoded = stack.ASCII(aDefaultHexRGB);
            long __result = TinyFileDialogs.ntinyfd_colorChooser(MemoryUtil.memAddressSafe(aTitleEncoded), MemoryUtil.memAddressSafe(aDefaultHexRGBEncoded), MemoryUtil.memAddressSafe(aDefaultRGB), MemoryUtil.memAddress(aoResultRGB));
            String string = MemoryUtil.memUTF8(__result);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    static {
        Library.loadSystem(System::load, System::loadLibrary, TinyFileDialogs.class, Platform.mapLibraryNameBundled("lwjgl_tinyfd"));
        TinyFileDialogs.tinyfd_winUtf8().put(0, 1);
        tinyfd_version = TinyFileDialogs.tinyfd_version();
        tinyfd_forceConsole = TinyFileDialogs.tinyfd_forceConsole();
    }
}

