/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.xxhash;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XXH32Canonical
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DIGEST;

    XXH32Canonical(long address, ByteBuffer container) {
        super(address, container);
    }

    public XXH32Canonical(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), XXH32Canonical.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public ByteBuffer digest() {
        return XXH32Canonical.ndigest(this.address());
    }

    public byte digest(int index) {
        return XXH32Canonical.ndigest(this.address(), index);
    }

    public static XXH32Canonical malloc() {
        return XXH32Canonical.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static XXH32Canonical calloc() {
        return XXH32Canonical.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static XXH32Canonical create() {
        return new XXH32Canonical(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static XXH32Canonical create(long address) {
        return address == 0L ? null : new XXH32Canonical(address, null);
    }

    public static Buffer malloc(int capacity) {
        return XXH32Canonical.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XXH32Canonical.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static XXH32Canonical mallocStack() {
        return XXH32Canonical.mallocStack(MemoryStack.stackGet());
    }

    public static XXH32Canonical callocStack() {
        return XXH32Canonical.callocStack(MemoryStack.stackGet());
    }

    public static XXH32Canonical mallocStack(MemoryStack stack) {
        return XXH32Canonical.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XXH32Canonical callocStack(MemoryStack stack) {
        return XXH32Canonical.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return XXH32Canonical.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return XXH32Canonical.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return XXH32Canonical.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return XXH32Canonical.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ndigest(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)DIGEST, 4);
    }

    public static byte ndigest(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 4);
        }
        return MemoryUtil.memGetByte(struct + (long)DIGEST + (long)(index * 1));
    }

    static {
        Struct.Layout layout = XXH32Canonical.__struct(XXH32Canonical.__array(1, 4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DIGEST = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<XXH32Canonical, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected XXH32Canonical newInstance(long address) {
            return new XXH32Canonical(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public ByteBuffer digest() {
            return XXH32Canonical.ndigest(this.address());
        }

        public byte digest(int index) {
            return XXH32Canonical.ndigest(this.address(), index);
        }
    }
}

