/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.xxhash;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XXH64State
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TOTAL_LEN;
    public static final int V1;
    public static final int V2;
    public static final int V3;
    public static final int V4;
    public static final int MEM64;
    public static final int MEMSIZE;
    public static final int RESERVED;

    XXH64State(long address, ByteBuffer container) {
        super(address, container);
    }

    public XXH64State(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), XXH64State.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long total_len() {
        return XXH64State.ntotal_len(this.address());
    }

    public long v1() {
        return XXH64State.nv1(this.address());
    }

    public long v2() {
        return XXH64State.nv2(this.address());
    }

    public long v3() {
        return XXH64State.nv3(this.address());
    }

    public long v4() {
        return XXH64State.nv4(this.address());
    }

    public LongBuffer mem64() {
        return XXH64State.nmem64(this.address());
    }

    public long mem64(int index) {
        return XXH64State.nmem64(this.address(), index);
    }

    public int memsize() {
        return XXH64State.nmemsize(this.address());
    }

    public IntBuffer reserved() {
        return XXH64State.nreserved(this.address());
    }

    public int reserved(int index) {
        return XXH64State.nreserved(this.address(), index);
    }

    public XXH64State total_len(long value) {
        XXH64State.ntotal_len(this.address(), value);
        return this;
    }

    public XXH64State v1(long value) {
        XXH64State.nv1(this.address(), value);
        return this;
    }

    public XXH64State v2(long value) {
        XXH64State.nv2(this.address(), value);
        return this;
    }

    public XXH64State v3(long value) {
        XXH64State.nv3(this.address(), value);
        return this;
    }

    public XXH64State v4(long value) {
        XXH64State.nv4(this.address(), value);
        return this;
    }

    public XXH64State mem64(LongBuffer value) {
        XXH64State.nmem64(this.address(), value);
        return this;
    }

    public XXH64State mem64(int index, long value) {
        XXH64State.nmem64(this.address(), index, value);
        return this;
    }

    public XXH64State memsize(int value) {
        XXH64State.nmemsize(this.address(), value);
        return this;
    }

    public XXH64State reserved(IntBuffer value) {
        XXH64State.nreserved(this.address(), value);
        return this;
    }

    public XXH64State reserved(int index, int value) {
        XXH64State.nreserved(this.address(), index, value);
        return this;
    }

    public XXH64State set(long total_len, long v1, long v2, long v3, long v4, LongBuffer mem64, int memsize, IntBuffer reserved) {
        this.total_len(total_len);
        this.v1(v1);
        this.v2(v2);
        this.v3(v3);
        this.v4(v4);
        this.mem64(mem64);
        this.memsize(memsize);
        this.reserved(reserved);
        return this;
    }

    public XXH64State set(XXH64State src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XXH64State malloc() {
        return XXH64State.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static XXH64State calloc() {
        return XXH64State.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static XXH64State create() {
        return new XXH64State(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static XXH64State create(long address) {
        return address == 0L ? null : new XXH64State(address, null);
    }

    public static Buffer malloc(int capacity) {
        return XXH64State.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XXH64State.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static XXH64State mallocStack() {
        return XXH64State.mallocStack(MemoryStack.stackGet());
    }

    public static XXH64State callocStack() {
        return XXH64State.callocStack(MemoryStack.stackGet());
    }

    public static XXH64State mallocStack(MemoryStack stack) {
        return XXH64State.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XXH64State callocStack(MemoryStack stack) {
        return XXH64State.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return XXH64State.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return XXH64State.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return XXH64State.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return XXH64State.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ntotal_len(long struct) {
        return MemoryUtil.memGetLong(struct + (long)TOTAL_LEN);
    }

    public static long nv1(long struct) {
        return MemoryUtil.memGetLong(struct + (long)V1);
    }

    public static long nv2(long struct) {
        return MemoryUtil.memGetLong(struct + (long)V2);
    }

    public static long nv3(long struct) {
        return MemoryUtil.memGetLong(struct + (long)V3);
    }

    public static long nv4(long struct) {
        return MemoryUtil.memGetLong(struct + (long)V4);
    }

    public static LongBuffer nmem64(long struct) {
        return MemoryUtil.memLongBuffer(struct + (long)MEM64, 4);
    }

    public static long nmem64(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 4);
        }
        return MemoryUtil.memGetLong(struct + (long)MEM64 + (long)(index * 8));
    }

    public static int nmemsize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MEMSIZE);
    }

    public static IntBuffer nreserved(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)RESERVED, 2);
    }

    public static int nreserved(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 2);
        }
        return MemoryUtil.memGetInt(struct + (long)RESERVED + (long)(index * 4));
    }

    public static void ntotal_len(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)TOTAL_LEN, value);
    }

    public static void nv1(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)V1, value);
    }

    public static void nv2(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)V2, value);
    }

    public static void nv3(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)V3, value);
    }

    public static void nv4(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)V4, value);
    }

    public static void nmem64(long struct, LongBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 4);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)MEM64, value.remaining() * 8);
    }

    public static void nmem64(long struct, int index, long value) {
        if (Checks.CHECKS) {
            Checks.check(index, 4);
        }
        MemoryUtil.memPutLong(struct + (long)MEM64 + (long)(index * 8), value);
    }

    public static void nmemsize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MEMSIZE, value);
    }

    public static void nreserved(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)RESERVED, value.remaining() * 4);
    }

    public static void nreserved(long struct, int index, int value) {
        if (Checks.CHECKS) {
            Checks.check(index, 2);
        }
        MemoryUtil.memPutInt(struct + (long)RESERVED + (long)(index * 4), value);
    }

    static {
        Struct.Layout layout = XXH64State.__struct(XXH64State.__member(8), XXH64State.__member(8), XXH64State.__member(8), XXH64State.__member(8), XXH64State.__member(8), XXH64State.__array(8, 4), XXH64State.__member(4), XXH64State.__array(4, 2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TOTAL_LEN = layout.offsetof(0);
        V1 = layout.offsetof(1);
        V2 = layout.offsetof(2);
        V3 = layout.offsetof(3);
        V4 = layout.offsetof(4);
        MEM64 = layout.offsetof(5);
        MEMSIZE = layout.offsetof(6);
        RESERVED = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<XXH64State, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected XXH64State newInstance(long address) {
            return new XXH64State(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long total_len() {
            return XXH64State.ntotal_len(this.address());
        }

        public long v1() {
            return XXH64State.nv1(this.address());
        }

        public long v2() {
            return XXH64State.nv2(this.address());
        }

        public long v3() {
            return XXH64State.nv3(this.address());
        }

        public long v4() {
            return XXH64State.nv4(this.address());
        }

        public LongBuffer mem64() {
            return XXH64State.nmem64(this.address());
        }

        public long mem64(int index) {
            return XXH64State.nmem64(this.address(), index);
        }

        public int memsize() {
            return XXH64State.nmemsize(this.address());
        }

        public IntBuffer reserved() {
            return XXH64State.nreserved(this.address());
        }

        public int reserved(int index) {
            return XXH64State.nreserved(this.address(), index);
        }

        public Buffer total_len(long value) {
            XXH64State.ntotal_len(this.address(), value);
            return this;
        }

        public Buffer v1(long value) {
            XXH64State.nv1(this.address(), value);
            return this;
        }

        public Buffer v2(long value) {
            XXH64State.nv2(this.address(), value);
            return this;
        }

        public Buffer v3(long value) {
            XXH64State.nv3(this.address(), value);
            return this;
        }

        public Buffer v4(long value) {
            XXH64State.nv4(this.address(), value);
            return this;
        }

        public Buffer mem64(LongBuffer value) {
            XXH64State.nmem64(this.address(), value);
            return this;
        }

        public Buffer mem64(int index, long value) {
            XXH64State.nmem64(this.address(), index, value);
            return this;
        }

        public Buffer memsize(int value) {
            XXH64State.nmemsize(this.address(), value);
            return this;
        }

        public Buffer reserved(IntBuffer value) {
            XXH64State.nreserved(this.address(), value);
            return this;
        }

        public Buffer reserved(int index, int value) {
            XXH64State.nreserved(this.address(), index, value);
            return this;
        }
    }
}

