/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.yoga;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.yoga.YGCachedMeasurement;

public class YGLayout
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int POSITIONS;
    public static final int DIMENSIONS;
    public static final int MARGIN;
    public static final int BORDER;
    public static final int PADDING;
    public static final int DIRECTION;
    public static final int COMPUTEDFLEXBASISGENERATION;
    public static final int COMPUTEDFLEXBASIS;
    public static final int GENERATIONCOUNT;
    public static final int LASTPARENTDIRECTION;
    public static final int NEXTCACHEDMEASUREMENTSINDEX;
    public static final int CACHEDMEASUREMENTS;
    public static final int MEASUREDDIMENSIONS;
    public static final int CACHEDLAYOUT;

    YGLayout(long address, ByteBuffer container) {
        super(address, container);
    }

    public YGLayout(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), YGLayout.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public FloatBuffer positions() {
        return YGLayout.npositions(this.address());
    }

    public float positions(int index) {
        return YGLayout.npositions(this.address(), index);
    }

    public FloatBuffer dimensions() {
        return YGLayout.ndimensions(this.address());
    }

    public float dimensions(int index) {
        return YGLayout.ndimensions(this.address(), index);
    }

    public FloatBuffer margin() {
        return YGLayout.nmargin(this.address());
    }

    public float margin(int index) {
        return YGLayout.nmargin(this.address(), index);
    }

    public FloatBuffer border() {
        return YGLayout.nborder(this.address());
    }

    public float border(int index) {
        return YGLayout.nborder(this.address(), index);
    }

    public FloatBuffer padding() {
        return YGLayout.npadding(this.address());
    }

    public float padding(int index) {
        return YGLayout.npadding(this.address(), index);
    }

    public int direction() {
        return YGLayout.ndirection(this.address());
    }

    public int computedFlexBasisGeneration() {
        return YGLayout.ncomputedFlexBasisGeneration(this.address());
    }

    public float computedFlexBasis() {
        return YGLayout.ncomputedFlexBasis(this.address());
    }

    public int generationCount() {
        return YGLayout.ngenerationCount(this.address());
    }

    public int lastParentDirection() {
        return YGLayout.nlastParentDirection(this.address());
    }

    public int nextCachedMeasurementsIndex() {
        return YGLayout.nnextCachedMeasurementsIndex(this.address());
    }

    public YGCachedMeasurement.Buffer cachedMeasurements() {
        return YGLayout.ncachedMeasurements(this.address());
    }

    public YGCachedMeasurement cachedMeasurements(int index) {
        return YGLayout.ncachedMeasurements(this.address(), index);
    }

    public FloatBuffer measuredDimensions() {
        return YGLayout.nmeasuredDimensions(this.address());
    }

    public float measuredDimensions(int index) {
        return YGLayout.nmeasuredDimensions(this.address(), index);
    }

    public YGCachedMeasurement cachedLayout() {
        return YGLayout.ncachedLayout(this.address());
    }

    public static YGLayout create(long address) {
        return address == 0L ? null : new YGLayout(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static FloatBuffer npositions(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)POSITIONS, 4);
    }

    public static float npositions(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 4);
        }
        return MemoryUtil.memGetFloat(struct + (long)POSITIONS + (long)(index * 4));
    }

    public static FloatBuffer ndimensions(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)DIMENSIONS, 2);
    }

    public static float ndimensions(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 2);
        }
        return MemoryUtil.memGetFloat(struct + (long)DIMENSIONS + (long)(index * 4));
    }

    public static FloatBuffer nmargin(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)MARGIN, 6);
    }

    public static float nmargin(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 6);
        }
        return MemoryUtil.memGetFloat(struct + (long)MARGIN + (long)(index * 4));
    }

    public static FloatBuffer nborder(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)BORDER, 6);
    }

    public static float nborder(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 6);
        }
        return MemoryUtil.memGetFloat(struct + (long)BORDER + (long)(index * 4));
    }

    public static FloatBuffer npadding(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)PADDING, 6);
    }

    public static float npadding(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 6);
        }
        return MemoryUtil.memGetFloat(struct + (long)PADDING + (long)(index * 4));
    }

    public static int ndirection(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DIRECTION);
    }

    public static int ncomputedFlexBasisGeneration(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COMPUTEDFLEXBASISGENERATION);
    }

    public static float ncomputedFlexBasis(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)COMPUTEDFLEXBASIS);
    }

    public static int ngenerationCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)GENERATIONCOUNT);
    }

    public static int nlastParentDirection(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LASTPARENTDIRECTION);
    }

    public static int nnextCachedMeasurementsIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NEXTCACHEDMEASUREMENTSINDEX);
    }

    public static YGCachedMeasurement.Buffer ncachedMeasurements(long struct) {
        return YGCachedMeasurement.create(struct + (long)CACHEDMEASUREMENTS, 16);
    }

    public static YGCachedMeasurement ncachedMeasurements(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 16);
        }
        return YGCachedMeasurement.create(struct + (long)CACHEDMEASUREMENTS + (long)(index * YGCachedMeasurement.SIZEOF));
    }

    public static FloatBuffer nmeasuredDimensions(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)MEASUREDDIMENSIONS, 2);
    }

    public static float nmeasuredDimensions(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 2);
        }
        return MemoryUtil.memGetFloat(struct + (long)MEASUREDDIMENSIONS + (long)(index * 4));
    }

    public static YGCachedMeasurement ncachedLayout(long struct) {
        return YGCachedMeasurement.create(struct + (long)CACHEDLAYOUT);
    }

    static {
        Struct.Layout layout = YGLayout.__struct(YGLayout.__array(4, 4), YGLayout.__array(4, 2), YGLayout.__array(4, 6), YGLayout.__array(4, 6), YGLayout.__array(4, 6), YGLayout.__member(4), YGLayout.__member(4), YGLayout.__member(4), YGLayout.__member(4), YGLayout.__member(4), YGLayout.__member(4), YGLayout.__array(YGCachedMeasurement.SIZEOF, YGCachedMeasurement.ALIGNOF, 16), YGLayout.__array(4, 2), YGLayout.__member(YGCachedMeasurement.SIZEOF, YGCachedMeasurement.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        POSITIONS = layout.offsetof(0);
        DIMENSIONS = layout.offsetof(1);
        MARGIN = layout.offsetof(2);
        BORDER = layout.offsetof(3);
        PADDING = layout.offsetof(4);
        DIRECTION = layout.offsetof(5);
        COMPUTEDFLEXBASISGENERATION = layout.offsetof(6);
        COMPUTEDFLEXBASIS = layout.offsetof(7);
        GENERATIONCOUNT = layout.offsetof(8);
        LASTPARENTDIRECTION = layout.offsetof(9);
        NEXTCACHEDMEASUREMENTSINDEX = layout.offsetof(10);
        CACHEDMEASUREMENTS = layout.offsetof(11);
        MEASUREDDIMENSIONS = layout.offsetof(12);
        CACHEDLAYOUT = layout.offsetof(13);
    }

    public static class Buffer
    extends StructBuffer<YGLayout, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected YGLayout newInstance(long address) {
            return new YGLayout(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public FloatBuffer positions() {
            return YGLayout.npositions(this.address());
        }

        public float positions(int index) {
            return YGLayout.npositions(this.address(), index);
        }

        public FloatBuffer dimensions() {
            return YGLayout.ndimensions(this.address());
        }

        public float dimensions(int index) {
            return YGLayout.ndimensions(this.address(), index);
        }

        public FloatBuffer margin() {
            return YGLayout.nmargin(this.address());
        }

        public float margin(int index) {
            return YGLayout.nmargin(this.address(), index);
        }

        public FloatBuffer border() {
            return YGLayout.nborder(this.address());
        }

        public float border(int index) {
            return YGLayout.nborder(this.address(), index);
        }

        public FloatBuffer padding() {
            return YGLayout.npadding(this.address());
        }

        public float padding(int index) {
            return YGLayout.npadding(this.address(), index);
        }

        public int direction() {
            return YGLayout.ndirection(this.address());
        }

        public int computedFlexBasisGeneration() {
            return YGLayout.ncomputedFlexBasisGeneration(this.address());
        }

        public float computedFlexBasis() {
            return YGLayout.ncomputedFlexBasis(this.address());
        }

        public int generationCount() {
            return YGLayout.ngenerationCount(this.address());
        }

        public int lastParentDirection() {
            return YGLayout.nlastParentDirection(this.address());
        }

        public int nextCachedMeasurementsIndex() {
            return YGLayout.nnextCachedMeasurementsIndex(this.address());
        }

        public YGCachedMeasurement.Buffer cachedMeasurements() {
            return YGLayout.ncachedMeasurements(this.address());
        }

        public YGCachedMeasurement cachedMeasurements(int index) {
            return YGLayout.ncachedMeasurements(this.address(), index);
        }

        public FloatBuffer measuredDimensions() {
            return YGLayout.nmeasuredDimensions(this.address());
        }

        public float measuredDimensions(int index) {
            return YGLayout.nmeasuredDimensions(this.address(), index);
        }

        public YGCachedMeasurement cachedLayout() {
            return YGLayout.ncachedLayout(this.address());
        }
    }
}

