/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.yoga;

import java.nio.ByteBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.yoga.YGLayout;
import org.lwjgl.util.yoga.YGMeasureFunc;
import org.lwjgl.util.yoga.YGPrintFunc;
import org.lwjgl.util.yoga.YGStyle;
import org.lwjgl.util.yoga.YGValue;

public class YGNode
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYLE;
    public static final int LAYOUT;
    public static final int LINEINDEX;
    public static final int PARENT;
    public static final int CHILDREN;
    public static final int NEXTCHILD;
    public static final int MEASURE;
    public static final int PRINT;
    public static final int CONTEXT;
    public static final int ISDIRTY;
    public static final int HASNEWLAYOUT;
    public static final int RESOLVEDDIMENSIONS;

    YGNode(long address, ByteBuffer container) {
        super(address, container);
    }

    public YGNode(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), YGNode.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public YGStyle style() {
        return YGNode.nstyle(this.address());
    }

    public YGLayout layout() {
        return YGNode.nlayout(this.address());
    }

    public int lineIndex() {
        return YGNode.nlineIndex(this.address());
    }

    public long parent() {
        return YGNode.nparent(this.address());
    }

    public long children() {
        return YGNode.nchildren(this.address());
    }

    public YGNode nextChild() {
        return YGNode.nnextChild(this.address());
    }

    public YGMeasureFunc measure() {
        return YGNode.nmeasure(this.address());
    }

    public YGPrintFunc print() {
        return YGNode.nprint(this.address());
    }

    public long context() {
        return YGNode.ncontext(this.address());
    }

    public boolean isDirty() {
        return YGNode.nisDirty(this.address());
    }

    public boolean hasNewLayout() {
        return YGNode.nhasNewLayout(this.address());
    }

    public PointerBuffer resolvedDimensions() {
        return YGNode.nresolvedDimensions(this.address());
    }

    public YGValue resolvedDimensions(int index) {
        return YGNode.nresolvedDimensions(this.address(), index);
    }

    public static YGNode create(long address) {
        return address == 0L ? null : new YGNode(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static YGStyle nstyle(long struct) {
        return YGStyle.create(struct + (long)STYLE);
    }

    public static YGLayout nlayout(long struct) {
        return YGLayout.create(struct + (long)LAYOUT);
    }

    public static int nlineIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LINEINDEX);
    }

    public static long nparent(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PARENT);
    }

    public static long nchildren(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CHILDREN);
    }

    public static YGNode nnextChild(long struct) {
        return YGNode.create(MemoryUtil.memGetAddress(struct + (long)NEXTCHILD));
    }

    public static YGMeasureFunc nmeasure(long struct) {
        return YGMeasureFunc.create(MemoryUtil.memGetAddress(struct + (long)MEASURE));
    }

    public static YGPrintFunc nprint(long struct) {
        return YGPrintFunc.create(MemoryUtil.memGetAddress(struct + (long)PRINT));
    }

    public static long ncontext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CONTEXT);
    }

    public static boolean nisDirty(long struct) {
        return MemoryUtil.memGetByte(struct + (long)ISDIRTY) != 0;
    }

    public static boolean nhasNewLayout(long struct) {
        return MemoryUtil.memGetByte(struct + (long)HASNEWLAYOUT) != 0;
    }

    public static PointerBuffer nresolvedDimensions(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)RESOLVEDDIMENSIONS, 2);
    }

    public static YGValue nresolvedDimensions(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 2);
        }
        return YGValue.create(MemoryUtil.memGetAddress(struct + (long)RESOLVEDDIMENSIONS + (long)(index * POINTER_SIZE)));
    }

    static {
        Struct.Layout layout = YGNode.__struct(YGNode.__member(YGStyle.SIZEOF, YGStyle.ALIGNOF), YGNode.__member(YGLayout.SIZEOF, YGLayout.ALIGNOF), YGNode.__member(4), YGNode.__member(POINTER_SIZE), YGNode.__member(POINTER_SIZE), YGNode.__member(POINTER_SIZE), YGNode.__member(POINTER_SIZE), YGNode.__member(POINTER_SIZE), YGNode.__member(POINTER_SIZE), YGNode.__member(1), YGNode.__member(1), YGNode.__array(POINTER_SIZE, 2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYLE = layout.offsetof(0);
        LAYOUT = layout.offsetof(1);
        LINEINDEX = layout.offsetof(2);
        PARENT = layout.offsetof(3);
        CHILDREN = layout.offsetof(4);
        NEXTCHILD = layout.offsetof(5);
        MEASURE = layout.offsetof(6);
        PRINT = layout.offsetof(7);
        CONTEXT = layout.offsetof(8);
        ISDIRTY = layout.offsetof(9);
        HASNEWLAYOUT = layout.offsetof(10);
        RESOLVEDDIMENSIONS = layout.offsetof(11);
    }

    public static class Buffer
    extends StructBuffer<YGNode, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected YGNode newInstance(long address) {
            return new YGNode(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public YGStyle style() {
            return YGNode.nstyle(this.address());
        }

        public YGLayout layout() {
            return YGNode.nlayout(this.address());
        }

        public int lineIndex() {
            return YGNode.nlineIndex(this.address());
        }

        public long parent() {
            return YGNode.nparent(this.address());
        }

        public long children() {
            return YGNode.nchildren(this.address());
        }

        public YGNode nextChild() {
            return YGNode.nnextChild(this.address());
        }

        public YGMeasureFunc measure() {
            return YGNode.nmeasure(this.address());
        }

        public YGPrintFunc print() {
            return YGNode.nprint(this.address());
        }

        public long context() {
            return YGNode.ncontext(this.address());
        }

        public boolean isDirty() {
            return YGNode.nisDirty(this.address());
        }

        public boolean hasNewLayout() {
            return YGNode.nhasNewLayout(this.address());
        }

        public PointerBuffer resolvedDimensions() {
            return YGNode.nresolvedDimensions(this.address());
        }

        public YGValue resolvedDimensions(int index) {
            return YGNode.nresolvedDimensions(this.address(), index);
        }
    }
}

