/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.LongBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.vulkan.VKCapabilitiesInstance;
import org.lwjgl.vulkan.VkPhysicalDevice;

public class EXTAcquireXlibDisplay {
    public static final int VK_EXT_ACQUIRE_XLIB_DISPLAY_SPEC_VERSION = 1;
    public static final String VK_EXT_ACQUIRE_XLIB_DISPLAY_EXTENSION_NAME = "VK_EXT_acquire_xlib_display";

    protected EXTAcquireXlibDisplay() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(VKCapabilitiesInstance caps) {
        return Checks.checkFunctions(caps.vkAcquireXlibDisplayEXT, caps.vkGetRandROutputDisplayEXT);
    }

    public static int vkAcquireXlibDisplayEXT(VkPhysicalDevice physicalDevice, long dpy, long display) {
        long __functionAddress = physicalDevice.getCapabilities().vkAcquireXlibDisplayEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
        }
        return JNI.callPPJI(__functionAddress, physicalDevice.address(), dpy, display);
    }

    public static int nvkGetRandROutputDisplayEXT(VkPhysicalDevice physicalDevice, long dpy, long rrOutput, long pDisplay) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetRandROutputDisplayEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
        }
        return JNI.callPPPPI(__functionAddress, physicalDevice.address(), dpy, rrOutput, pDisplay);
    }

    public static int vkGetRandROutputDisplayEXT(VkPhysicalDevice physicalDevice, long dpy, long rrOutput, LongBuffer pDisplay) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pDisplay, 1);
        }
        return EXTAcquireXlibDisplay.nvkGetRandROutputDisplayEXT(physicalDevice, dpy, rrOutput, MemoryUtil.memAddress(pDisplay));
    }

    public static int vkGetRandROutputDisplayEXT(VkPhysicalDevice physicalDevice, long dpy, long rrOutput, long[] pDisplay) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetRandROutputDisplayEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(pDisplay, 1);
        }
        return JNI.callPPPPI(__functionAddress, physicalDevice.address(), dpy, rrOutput, pDisplay);
    }
}

