/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.vulkan.VKCapabilitiesDevice;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkPastPresentationTimingGOOGLE;
import org.lwjgl.vulkan.VkRefreshCycleDurationGOOGLE;

public class GOOGLEDisplayTiming {
    public static final int VK_GOOGLE_DISPLAY_TIMING_SPEC_VERSION = 1;
    public static final String VK_GOOGLE_DISPLAY_TIMING_EXTENSION_NAME = "VK_GOOGLE_display_timing";
    public static final int VK_STRUCTURE_TYPE_PRESENT_TIMES_INFO_GOOGLE = 1000092000;

    protected GOOGLEDisplayTiming() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(VKCapabilitiesDevice caps) {
        return Checks.checkFunctions(caps.vkGetRefreshCycleDurationGOOGLE, caps.vkGetPastPresentationTimingGOOGLE);
    }

    public static int nvkGetRefreshCycleDurationGOOGLE(VkDevice device, long swapchain, long pDisplayTimingProperties) {
        long __functionAddress = device.getCapabilities().vkGetRefreshCycleDurationGOOGLE;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPI(__functionAddress, device.address(), swapchain, pDisplayTimingProperties);
    }

    public static int vkGetRefreshCycleDurationGOOGLE(VkDevice device, long swapchain, VkRefreshCycleDurationGOOGLE pDisplayTimingProperties) {
        return GOOGLEDisplayTiming.nvkGetRefreshCycleDurationGOOGLE(device, swapchain, pDisplayTimingProperties.address());
    }

    public static int nvkGetPastPresentationTimingGOOGLE(VkDevice device, long swapchain, long pPresentationTimingCount, long pPresentationTimings) {
        long __functionAddress = device.getCapabilities().vkGetPastPresentationTimingGOOGLE;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPPI(__functionAddress, device.address(), swapchain, pPresentationTimingCount, pPresentationTimings);
    }

    public static int vkGetPastPresentationTimingGOOGLE(VkDevice device, long swapchain, IntBuffer pPresentationTimingCount, VkPastPresentationTimingGOOGLE.Buffer pPresentationTimings) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pPresentationTimingCount, 1);
            Checks.checkSafe(pPresentationTimings, pPresentationTimingCount.get(pPresentationTimingCount.position()));
        }
        return GOOGLEDisplayTiming.nvkGetPastPresentationTimingGOOGLE(device, swapchain, MemoryUtil.memAddress(pPresentationTimingCount), MemoryUtil.memAddressSafe(pPresentationTimings));
    }

    public static int vkGetPastPresentationTimingGOOGLE(VkDevice device, long swapchain, int[] pPresentationTimingCount, VkPastPresentationTimingGOOGLE.Buffer pPresentationTimings) {
        long __functionAddress = device.getCapabilities().vkGetPastPresentationTimingGOOGLE;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pPresentationTimingCount, 1);
            Checks.checkSafe(pPresentationTimings, pPresentationTimingCount[0]);
        }
        return JNI.callPJPPI(__functionAddress, device.address(), swapchain, pPresentationTimingCount, MemoryUtil.memAddressSafe(pPresentationTimings));
    }
}

