/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.LongBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.vulkan.VKCapabilitiesDevice;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkDescriptorUpdateTemplateCreateInfoKHR;
import org.lwjgl.vulkan.VkDevice;

public class KHRDescriptorUpdateTemplate {
    public static final int VK_KHR_DESCRIPTOR_UPDATE_TEMPLATE_SPEC_VERSION = 1;
    public static final String VK_KHR_DESCRIPTOR_UPDATE_TEMPLATE_EXTENSION_NAME = "VK_KHR_descriptor_update_template";
    public static final int VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO_KHR = 1000085000;
    public static final int VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_KHR_EXT = 1000085000;
    public static final int VK_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_KHR = 1000085000;
    public static final int VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET_KHR = 0;
    public static final int VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS_KHR = 1;

    protected KHRDescriptorUpdateTemplate() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(VKCapabilitiesDevice caps) {
        return Checks.checkFunctions(caps.vkCreateDescriptorUpdateTemplateKHR, caps.vkDestroyDescriptorUpdateTemplateKHR, caps.vkUpdateDescriptorSetWithTemplateKHR, caps.vkCmdPushDescriptorSetWithTemplateKHR);
    }

    public static int nvkCreateDescriptorUpdateTemplateKHR(VkDevice device, long pCreateInfo, long pAllocator, long pDescriptorUpdateTemplate) {
        long __functionAddress = device.getCapabilities().vkCreateDescriptorUpdateTemplateKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkDescriptorUpdateTemplateCreateInfoKHR.validate(pCreateInfo);
            if (pAllocator != 0L) {
                VkAllocationCallbacks.validate(pAllocator);
            }
        }
        return JNI.callPPPPI(__functionAddress, device.address(), pCreateInfo, pAllocator, pDescriptorUpdateTemplate);
    }

    public static int vkCreateDescriptorUpdateTemplateKHR(VkDevice device, VkDescriptorUpdateTemplateCreateInfoKHR pCreateInfo, VkAllocationCallbacks pAllocator, LongBuffer pDescriptorUpdateTemplate) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pDescriptorUpdateTemplate, 1);
        }
        return KHRDescriptorUpdateTemplate.nvkCreateDescriptorUpdateTemplateKHR(device, pCreateInfo.address(), MemoryUtil.memAddressSafe(pAllocator), MemoryUtil.memAddress(pDescriptorUpdateTemplate));
    }

    public static void nvkDestroyDescriptorUpdateTemplateKHR(VkDevice device, long descriptorUpdateTemplate, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyDescriptorUpdateTemplateKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            if (pAllocator != 0L) {
                VkAllocationCallbacks.validate(pAllocator);
            }
        }
        JNI.callPJPV(__functionAddress, device.address(), descriptorUpdateTemplate, pAllocator);
    }

    public static void vkDestroyDescriptorUpdateTemplateKHR(VkDevice device, long descriptorUpdateTemplate, VkAllocationCallbacks pAllocator) {
        KHRDescriptorUpdateTemplate.nvkDestroyDescriptorUpdateTemplateKHR(device, descriptorUpdateTemplate, MemoryUtil.memAddressSafe(pAllocator));
    }

    public static void vkUpdateDescriptorSetWithTemplateKHR(VkDevice device, long descriptorSet, long descriptorUpdateTemplate, long pData) {
        long __functionAddress = device.getCapabilities().vkUpdateDescriptorSetWithTemplateKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pData);
        }
        JNI.callPJJPV(__functionAddress, device.address(), descriptorSet, descriptorUpdateTemplate, pData);
    }

    public static void vkCmdPushDescriptorSetWithTemplateKHR(VkCommandBuffer commandBuffer, long descriptorUpdateTemplate, long layout, int set, long pData) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdPushDescriptorSetWithTemplateKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pData);
        }
        JNI.callPJJPV(__functionAddress, commandBuffer.address(), descriptorUpdateTemplate, layout, set, pData);
    }

    public static int vkCreateDescriptorUpdateTemplateKHR(VkDevice device, VkDescriptorUpdateTemplateCreateInfoKHR pCreateInfo, VkAllocationCallbacks pAllocator, long[] pDescriptorUpdateTemplate) {
        long __functionAddress = device.getCapabilities().vkCreateDescriptorUpdateTemplateKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pDescriptorUpdateTemplate, 1);
            VkDescriptorUpdateTemplateCreateInfoKHR.validate(pCreateInfo.address());
            if (pAllocator != null) {
                VkAllocationCallbacks.validate(pAllocator.address());
            }
        }
        return JNI.callPPPPI(__functionAddress, device.address(), pCreateInfo.address(), MemoryUtil.memAddressSafe(pAllocator), pDescriptorUpdateTemplate);
    }
}

