/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.vulkan.VKCapabilitiesInstance;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkDisplayModeCreateInfoKHR;
import org.lwjgl.vulkan.VkDisplayModePropertiesKHR;
import org.lwjgl.vulkan.VkDisplayPlaneCapabilitiesKHR;
import org.lwjgl.vulkan.VkDisplayPlanePropertiesKHR;
import org.lwjgl.vulkan.VkDisplayPropertiesKHR;
import org.lwjgl.vulkan.VkDisplaySurfaceCreateInfoKHR;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkPhysicalDevice;

public class KHRDisplay {
    public static final int VK_KHR_DISPLAY_SPEC_VERSION = 21;
    public static final String VK_KHR_DISPLAY_EXTENSION_NAME = "VK_KHR_display";
    public static final int VK_STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR = 1000002000;
    public static final int VK_STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR = 1000002001;
    public static final int VK_OBJECT_TYPE_DISPLAY_KHR = 1000002000;
    public static final int VK_OBJECT_TYPE_DISPLAY_MODE_KHR = 1000002001;
    public static final int VK_DISPLAY_PLANE_ALPHA_OPAQUE_BIT_KHR = 1;
    public static final int VK_DISPLAY_PLANE_ALPHA_GLOBAL_BIT_KHR = 2;
    public static final int VK_DISPLAY_PLANE_ALPHA_PER_PIXEL_BIT_KHR = 4;
    public static final int VK_DISPLAY_PLANE_ALPHA_PER_PIXEL_PREMULTIPLIED_BIT_KHR = 8;

    protected KHRDisplay() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(VKCapabilitiesInstance caps) {
        return Checks.checkFunctions(caps.vkGetPhysicalDeviceDisplayPropertiesKHR, caps.vkGetPhysicalDeviceDisplayPlanePropertiesKHR, caps.vkGetDisplayPlaneSupportedDisplaysKHR, caps.vkGetDisplayModePropertiesKHR, caps.vkCreateDisplayModeKHR, caps.vkGetDisplayPlaneCapabilitiesKHR, caps.vkCreateDisplayPlaneSurfaceKHR);
    }

    public static int nvkGetPhysicalDeviceDisplayPropertiesKHR(VkPhysicalDevice physicalDevice, long pPropertyCount, long pProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceDisplayPropertiesKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(__functionAddress, physicalDevice.address(), pPropertyCount, pProperties);
    }

    public static int vkGetPhysicalDeviceDisplayPropertiesKHR(VkPhysicalDevice physicalDevice, IntBuffer pPropertyCount, VkDisplayPropertiesKHR.Buffer pProperties) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pPropertyCount, 1);
            Checks.checkSafe(pProperties, pPropertyCount.get(pPropertyCount.position()));
        }
        return KHRDisplay.nvkGetPhysicalDeviceDisplayPropertiesKHR(physicalDevice, MemoryUtil.memAddress(pPropertyCount), MemoryUtil.memAddressSafe(pProperties));
    }

    public static int nvkGetPhysicalDeviceDisplayPlanePropertiesKHR(VkPhysicalDevice physicalDevice, long pPropertyCount, long pProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceDisplayPlanePropertiesKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(__functionAddress, physicalDevice.address(), pPropertyCount, pProperties);
    }

    public static int vkGetPhysicalDeviceDisplayPlanePropertiesKHR(VkPhysicalDevice physicalDevice, IntBuffer pPropertyCount, VkDisplayPlanePropertiesKHR.Buffer pProperties) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pPropertyCount, 1);
            Checks.checkSafe(pProperties, pPropertyCount.get(pPropertyCount.position()));
        }
        return KHRDisplay.nvkGetPhysicalDeviceDisplayPlanePropertiesKHR(physicalDevice, MemoryUtil.memAddress(pPropertyCount), MemoryUtil.memAddressSafe(pProperties));
    }

    public static int nvkGetDisplayPlaneSupportedDisplaysKHR(VkPhysicalDevice physicalDevice, int planeIndex, long pDisplayCount, long pDisplays) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetDisplayPlaneSupportedDisplaysKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(__functionAddress, physicalDevice.address(), planeIndex, pDisplayCount, pDisplays);
    }

    public static int vkGetDisplayPlaneSupportedDisplaysKHR(VkPhysicalDevice physicalDevice, int planeIndex, IntBuffer pDisplayCount, LongBuffer pDisplays) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pDisplayCount, 1);
            Checks.checkSafe((Buffer)pDisplays, pDisplayCount.get(pDisplayCount.position()));
        }
        return KHRDisplay.nvkGetDisplayPlaneSupportedDisplaysKHR(physicalDevice, planeIndex, MemoryUtil.memAddress(pDisplayCount), MemoryUtil.memAddressSafe(pDisplays));
    }

    public static int nvkGetDisplayModePropertiesKHR(VkPhysicalDevice physicalDevice, long display, long pPropertyCount, long pProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetDisplayModePropertiesKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPPI(__functionAddress, physicalDevice.address(), display, pPropertyCount, pProperties);
    }

    public static int vkGetDisplayModePropertiesKHR(VkPhysicalDevice physicalDevice, long display, IntBuffer pPropertyCount, VkDisplayModePropertiesKHR.Buffer pProperties) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pPropertyCount, 1);
            Checks.checkSafe(pProperties, pPropertyCount.get(pPropertyCount.position()));
        }
        return KHRDisplay.nvkGetDisplayModePropertiesKHR(physicalDevice, display, MemoryUtil.memAddress(pPropertyCount), MemoryUtil.memAddressSafe(pProperties));
    }

    public static int nvkCreateDisplayModeKHR(VkPhysicalDevice physicalDevice, long display, long pCreateInfo, long pAllocator, long pMode) {
        long __functionAddress = physicalDevice.getCapabilities().vkCreateDisplayModeKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            if (pAllocator != 0L) {
                VkAllocationCallbacks.validate(pAllocator);
            }
        }
        return JNI.callPJPPPI(__functionAddress, physicalDevice.address(), display, pCreateInfo, pAllocator, pMode);
    }

    public static int vkCreateDisplayModeKHR(VkPhysicalDevice physicalDevice, long display, VkDisplayModeCreateInfoKHR pCreateInfo, VkAllocationCallbacks pAllocator, LongBuffer pMode) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pMode, 1);
        }
        return KHRDisplay.nvkCreateDisplayModeKHR(physicalDevice, display, pCreateInfo.address(), MemoryUtil.memAddressSafe(pAllocator), MemoryUtil.memAddress(pMode));
    }

    public static int nvkGetDisplayPlaneCapabilitiesKHR(VkPhysicalDevice physicalDevice, long mode, int planeIndex, long pCapabilities) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetDisplayPlaneCapabilitiesKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPI(__functionAddress, physicalDevice.address(), mode, planeIndex, pCapabilities);
    }

    public static int vkGetDisplayPlaneCapabilitiesKHR(VkPhysicalDevice physicalDevice, long mode, int planeIndex, VkDisplayPlaneCapabilitiesKHR pCapabilities) {
        return KHRDisplay.nvkGetDisplayPlaneCapabilitiesKHR(physicalDevice, mode, planeIndex, pCapabilities.address());
    }

    public static int nvkCreateDisplayPlaneSurfaceKHR(VkInstance instance, long pCreateInfo, long pAllocator, long pSurface) {
        long __functionAddress = instance.getCapabilities().vkCreateDisplayPlaneSurfaceKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            if (pAllocator != 0L) {
                VkAllocationCallbacks.validate(pAllocator);
            }
        }
        return JNI.callPPPPI(__functionAddress, instance.address(), pCreateInfo, pAllocator, pSurface);
    }

    public static int vkCreateDisplayPlaneSurfaceKHR(VkInstance instance, VkDisplaySurfaceCreateInfoKHR pCreateInfo, VkAllocationCallbacks pAllocator, LongBuffer pSurface) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pSurface, 1);
        }
        return KHRDisplay.nvkCreateDisplayPlaneSurfaceKHR(instance, pCreateInfo.address(), MemoryUtil.memAddressSafe(pAllocator), MemoryUtil.memAddress(pSurface));
    }

    public static int vkGetPhysicalDeviceDisplayPropertiesKHR(VkPhysicalDevice physicalDevice, int[] pPropertyCount, VkDisplayPropertiesKHR.Buffer pProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceDisplayPropertiesKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pPropertyCount, 1);
            Checks.checkSafe(pProperties, pPropertyCount[0]);
        }
        return JNI.callPPPI(__functionAddress, physicalDevice.address(), pPropertyCount, MemoryUtil.memAddressSafe(pProperties));
    }

    public static int vkGetPhysicalDeviceDisplayPlanePropertiesKHR(VkPhysicalDevice physicalDevice, int[] pPropertyCount, VkDisplayPlanePropertiesKHR.Buffer pProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceDisplayPlanePropertiesKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pPropertyCount, 1);
            Checks.checkSafe(pProperties, pPropertyCount[0]);
        }
        return JNI.callPPPI(__functionAddress, physicalDevice.address(), pPropertyCount, MemoryUtil.memAddressSafe(pProperties));
    }

    public static int vkGetDisplayPlaneSupportedDisplaysKHR(VkPhysicalDevice physicalDevice, int planeIndex, int[] pDisplayCount, long[] pDisplays) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetDisplayPlaneSupportedDisplaysKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pDisplayCount, 1);
            Checks.checkSafe(pDisplays, pDisplayCount[0]);
        }
        return JNI.callPPPI(__functionAddress, physicalDevice.address(), planeIndex, pDisplayCount, pDisplays);
    }

    public static int vkGetDisplayModePropertiesKHR(VkPhysicalDevice physicalDevice, long display, int[] pPropertyCount, VkDisplayModePropertiesKHR.Buffer pProperties) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetDisplayModePropertiesKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pPropertyCount, 1);
            Checks.checkSafe(pProperties, pPropertyCount[0]);
        }
        return JNI.callPJPPI(__functionAddress, physicalDevice.address(), display, pPropertyCount, MemoryUtil.memAddressSafe(pProperties));
    }

    public static int vkCreateDisplayModeKHR(VkPhysicalDevice physicalDevice, long display, VkDisplayModeCreateInfoKHR pCreateInfo, VkAllocationCallbacks pAllocator, long[] pMode) {
        long __functionAddress = physicalDevice.getCapabilities().vkCreateDisplayModeKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pMode, 1);
            if (pAllocator != null) {
                VkAllocationCallbacks.validate(pAllocator.address());
            }
        }
        return JNI.callPJPPPI(__functionAddress, physicalDevice.address(), display, pCreateInfo.address(), MemoryUtil.memAddressSafe(pAllocator), pMode);
    }

    public static int vkCreateDisplayPlaneSurfaceKHR(VkInstance instance, VkDisplaySurfaceCreateInfoKHR pCreateInfo, VkAllocationCallbacks pAllocator, long[] pSurface) {
        long __functionAddress = instance.getCapabilities().vkCreateDisplayPlaneSurfaceKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pSurface, 1);
            if (pAllocator != null) {
                VkAllocationCallbacks.validate(pAllocator.address());
            }
        }
        return JNI.callPPPPI(__functionAddress, instance.address(), pCreateInfo.address(), MemoryUtil.memAddressSafe(pAllocator), pSurface);
    }
}

