/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.vulkan.VKCapabilitiesDevice;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkPresentInfoKHR;
import org.lwjgl.vulkan.VkQueue;
import org.lwjgl.vulkan.VkSwapchainCreateInfoKHR;

public class KHRSwapchain {
    public static final int VK_KHR_SWAPCHAIN_SPEC_VERSION = 68;
    public static final String VK_KHR_SWAPCHAIN_EXTENSION_NAME = "VK_KHR_swapchain";
    public static final int VK_STRUCTURE_TYPE_SWAPCHAIN_CREATE_INFO_KHR = 1000001000;
    public static final int VK_STRUCTURE_TYPE_PRESENT_INFO_KHR = 1000001001;
    public static final int VK_IMAGE_LAYOUT_PRESENT_SRC_KHR = 1000001002;
    public static final int VK_SUBOPTIMAL_KHR = 1000001003;
    public static final int VK_ERROR_OUT_OF_DATE_KHR = -1000001004;
    public static final int VK_OBJECT_TYPE_SWAPCHAIN_KHR = 1000001000;

    protected KHRSwapchain() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(VKCapabilitiesDevice caps) {
        return Checks.checkFunctions(caps.vkCreateSwapchainKHR, caps.vkDestroySwapchainKHR, caps.vkGetSwapchainImagesKHR, caps.vkAcquireNextImageKHR, caps.vkQueuePresentKHR);
    }

    public static int nvkCreateSwapchainKHR(VkDevice device, long pCreateInfo, long pAllocator, long pSwapchain) {
        long __functionAddress = device.getCapabilities().vkCreateSwapchainKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkSwapchainCreateInfoKHR.validate(pCreateInfo);
            if (pAllocator != 0L) {
                VkAllocationCallbacks.validate(pAllocator);
            }
        }
        return JNI.callPPPPI(__functionAddress, device.address(), pCreateInfo, pAllocator, pSwapchain);
    }

    public static int vkCreateSwapchainKHR(VkDevice device, VkSwapchainCreateInfoKHR pCreateInfo, VkAllocationCallbacks pAllocator, LongBuffer pSwapchain) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pSwapchain, 1);
        }
        return KHRSwapchain.nvkCreateSwapchainKHR(device, pCreateInfo.address(), MemoryUtil.memAddressSafe(pAllocator), MemoryUtil.memAddress(pSwapchain));
    }

    public static void nvkDestroySwapchainKHR(VkDevice device, long swapchain, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroySwapchainKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            if (pAllocator != 0L) {
                VkAllocationCallbacks.validate(pAllocator);
            }
        }
        JNI.callPJPV(__functionAddress, device.address(), swapchain, pAllocator);
    }

    public static void vkDestroySwapchainKHR(VkDevice device, long swapchain, VkAllocationCallbacks pAllocator) {
        KHRSwapchain.nvkDestroySwapchainKHR(device, swapchain, MemoryUtil.memAddressSafe(pAllocator));
    }

    public static int nvkGetSwapchainImagesKHR(VkDevice device, long swapchain, long pSwapchainImageCount, long pSwapchainImages) {
        long __functionAddress = device.getCapabilities().vkGetSwapchainImagesKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPPI(__functionAddress, device.address(), swapchain, pSwapchainImageCount, pSwapchainImages);
    }

    public static int vkGetSwapchainImagesKHR(VkDevice device, long swapchain, IntBuffer pSwapchainImageCount, LongBuffer pSwapchainImages) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pSwapchainImageCount, 1);
            Checks.checkSafe((Buffer)pSwapchainImages, pSwapchainImageCount.get(pSwapchainImageCount.position()));
        }
        return KHRSwapchain.nvkGetSwapchainImagesKHR(device, swapchain, MemoryUtil.memAddress(pSwapchainImageCount), MemoryUtil.memAddressSafe(pSwapchainImages));
    }

    public static int nvkAcquireNextImageKHR(VkDevice device, long swapchain, long timeout, long semaphore, long fence, long pImageIndex) {
        long __functionAddress = device.getCapabilities().vkAcquireNextImageKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJJJJPI(__functionAddress, device.address(), swapchain, timeout, semaphore, fence, pImageIndex);
    }

    public static int vkAcquireNextImageKHR(VkDevice device, long swapchain, long timeout, long semaphore, long fence, IntBuffer pImageIndex) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pImageIndex, 1);
        }
        return KHRSwapchain.nvkAcquireNextImageKHR(device, swapchain, timeout, semaphore, fence, MemoryUtil.memAddress(pImageIndex));
    }

    public static int nvkQueuePresentKHR(VkQueue queue, long pPresentInfo) {
        long __functionAddress = queue.getCapabilities().vkQueuePresentKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkPresentInfoKHR.validate(pPresentInfo);
        }
        return JNI.callPPI(__functionAddress, queue.address(), pPresentInfo);
    }

    public static int vkQueuePresentKHR(VkQueue queue, VkPresentInfoKHR pPresentInfo) {
        return KHRSwapchain.nvkQueuePresentKHR(queue, pPresentInfo.address());
    }

    public static int vkCreateSwapchainKHR(VkDevice device, VkSwapchainCreateInfoKHR pCreateInfo, VkAllocationCallbacks pAllocator, long[] pSwapchain) {
        long __functionAddress = device.getCapabilities().vkCreateSwapchainKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pSwapchain, 1);
            VkSwapchainCreateInfoKHR.validate(pCreateInfo.address());
            if (pAllocator != null) {
                VkAllocationCallbacks.validate(pAllocator.address());
            }
        }
        return JNI.callPPPPI(__functionAddress, device.address(), pCreateInfo.address(), MemoryUtil.memAddressSafe(pAllocator), pSwapchain);
    }

    public static int vkGetSwapchainImagesKHR(VkDevice device, long swapchain, int[] pSwapchainImageCount, long[] pSwapchainImages) {
        long __functionAddress = device.getCapabilities().vkGetSwapchainImagesKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pSwapchainImageCount, 1);
            Checks.checkSafe(pSwapchainImages, pSwapchainImageCount[0]);
        }
        return JNI.callPJPPI(__functionAddress, device.address(), swapchain, pSwapchainImageCount, pSwapchainImages);
    }

    public static int vkAcquireNextImageKHR(VkDevice device, long swapchain, long timeout, long semaphore, long fence, int[] pImageIndex) {
        long __functionAddress = device.getCapabilities().vkAcquireNextImageKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pImageIndex, 1);
        }
        return JNI.callPJJJJPI(__functionAddress, device.address(), swapchain, timeout, semaphore, fence, pImageIndex);
    }
}

