/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.vulkan.VKCapabilitiesDevice;
import org.lwjgl.vulkan.VKCapabilitiesInstance;
import org.lwjgl.vulkan.VkAcquireNextImageInfoKHX;
import org.lwjgl.vulkan.VkBindBufferMemoryInfoKHX;
import org.lwjgl.vulkan.VkBindImageMemoryInfoKHX;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkDeviceGroupPresentCapabilitiesKHX;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.VkRect2D;

public class KHXDeviceGroup {
    public static final int VK_KHX_DEVICE_GROUP_SPEC_VERSION = 1;
    public static final String VK_KHX_DEVICE_GROUP_EXTENSION_NAME = "VK_KHX_device_group";
    public static final int VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO_KHX = 1000060000;
    public static final int VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO_KHX = 1000060001;
    public static final int VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO_KHX = 1000060002;
    public static final int VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO_KHX = 1000060003;
    public static final int VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO_KHX = 1000060004;
    public static final int VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO_KHX = 1000060005;
    public static final int VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO_KHX = 1000060006;
    public static final int VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_CAPABILITIES_KHX = 1000060007;
    public static final int VK_STRUCTURE_TYPE_IMAGE_SWAPCHAIN_CREATE_INFO_KHX = 1000060008;
    public static final int VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHX = 1000060009;
    public static final int VK_STRUCTURE_TYPE_ACQUIRE_NEXT_IMAGE_INFO_KHX = 1000060010;
    public static final int VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHX = 1000060011;
    public static final int VK_STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHX = 1000060012;
    public static final int VK_IMAGE_CREATE_BIND_SFR_BIT_KHX = 64;
    public static final int VK_PIPELINE_CREATE_VIEW_INDEX_FROM_DEVICE_INDEX_BIT_KHX = 8;
    public static final int VK_PIPELINE_CREATE_DISPATCH_BASE_KHX = 16;
    public static final int VK_DEPENDENCY_DEVICE_GROUP_BIT_KHX = 4;
    public static final int VK_SWAPCHAIN_CREATE_BIND_SFR_BIT_KHX = 1;
    public static final int VK_PEER_MEMORY_FEATURE_COPY_SRC_BIT_KHX = 1;
    public static final int VK_PEER_MEMORY_FEATURE_COPY_DST_BIT_KHX = 2;
    public static final int VK_PEER_MEMORY_FEATURE_GENERIC_SRC_BIT_KHX = 4;
    public static final int VK_PEER_MEMORY_FEATURE_GENERIC_DST_BIT_KHX = 8;
    public static final int VK_MEMORY_ALLOCATE_DEVICE_MASK_BIT_KHX = 1;
    public static final int VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_BIT_KHX = 1;
    public static final int VK_DEVICE_GROUP_PRESENT_MODE_REMOTE_BIT_KHX = 2;
    public static final int VK_DEVICE_GROUP_PRESENT_MODE_SUM_BIT_KHX = 4;
    public static final int VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_MULTI_DEVICE_BIT_KHX = 8;

    protected KHXDeviceGroup() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(VKCapabilitiesInstance caps) {
        return Checks.checkFunctions(caps.vkGetPhysicalDevicePresentRectanglesKHX);
    }

    static boolean isAvailable(VKCapabilitiesInstance capsInstance, VKCapabilitiesDevice caps) {
        return KHXDeviceGroup.isAvailable(capsInstance) && Checks.checkFunctions(caps.vkGetDeviceGroupPeerMemoryFeaturesKHX, caps.vkBindBufferMemory2KHX, caps.vkBindImageMemory2KHX, caps.vkCmdSetDeviceMaskKHX, caps.vkGetDeviceGroupPresentCapabilitiesKHX, caps.vkGetDeviceGroupSurfacePresentModesKHX, caps.vkAcquireNextImage2KHX, caps.vkCmdDispatchBaseKHX);
    }

    public static void nvkGetDeviceGroupPeerMemoryFeaturesKHX(VkDevice device, int heapIndex, int localDeviceIndex, int remoteDeviceIndex, long pPeerMemoryFeatures) {
        long __functionAddress = device.getCapabilities().vkGetDeviceGroupPeerMemoryFeaturesKHX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(__functionAddress, device.address(), heapIndex, localDeviceIndex, remoteDeviceIndex, pPeerMemoryFeatures);
    }

    public static void vkGetDeviceGroupPeerMemoryFeaturesKHX(VkDevice device, int heapIndex, int localDeviceIndex, int remoteDeviceIndex, IntBuffer pPeerMemoryFeatures) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pPeerMemoryFeatures, 1);
        }
        KHXDeviceGroup.nvkGetDeviceGroupPeerMemoryFeaturesKHX(device, heapIndex, localDeviceIndex, remoteDeviceIndex, MemoryUtil.memAddress(pPeerMemoryFeatures));
    }

    public static int nvkBindBufferMemory2KHX(VkDevice device, int bindInfoCount, long pBindInfos) {
        long __functionAddress = device.getCapabilities().vkBindBufferMemory2KHX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkBindBufferMemoryInfoKHX.validate(pBindInfos, bindInfoCount);
        }
        return JNI.callPPI(__functionAddress, device.address(), bindInfoCount, pBindInfos);
    }

    public static int vkBindBufferMemory2KHX(VkDevice device, VkBindBufferMemoryInfoKHX.Buffer pBindInfos) {
        return KHXDeviceGroup.nvkBindBufferMemory2KHX(device, pBindInfos.remaining(), pBindInfos.address());
    }

    public static int nvkBindImageMemory2KHX(VkDevice device, int bindInfoCount, long pBindInfos) {
        long __functionAddress = device.getCapabilities().vkBindImageMemory2KHX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkBindImageMemoryInfoKHX.validate(pBindInfos, bindInfoCount);
        }
        return JNI.callPPI(__functionAddress, device.address(), bindInfoCount, pBindInfos);
    }

    public static int vkBindImageMemory2KHX(VkDevice device, VkBindImageMemoryInfoKHX.Buffer pBindInfos) {
        return KHXDeviceGroup.nvkBindImageMemory2KHX(device, pBindInfos.remaining(), pBindInfos.address());
    }

    public static void vkCmdSetDeviceMaskKHX(VkCommandBuffer commandBuffer, int deviceMask) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetDeviceMaskKHX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, commandBuffer.address(), deviceMask);
    }

    public static int nvkGetDeviceGroupPresentCapabilitiesKHX(VkDevice device, long pDeviceGroupPresentCapabilities) {
        long __functionAddress = device.getCapabilities().vkGetDeviceGroupPresentCapabilitiesKHX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(__functionAddress, device.address(), pDeviceGroupPresentCapabilities);
    }

    public static int vkGetDeviceGroupPresentCapabilitiesKHX(VkDevice device, VkDeviceGroupPresentCapabilitiesKHX pDeviceGroupPresentCapabilities) {
        return KHXDeviceGroup.nvkGetDeviceGroupPresentCapabilitiesKHX(device, pDeviceGroupPresentCapabilities.address());
    }

    public static int nvkGetDeviceGroupSurfacePresentModesKHX(VkDevice device, long surface, long pModes) {
        long __functionAddress = device.getCapabilities().vkGetDeviceGroupSurfacePresentModesKHX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPI(__functionAddress, device.address(), surface, pModes);
    }

    public static int vkGetDeviceGroupSurfacePresentModesKHX(VkDevice device, long surface, IntBuffer pModes) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pModes, 1);
        }
        return KHXDeviceGroup.nvkGetDeviceGroupSurfacePresentModesKHX(device, surface, MemoryUtil.memAddress(pModes));
    }

    public static int nvkAcquireNextImage2KHX(VkDevice device, long pAcquireInfo, long pImageIndex) {
        long __functionAddress = device.getCapabilities().vkAcquireNextImage2KHX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(__functionAddress, device.address(), pAcquireInfo, pImageIndex);
    }

    public static int vkAcquireNextImage2KHX(VkDevice device, VkAcquireNextImageInfoKHX pAcquireInfo, IntBuffer pImageIndex) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pImageIndex, 1);
        }
        return KHXDeviceGroup.nvkAcquireNextImage2KHX(device, pAcquireInfo.address(), MemoryUtil.memAddress(pImageIndex));
    }

    public static void vkCmdDispatchBaseKHX(VkCommandBuffer commandBuffer, int baseGroupX, int baseGroupY, int baseGroupZ, int groupCountX, int groupCountY, int groupCountZ) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdDispatchBaseKHX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, commandBuffer.address(), baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY, groupCountZ);
    }

    public static int nvkGetPhysicalDevicePresentRectanglesKHX(VkPhysicalDevice physicalDevice, long surface, long pRectCount, long pRects) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDevicePresentRectanglesKHX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPPI(__functionAddress, physicalDevice.address(), surface, pRectCount, pRects);
    }

    public static int vkGetPhysicalDevicePresentRectanglesKHX(VkPhysicalDevice physicalDevice, long surface, IntBuffer pRectCount, VkRect2D.Buffer pRects) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pRectCount, 1);
            Checks.checkSafe(pRects, pRectCount.get(pRectCount.position()));
        }
        return KHXDeviceGroup.nvkGetPhysicalDevicePresentRectanglesKHX(physicalDevice, surface, MemoryUtil.memAddress(pRectCount), MemoryUtil.memAddressSafe(pRects));
    }

    public static void vkGetDeviceGroupPeerMemoryFeaturesKHX(VkDevice device, int heapIndex, int localDeviceIndex, int remoteDeviceIndex, int[] pPeerMemoryFeatures) {
        long __functionAddress = device.getCapabilities().vkGetDeviceGroupPeerMemoryFeaturesKHX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pPeerMemoryFeatures, 1);
        }
        JNI.callPPV(__functionAddress, device.address(), heapIndex, localDeviceIndex, remoteDeviceIndex, pPeerMemoryFeatures);
    }

    public static int vkGetDeviceGroupSurfacePresentModesKHX(VkDevice device, long surface, int[] pModes) {
        long __functionAddress = device.getCapabilities().vkGetDeviceGroupSurfacePresentModesKHX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pModes, 1);
        }
        return JNI.callPJPI(__functionAddress, device.address(), surface, pModes);
    }

    public static int vkAcquireNextImage2KHX(VkDevice device, VkAcquireNextImageInfoKHX pAcquireInfo, int[] pImageIndex) {
        long __functionAddress = device.getCapabilities().vkAcquireNextImage2KHX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pImageIndex, 1);
        }
        return JNI.callPPPI(__functionAddress, device.address(), pAcquireInfo.address(), pImageIndex);
    }

    public static int vkGetPhysicalDevicePresentRectanglesKHX(VkPhysicalDevice physicalDevice, long surface, int[] pRectCount, VkRect2D.Buffer pRects) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDevicePresentRectanglesKHX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pRectCount, 1);
            Checks.checkSafe(pRects, pRectCount[0]);
        }
        return JNI.callPJPPI(__functionAddress, physicalDevice.address(), surface, pRectCount, MemoryUtil.memAddressSafe(pRects));
    }
}

