/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.vulkan.VKCapabilitiesInstance;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkPhysicalDeviceGroupPropertiesKHX;

public class KHXDeviceGroupCreation {
    public static final int VK_KHX_DEVICE_GROUP_CREATION_SPEC_VERSION = 1;
    public static final String VK_KHX_DEVICE_GROUP_CREATION_EXTENSION_NAME = "VK_KHX_device_group_creation";
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES_KHX = 1000070000;
    public static final int VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO_KHX = 1000070001;
    public static final int VK_MAX_DEVICE_GROUP_SIZE_KHX = 32;
    public static final int VK_MEMORY_HEAP_MULTI_INSTANCE_BIT_KHX = 2;

    protected KHXDeviceGroupCreation() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(VKCapabilitiesInstance caps) {
        return Checks.checkFunctions(caps.vkEnumeratePhysicalDeviceGroupsKHX);
    }

    public static int nvkEnumeratePhysicalDeviceGroupsKHX(VkInstance instance, long pPhysicalDeviceGroupCount, long pPhysicalDeviceGroupProperties) {
        long __functionAddress = instance.getCapabilities().vkEnumeratePhysicalDeviceGroupsKHX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(__functionAddress, instance.address(), pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties);
    }

    public static int vkEnumeratePhysicalDeviceGroupsKHX(VkInstance instance, IntBuffer pPhysicalDeviceGroupCount, VkPhysicalDeviceGroupPropertiesKHX.Buffer pPhysicalDeviceGroupProperties) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pPhysicalDeviceGroupCount, 1);
            Checks.checkSafe(pPhysicalDeviceGroupProperties, pPhysicalDeviceGroupCount.get(pPhysicalDeviceGroupCount.position()));
        }
        return KHXDeviceGroupCreation.nvkEnumeratePhysicalDeviceGroupsKHX(instance, MemoryUtil.memAddress(pPhysicalDeviceGroupCount), MemoryUtil.memAddressSafe(pPhysicalDeviceGroupProperties));
    }

    public static int vkEnumeratePhysicalDeviceGroupsKHX(VkInstance instance, int[] pPhysicalDeviceGroupCount, VkPhysicalDeviceGroupPropertiesKHX.Buffer pPhysicalDeviceGroupProperties) {
        long __functionAddress = instance.getCapabilities().vkEnumeratePhysicalDeviceGroupsKHX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pPhysicalDeviceGroupCount, 1);
            Checks.checkSafe(pPhysicalDeviceGroupProperties, pPhysicalDeviceGroupCount[0]);
        }
        return JNI.callPPPI(__functionAddress, instance.address(), pPhysicalDeviceGroupCount, MemoryUtil.memAddressSafe(pPhysicalDeviceGroupProperties));
    }
}

