/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.vulkan.VKCapabilitiesDevice;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkMemoryFdPropertiesKHX;

public class KHXExternalMemoryFd {
    public static final int VK_KHX_EXTERNAL_MEMORY_FD_SPEC_VERSION = 1;
    public static final String VK_KHX_EXTERNAL_MEMORY_FD_EXTENSION_NAME = "VK_KHX_external_memory_fd";
    public static final int VK_STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHX = 1000074000;
    public static final int VK_STRUCTURE_TYPE_MEMORY_FD_PROPERTIES_KHX = 1000074001;

    protected KHXExternalMemoryFd() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(VKCapabilitiesDevice caps) {
        return Checks.checkFunctions(caps.vkGetMemoryFdKHX, caps.vkGetMemoryFdPropertiesKHX);
    }

    public static int nvkGetMemoryFdKHX(VkDevice device, long memory, int handleType, long pFd) {
        long __functionAddress = device.getCapabilities().vkGetMemoryFdKHX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPI(__functionAddress, device.address(), memory, handleType, pFd);
    }

    public static int vkGetMemoryFdKHX(VkDevice device, long memory, int handleType, IntBuffer pFd) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pFd, 1);
        }
        return KHXExternalMemoryFd.nvkGetMemoryFdKHX(device, memory, handleType, MemoryUtil.memAddress(pFd));
    }

    public static int nvkGetMemoryFdPropertiesKHX(VkDevice device, int handleType, int fd, long pMemoryFdProperties) {
        long __functionAddress = device.getCapabilities().vkGetMemoryFdPropertiesKHX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(__functionAddress, device.address(), handleType, fd, pMemoryFdProperties);
    }

    public static int vkGetMemoryFdPropertiesKHX(VkDevice device, int handleType, int fd, VkMemoryFdPropertiesKHX pMemoryFdProperties) {
        return KHXExternalMemoryFd.nvkGetMemoryFdPropertiesKHX(device, handleType, fd, pMemoryFdProperties.address());
    }

    public static int vkGetMemoryFdKHX(VkDevice device, long memory, int handleType, int[] pFd) {
        long __functionAddress = device.getCapabilities().vkGetMemoryFdKHX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pFd, 1);
        }
        return JNI.callPJPI(__functionAddress, device.address(), memory, handleType, pFd);
    }
}

