/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.vulkan.VKCapabilitiesDevice;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkMemoryWin32HandlePropertiesKHX;

public class KHXExternalMemoryWin32 {
    public static final int VK_KHX_EXTERNAL_MEMORY_WIN32_SPEC_VERSION = 1;
    public static final String VK_KHX_EXTERNAL_MEMORY_WIN32_EXTENSION_NAME = "VK_KHX_external_memory_win32";
    public static final int VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_KHX = 1000073000;
    public static final int VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_KHX = 1000073001;
    public static final int VK_STRUCTURE_TYPE_MEMORY_WIN32_HANDLE_PROPERTIES_KHX = 1000073002;

    protected KHXExternalMemoryWin32() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(VKCapabilitiesDevice caps) {
        return Checks.checkFunctions(caps.vkGetMemoryWin32HandleKHX, caps.vkGetMemoryWin32HandlePropertiesKHX);
    }

    public static int nvkGetMemoryWin32HandleKHX(VkDevice device, long memory, int handleType, long pHandle) {
        long __functionAddress = device.getCapabilities().vkGetMemoryWin32HandleKHX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPI(__functionAddress, device.address(), memory, handleType, pHandle);
    }

    public static int vkGetMemoryWin32HandleKHX(VkDevice device, long memory, int handleType, PointerBuffer pHandle) {
        if (Checks.CHECKS) {
            Checks.check(pHandle, 1);
        }
        return KHXExternalMemoryWin32.nvkGetMemoryWin32HandleKHX(device, memory, handleType, MemoryUtil.memAddress(pHandle));
    }

    public static int nvkGetMemoryWin32HandlePropertiesKHX(VkDevice device, int handleType, long handle, long pMemoryWin32HandleProperties) {
        long __functionAddress = device.getCapabilities().vkGetMemoryWin32HandlePropertiesKHX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(handle);
        }
        return JNI.callPPPI(__functionAddress, device.address(), handleType, handle, pMemoryWin32HandleProperties);
    }

    public static int vkGetMemoryWin32HandlePropertiesKHX(VkDevice device, int handleType, long handle, VkMemoryWin32HandlePropertiesKHX pMemoryWin32HandleProperties) {
        return KHXExternalMemoryWin32.nvkGetMemoryWin32HandlePropertiesKHX(device, handleType, handle, pMemoryWin32HandleProperties.address());
    }
}

