/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.LongBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.vulkan.VKCapabilitiesInstance;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkIOSSurfaceCreateInfoMVK;
import org.lwjgl.vulkan.VkInstance;

public class MVKIosSurface {
    public static final int VK_MVK_IOS_SURFACE_SPEC_VERSION = 2;
    public static final String VK_MVK_IOS_SURFACE_EXTENSION_NAME = "VK_MVK_ios_surface";
    public static final int VK_STRUCTURE_TYPE_IOS_SURFACE_CREATE_INFO_MVK = 1000122000;

    protected MVKIosSurface() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(VKCapabilitiesInstance caps) {
        return Checks.checkFunctions(caps.vkCreateIOSSurfaceMVK);
    }

    public static int nvkCreateIOSSurfaceMVK(VkInstance instance, long pCreateInfo, long pAllocator, long pSurface) {
        long __functionAddress = instance.getCapabilities().vkCreateIOSSurfaceMVK;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkIOSSurfaceCreateInfoMVK.validate(pCreateInfo);
            if (pAllocator != 0L) {
                VkAllocationCallbacks.validate(pAllocator);
            }
        }
        return JNI.callPPPPI(__functionAddress, instance.address(), pCreateInfo, pAllocator, pSurface);
    }

    public static int vkCreateIOSSurfaceMVK(VkInstance instance, VkIOSSurfaceCreateInfoMVK pCreateInfo, VkAllocationCallbacks pAllocator, LongBuffer pSurface) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pSurface, 1);
        }
        return MVKIosSurface.nvkCreateIOSSurfaceMVK(instance, pCreateInfo.address(), MemoryUtil.memAddressSafe(pAllocator), MemoryUtil.memAddress(pSurface));
    }

    public static int vkCreateIOSSurfaceMVK(VkInstance instance, VkIOSSurfaceCreateInfoMVK pCreateInfo, VkAllocationCallbacks pAllocator, long[] pSurface) {
        long __functionAddress = instance.getCapabilities().vkCreateIOSSurfaceMVK;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pSurface, 1);
            VkIOSSurfaceCreateInfoMVK.validate(pCreateInfo.address());
            if (pAllocator != null) {
                VkAllocationCallbacks.validate(pAllocator.address());
            }
        }
        return JNI.callPPPPI(__functionAddress, instance.address(), pCreateInfo.address(), MemoryUtil.memAddressSafe(pAllocator), pSurface);
    }
}

