/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.LongBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.vulkan.VKCapabilitiesInstance;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkMacOSSurfaceCreateInfoMVK;

public class MVKMacosSurface {
    public static final int VK_MVK_MACOS_SURFACE_SPEC_VERSION = 2;
    public static final String VK_MVK_MACOS_SURFACE_EXTENSION_NAME = "VK_MVK_macos_surface";
    public static final int VK_STRUCTURE_TYPE_MACOS_SURFACE_CREATE_INFO_MVK = 1000123000;

    protected MVKMacosSurface() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(VKCapabilitiesInstance caps) {
        return Checks.checkFunctions(caps.vkCreateMacOSSurfaceMVK);
    }

    public static int nvkCreateMacOSSurfaceMVK(VkInstance instance, long pCreateInfo, long pAllocator, long pSurface) {
        long __functionAddress = instance.getCapabilities().vkCreateMacOSSurfaceMVK;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkMacOSSurfaceCreateInfoMVK.validate(pCreateInfo);
            if (pAllocator != 0L) {
                VkAllocationCallbacks.validate(pAllocator);
            }
        }
        return JNI.callPPPPI(__functionAddress, instance.address(), pCreateInfo, pAllocator, pSurface);
    }

    public static int vkCreateMacOSSurfaceMVK(VkInstance instance, VkMacOSSurfaceCreateInfoMVK pCreateInfo, VkAllocationCallbacks pAllocator, LongBuffer pSurface) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pSurface, 1);
        }
        return MVKMacosSurface.nvkCreateMacOSSurfaceMVK(instance, pCreateInfo.address(), MemoryUtil.memAddressSafe(pAllocator), MemoryUtil.memAddress(pSurface));
    }

    public static int vkCreateMacOSSurfaceMVK(VkInstance instance, VkMacOSSurfaceCreateInfoMVK pCreateInfo, VkAllocationCallbacks pAllocator, long[] pSurface) {
        long __functionAddress = instance.getCapabilities().vkCreateMacOSSurfaceMVK;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pSurface, 1);
            VkMacOSSurfaceCreateInfoMVK.validate(pCreateInfo.address());
            if (pAllocator != null) {
                VkAllocationCallbacks.validate(pAllocator.address());
            }
        }
        return JNI.callPPPPI(__functionAddress, instance.address(), pCreateInfo.address(), MemoryUtil.memAddressSafe(pAllocator), pSurface);
    }
}

