/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.vulkan.VKCapabilitiesDevice;
import org.lwjgl.vulkan.VKCapabilitiesInstance;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkCmdProcessCommandsInfoNVX;
import org.lwjgl.vulkan.VkCmdReserveSpaceForCommandsInfoNVX;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkDeviceGeneratedCommandsFeaturesNVX;
import org.lwjgl.vulkan.VkDeviceGeneratedCommandsLimitsNVX;
import org.lwjgl.vulkan.VkIndirectCommandsLayoutCreateInfoNVX;
import org.lwjgl.vulkan.VkObjectTableCreateInfoNVX;
import org.lwjgl.vulkan.VkPhysicalDevice;

public class NVXDeviceGeneratedCommands {
    public static final int VK_NVX_DEVICE_GENERATED_COMMANDS_SPEC_VERSION = 1;
    public static final String VK_NVX_DEVICE_GENERATED_COMMANDS_EXTENSION_NAME = "VK_NVX_device_generated_commands";
    public static final int VK_STRUCTURE_TYPE_OBJECT_TABLE_CREATE_INFO_NVX = 1000086000;
    public static final int VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_NVX = 1000086001;
    public static final int VK_STRUCTURE_TYPE_CMD_PROCESS_COMMANDS_INFO_NVX = 1000086002;
    public static final int VK_STRUCTURE_TYPE_CMD_RESERVE_SPACE_FOR_COMMANDS_INFO_NVX = 1000086003;
    public static final int VK_STRUCTURE_TYPE_DEVICE_GENERATED_COMMANDS_LIMITS_NVX = 1000086004;
    public static final int VK_STRUCTURE_TYPE_DEVICE_GENERATED_COMMANDS_FEATURES_NVX = 1000086005;
    public static final int VK_PIPELINE_STAGE_COMMAND_PROCESS_BIT_NVX = 131072;
    public static final int VK_ACCESS_COMMAND_PROCESS_READ_BIT_NVX = 131072;
    public static final int VK_ACCESS_COMMAND_PROCESS_WRITE_BIT_NVX = 262144;
    public static final int VK_OBJECT_TYPE_OBJECT_TABLE_NVX = 1000086000;
    public static final int VK_OBJECT_TYPE_INDIRECT_COMMANDS_LAYOUT_NVX = 1000086001;
    public static final int VK_INDIRECT_COMMANDS_LAYOUT_USAGE_UNORDERED_SEQUENCES_BIT_NVX = 1;
    public static final int VK_INDIRECT_COMMANDS_LAYOUT_USAGE_SPARSE_SEQUENCES_BIT_NVX = 2;
    public static final int VK_INDIRECT_COMMANDS_LAYOUT_USAGE_EMPTY_EXECUTIONS_BIT_NVX = 4;
    public static final int VK_INDIRECT_COMMANDS_LAYOUT_USAGE_INDEXED_SEQUENCES_BIT_NVX = 8;
    public static final int VK_OBJECT_ENTRY_USAGE_GRAPHICS_BIT_NVX = 1;
    public static final int VK_OBJECT_ENTRY_USAGE_COMPUTE_BIT_NVX = 2;
    public static final int VK_INDIRECT_COMMANDS_TOKEN_PIPELINE_NVX = 0;
    public static final int VK_INDIRECT_COMMANDS_TOKEN_DESCRIPTOR_SET_NVX = 1;
    public static final int VK_INDIRECT_COMMANDS_TOKEN_INDEX_BUFFER_NVX = 2;
    public static final int VK_INDIRECT_COMMANDS_TOKEN_VERTEX_BUFFER_NVX = 3;
    public static final int VK_INDIRECT_COMMANDS_TOKEN_PUSH_CONSTANT_NVX = 4;
    public static final int VK_INDIRECT_COMMANDS_TOKEN_DRAW_INDEXED_NVX = 5;
    public static final int VK_INDIRECT_COMMANDS_TOKEN_DRAW_NVX = 6;
    public static final int VK_INDIRECT_COMMANDS_TOKEN_DISPATCH_NVX = 7;
    public static final int VK_OBJECT_ENTRY_DESCRIPTOR_SET_NVX = 0;
    public static final int VK_OBJECT_ENTRY_PIPELINE_NVX = 1;
    public static final int VK_OBJECT_ENTRY_INDEX_BUFFER_NVX = 2;
    public static final int VK_OBJECT_ENTRY_VERTEX_BUFFER_NVX = 3;
    public static final int VK_OBJECT_ENTRY_PUSH_CONSTANT_NVX = 4;

    protected NVXDeviceGeneratedCommands() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(VKCapabilitiesInstance caps) {
        return Checks.checkFunctions(caps.vkGetPhysicalDeviceGeneratedCommandsPropertiesNVX);
    }

    static boolean isAvailable(VKCapabilitiesInstance capsInstance, VKCapabilitiesDevice caps) {
        return NVXDeviceGeneratedCommands.isAvailable(capsInstance) && Checks.checkFunctions(caps.vkCmdProcessCommandsNVX, caps.vkCmdReserveSpaceForCommandsNVX, caps.vkCreateIndirectCommandsLayoutNVX, caps.vkDestroyIndirectCommandsLayoutNVX, caps.vkCreateObjectTableNVX, caps.vkDestroyObjectTableNVX, caps.vkRegisterObjectsNVX, caps.vkUnregisterObjectsNVX);
    }

    public static void nvkCmdProcessCommandsNVX(VkCommandBuffer commandBuffer, long pProcessCommandsInfo) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdProcessCommandsNVX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkCmdProcessCommandsInfoNVX.validate(pProcessCommandsInfo);
        }
        JNI.callPPV(__functionAddress, commandBuffer.address(), pProcessCommandsInfo);
    }

    public static void vkCmdProcessCommandsNVX(VkCommandBuffer commandBuffer, VkCmdProcessCommandsInfoNVX pProcessCommandsInfo) {
        NVXDeviceGeneratedCommands.nvkCmdProcessCommandsNVX(commandBuffer, pProcessCommandsInfo.address());
    }

    public static void nvkCmdReserveSpaceForCommandsNVX(VkCommandBuffer commandBuffer, long pReserveSpaceInfo) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdReserveSpaceForCommandsNVX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(__functionAddress, commandBuffer.address(), pReserveSpaceInfo);
    }

    public static void vkCmdReserveSpaceForCommandsNVX(VkCommandBuffer commandBuffer, VkCmdReserveSpaceForCommandsInfoNVX pReserveSpaceInfo) {
        NVXDeviceGeneratedCommands.nvkCmdReserveSpaceForCommandsNVX(commandBuffer, pReserveSpaceInfo.address());
    }

    public static int nvkCreateIndirectCommandsLayoutNVX(VkDevice device, long pCreateInfo, long pAllocator, long pIndirectCommandsLayout) {
        long __functionAddress = device.getCapabilities().vkCreateIndirectCommandsLayoutNVX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkIndirectCommandsLayoutCreateInfoNVX.validate(pCreateInfo);
            if (pAllocator != 0L) {
                VkAllocationCallbacks.validate(pAllocator);
            }
        }
        return JNI.callPPPPI(__functionAddress, device.address(), pCreateInfo, pAllocator, pIndirectCommandsLayout);
    }

    public static int vkCreateIndirectCommandsLayoutNVX(VkDevice device, VkIndirectCommandsLayoutCreateInfoNVX pCreateInfo, VkAllocationCallbacks pAllocator, LongBuffer pIndirectCommandsLayout) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pIndirectCommandsLayout, 1);
        }
        return NVXDeviceGeneratedCommands.nvkCreateIndirectCommandsLayoutNVX(device, pCreateInfo.address(), MemoryUtil.memAddressSafe(pAllocator), MemoryUtil.memAddress(pIndirectCommandsLayout));
    }

    public static void nvkDestroyIndirectCommandsLayoutNVX(VkDevice device, long indirectCommandsLayout, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyIndirectCommandsLayoutNVX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            if (pAllocator != 0L) {
                VkAllocationCallbacks.validate(pAllocator);
            }
        }
        JNI.callPJPV(__functionAddress, device.address(), indirectCommandsLayout, pAllocator);
    }

    public static void vkDestroyIndirectCommandsLayoutNVX(VkDevice device, long indirectCommandsLayout, VkAllocationCallbacks pAllocator) {
        NVXDeviceGeneratedCommands.nvkDestroyIndirectCommandsLayoutNVX(device, indirectCommandsLayout, MemoryUtil.memAddressSafe(pAllocator));
    }

    public static int nvkCreateObjectTableNVX(VkDevice device, long pCreateInfo, long pAllocator, long pObjectTable) {
        long __functionAddress = device.getCapabilities().vkCreateObjectTableNVX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkObjectTableCreateInfoNVX.validate(pCreateInfo);
            if (pAllocator != 0L) {
                VkAllocationCallbacks.validate(pAllocator);
            }
        }
        return JNI.callPPPPI(__functionAddress, device.address(), pCreateInfo, pAllocator, pObjectTable);
    }

    public static int vkCreateObjectTableNVX(VkDevice device, VkObjectTableCreateInfoNVX pCreateInfo, VkAllocationCallbacks pAllocator, LongBuffer pObjectTable) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pObjectTable, 1);
        }
        return NVXDeviceGeneratedCommands.nvkCreateObjectTableNVX(device, pCreateInfo.address(), MemoryUtil.memAddressSafe(pAllocator), MemoryUtil.memAddress(pObjectTable));
    }

    public static void nvkDestroyObjectTableNVX(VkDevice device, long objectTable, long pAllocator) {
        long __functionAddress = device.getCapabilities().vkDestroyObjectTableNVX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            if (pAllocator != 0L) {
                VkAllocationCallbacks.validate(pAllocator);
            }
        }
        JNI.callPJPV(__functionAddress, device.address(), objectTable, pAllocator);
    }

    public static void vkDestroyObjectTableNVX(VkDevice device, long objectTable, VkAllocationCallbacks pAllocator) {
        NVXDeviceGeneratedCommands.nvkDestroyObjectTableNVX(device, objectTable, MemoryUtil.memAddressSafe(pAllocator));
    }

    public static int nvkRegisterObjectsNVX(VkDevice device, long objectTable, int objectCount, long ppObjectTableEntries, long pObjectIndices) {
        long __functionAddress = device.getCapabilities().vkRegisterObjectsNVX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPPI(__functionAddress, device.address(), objectTable, objectCount, ppObjectTableEntries, pObjectIndices);
    }

    public static int vkRegisterObjectsNVX(VkDevice device, long objectTable, PointerBuffer ppObjectTableEntries, IntBuffer pObjectIndices) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pObjectIndices, ppObjectTableEntries.remaining());
        }
        return NVXDeviceGeneratedCommands.nvkRegisterObjectsNVX(device, objectTable, ppObjectTableEntries.remaining(), MemoryUtil.memAddress(ppObjectTableEntries), MemoryUtil.memAddress(pObjectIndices));
    }

    public static int nvkUnregisterObjectsNVX(VkDevice device, long objectTable, int objectCount, long pObjectEntryTypes, long pObjectIndices) {
        long __functionAddress = device.getCapabilities().vkUnregisterObjectsNVX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPPI(__functionAddress, device.address(), objectTable, objectCount, pObjectEntryTypes, pObjectIndices);
    }

    public static int vkUnregisterObjectsNVX(VkDevice device, long objectTable, IntBuffer pObjectEntryTypes, IntBuffer pObjectIndices) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pObjectIndices, pObjectEntryTypes.remaining());
        }
        return NVXDeviceGeneratedCommands.nvkUnregisterObjectsNVX(device, objectTable, pObjectEntryTypes.remaining(), MemoryUtil.memAddress(pObjectEntryTypes), MemoryUtil.memAddress(pObjectIndices));
    }

    public static void nvkGetPhysicalDeviceGeneratedCommandsPropertiesNVX(VkPhysicalDevice physicalDevice, long pFeatures, long pLimits) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceGeneratedCommandsPropertiesNVX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, physicalDevice.address(), pFeatures, pLimits);
    }

    public static void vkGetPhysicalDeviceGeneratedCommandsPropertiesNVX(VkPhysicalDevice physicalDevice, VkDeviceGeneratedCommandsFeaturesNVX pFeatures, VkDeviceGeneratedCommandsLimitsNVX pLimits) {
        NVXDeviceGeneratedCommands.nvkGetPhysicalDeviceGeneratedCommandsPropertiesNVX(physicalDevice, pFeatures.address(), pLimits.address());
    }

    public static int vkCreateIndirectCommandsLayoutNVX(VkDevice device, VkIndirectCommandsLayoutCreateInfoNVX pCreateInfo, VkAllocationCallbacks pAllocator, long[] pIndirectCommandsLayout) {
        long __functionAddress = device.getCapabilities().vkCreateIndirectCommandsLayoutNVX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pIndirectCommandsLayout, 1);
            VkIndirectCommandsLayoutCreateInfoNVX.validate(pCreateInfo.address());
            if (pAllocator != null) {
                VkAllocationCallbacks.validate(pAllocator.address());
            }
        }
        return JNI.callPPPPI(__functionAddress, device.address(), pCreateInfo.address(), MemoryUtil.memAddressSafe(pAllocator), pIndirectCommandsLayout);
    }

    public static int vkCreateObjectTableNVX(VkDevice device, VkObjectTableCreateInfoNVX pCreateInfo, VkAllocationCallbacks pAllocator, long[] pObjectTable) {
        long __functionAddress = device.getCapabilities().vkCreateObjectTableNVX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pObjectTable, 1);
            VkObjectTableCreateInfoNVX.validate(pCreateInfo.address());
            if (pAllocator != null) {
                VkAllocationCallbacks.validate(pAllocator.address());
            }
        }
        return JNI.callPPPPI(__functionAddress, device.address(), pCreateInfo.address(), MemoryUtil.memAddressSafe(pAllocator), pObjectTable);
    }

    public static int vkRegisterObjectsNVX(VkDevice device, long objectTable, PointerBuffer ppObjectTableEntries, int[] pObjectIndices) {
        long __functionAddress = device.getCapabilities().vkRegisterObjectsNVX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pObjectIndices, ppObjectTableEntries.remaining());
        }
        return JNI.callPJPPI(__functionAddress, device.address(), objectTable, ppObjectTableEntries.remaining(), MemoryUtil.memAddress(ppObjectTableEntries), pObjectIndices);
    }

    public static int vkUnregisterObjectsNVX(VkDevice device, long objectTable, int[] pObjectEntryTypes, int[] pObjectIndices) {
        long __functionAddress = device.getCapabilities().vkUnregisterObjectsNVX;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pObjectIndices, pObjectEntryTypes.length);
        }
        return JNI.callPJPPI(__functionAddress, device.address(), objectTable, pObjectEntryTypes.length, pObjectEntryTypes, pObjectIndices);
    }
}

