/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.util.HashSet;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.vulkan.VK10;

public final class VK {
    private static FunctionProvider functionProvider;
    private static GlobalCommands globalCommands;

    private VK() {
    }

    public static void create() {
        SharedLibrary VK2;
        switch (Platform.get()) {
            case LINUX: {
                VK2 = Library.loadNative(VK.class, Configuration.VULKAN_LIBRARY_NAME, "libvulkan.so.1");
                break;
            }
            case WINDOWS: {
                VK2 = Library.loadNative(VK.class, Configuration.VULKAN_LIBRARY_NAME, "vulkan-1");
                break;
            }
            case MACOSX: {
                VK2 = Library.loadNative(VK.class, Configuration.VULKAN_LIBRARY_NAME, new String[0]);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        VK.create(VK2);
    }

    public static void create(String libName) {
        VK.create(Library.loadNative(VK.class, libName));
    }

    public static void create(FunctionProvider functionProvider) {
        if (VK.functionProvider != null) {
            throw new IllegalStateException("Vulkan has already been created.");
        }
        VK.functionProvider = functionProvider;
        globalCommands = new GlobalCommands(functionProvider);
    }

    public static void destroy() {
        if (functionProvider == null) {
            return;
        }
        if (functionProvider instanceof NativeResource) {
            ((NativeResource)((Object)functionProvider)).free();
        }
        functionProvider = null;
        globalCommands = null;
    }

    public static FunctionProvider getFunctionProvider() {
        return functionProvider;
    }

    static GlobalCommands getGlobalCommands() {
        return globalCommands;
    }

    static Set<String> getEnabledExtensionSet(int apiVersion, PointerBuffer extensionNames) {
        HashSet<String> enabledExtensions = new HashSet<String>(16);
        int majorVersion = VK10.VK_VERSION_MAJOR(apiVersion);
        int minorVersion = VK10.VK_VERSION_MINOR(apiVersion);
        int[] VK_VERSIONS = new int[]{0};
        int maxMajor = Math.min(majorVersion, VK_VERSIONS.length);
        for (int M = 1; M <= maxMajor; ++M) {
            int maxMinor = VK_VERSIONS[M - 1];
            if (M == majorVersion) {
                maxMinor = Math.min(minorVersion, maxMinor);
            }
            for (int m = 0; m <= maxMinor; ++m) {
                enabledExtensions.add(String.format("Vulkan%d%d", M, m));
            }
        }
        if (extensionNames != null) {
            for (int i = extensionNames.position(); i < extensionNames.limit(); ++i) {
                enabledExtensions.add(extensionNames.getStringUTF8(i));
            }
        }
        return enabledExtensions;
    }

    static <T> T checkExtension(String extension, T functions) {
        if (functions != null) {
            return functions;
        }
        APIUtil.apiLog("[VK] " + extension + " was reported as available but an entry point is missing.");
        return null;
    }

    static long isSupported(FunctionProvider provider, String functionName, boolean extensionSupported) {
        return extensionSupported ? provider.getFunctionAddress(functionName) : 0L;
    }

    static {
        if (!Configuration.VULKAN_EXPLICIT_INIT.get(false).booleanValue()) {
            VK.create();
        }
    }

    static class GlobalCommands {
        final long vkGetInstanceProcAddr;
        final long vkCreateInstance;
        final long vkEnumerateInstanceExtensionProperties;
        final long vkEnumerateInstanceLayerProperties;

        GlobalCommands(FunctionProvider library) {
            this.vkGetInstanceProcAddr = library.getFunctionAddress("vkGetInstanceProcAddr");
            if (this.vkGetInstanceProcAddr == 0L) {
                throw new IllegalArgumentException("A critical function is missing. Make sure that Vulkan is available.");
            }
            this.vkCreateInstance = this.getFunctionAddress("vkCreateInstance");
            this.vkEnumerateInstanceExtensionProperties = this.getFunctionAddress("vkEnumerateInstanceExtensionProperties");
            this.vkEnumerateInstanceLayerProperties = this.getFunctionAddress("vkEnumerateInstanceLayerProperties");
        }

        private long getFunctionAddress(String name) {
            try (MemoryStack stack = MemoryStack.stackPush();){
                long address = JNI.callPPP(this.vkGetInstanceProcAddr, 0L, MemoryUtil.memAddress(stack.ASCII(name)));
                if (address == 0L) {
                    throw new IllegalArgumentException("A critical function is missing. Make sure that Vulkan is available.");
                }
                long l = address;
                return l;
            }
        }
    }
}

