/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkAcquireNextImageInfoKHX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SWAPCHAIN;
    public static final int TIMEOUT;
    public static final int SEMAPHORE;
    public static final int FENCE;
    public static final int DEVICEMASK;

    VkAcquireNextImageInfoKHX(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkAcquireNextImageInfoKHX(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkAcquireNextImageInfoKHX.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkAcquireNextImageInfoKHX.nsType(this.address());
    }

    public long pNext() {
        return VkAcquireNextImageInfoKHX.npNext(this.address());
    }

    public long swapchain() {
        return VkAcquireNextImageInfoKHX.nswapchain(this.address());
    }

    public long timeout() {
        return VkAcquireNextImageInfoKHX.ntimeout(this.address());
    }

    public long semaphore() {
        return VkAcquireNextImageInfoKHX.nsemaphore(this.address());
    }

    public long fence() {
        return VkAcquireNextImageInfoKHX.nfence(this.address());
    }

    public int deviceMask() {
        return VkAcquireNextImageInfoKHX.ndeviceMask(this.address());
    }

    public VkAcquireNextImageInfoKHX sType(int value) {
        VkAcquireNextImageInfoKHX.nsType(this.address(), value);
        return this;
    }

    public VkAcquireNextImageInfoKHX pNext(long value) {
        VkAcquireNextImageInfoKHX.npNext(this.address(), value);
        return this;
    }

    public VkAcquireNextImageInfoKHX swapchain(long value) {
        VkAcquireNextImageInfoKHX.nswapchain(this.address(), value);
        return this;
    }

    public VkAcquireNextImageInfoKHX timeout(long value) {
        VkAcquireNextImageInfoKHX.ntimeout(this.address(), value);
        return this;
    }

    public VkAcquireNextImageInfoKHX semaphore(long value) {
        VkAcquireNextImageInfoKHX.nsemaphore(this.address(), value);
        return this;
    }

    public VkAcquireNextImageInfoKHX fence(long value) {
        VkAcquireNextImageInfoKHX.nfence(this.address(), value);
        return this;
    }

    public VkAcquireNextImageInfoKHX deviceMask(int value) {
        VkAcquireNextImageInfoKHX.ndeviceMask(this.address(), value);
        return this;
    }

    public VkAcquireNextImageInfoKHX set(int sType, long pNext, long swapchain, long timeout, long semaphore, long fence, int deviceMask) {
        this.sType(sType);
        this.pNext(pNext);
        this.swapchain(swapchain);
        this.timeout(timeout);
        this.semaphore(semaphore);
        this.fence(fence);
        this.deviceMask(deviceMask);
        return this;
    }

    public VkAcquireNextImageInfoKHX set(VkAcquireNextImageInfoKHX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkAcquireNextImageInfoKHX malloc() {
        return VkAcquireNextImageInfoKHX.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkAcquireNextImageInfoKHX calloc() {
        return VkAcquireNextImageInfoKHX.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkAcquireNextImageInfoKHX create() {
        return new VkAcquireNextImageInfoKHX(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkAcquireNextImageInfoKHX create(long address) {
        return address == 0L ? null : new VkAcquireNextImageInfoKHX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkAcquireNextImageInfoKHX.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkAcquireNextImageInfoKHX.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkAcquireNextImageInfoKHX mallocStack() {
        return VkAcquireNextImageInfoKHX.mallocStack(MemoryStack.stackGet());
    }

    public static VkAcquireNextImageInfoKHX callocStack() {
        return VkAcquireNextImageInfoKHX.callocStack(MemoryStack.stackGet());
    }

    public static VkAcquireNextImageInfoKHX mallocStack(MemoryStack stack) {
        return VkAcquireNextImageInfoKHX.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkAcquireNextImageInfoKHX callocStack(MemoryStack stack) {
        return VkAcquireNextImageInfoKHX.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkAcquireNextImageInfoKHX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkAcquireNextImageInfoKHX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkAcquireNextImageInfoKHX.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkAcquireNextImageInfoKHX.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nswapchain(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SWAPCHAIN);
    }

    public static long ntimeout(long struct) {
        return MemoryUtil.memGetLong(struct + (long)TIMEOUT);
    }

    public static long nsemaphore(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SEMAPHORE);
    }

    public static long nfence(long struct) {
        return MemoryUtil.memGetLong(struct + (long)FENCE);
    }

    public static int ndeviceMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEVICEMASK);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nswapchain(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SWAPCHAIN, value);
    }

    public static void ntimeout(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)TIMEOUT, value);
    }

    public static void nsemaphore(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SEMAPHORE, value);
    }

    public static void nfence(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)FENCE, value);
    }

    public static void ndeviceMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEVICEMASK, value);
    }

    static {
        Struct.Layout layout = VkAcquireNextImageInfoKHX.__struct(VkAcquireNextImageInfoKHX.__member(4), VkAcquireNextImageInfoKHX.__member(POINTER_SIZE), VkAcquireNextImageInfoKHX.__member(8), VkAcquireNextImageInfoKHX.__member(8), VkAcquireNextImageInfoKHX.__member(8), VkAcquireNextImageInfoKHX.__member(8), VkAcquireNextImageInfoKHX.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SWAPCHAIN = layout.offsetof(2);
        TIMEOUT = layout.offsetof(3);
        SEMAPHORE = layout.offsetof(4);
        FENCE = layout.offsetof(5);
        DEVICEMASK = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkAcquireNextImageInfoKHX, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkAcquireNextImageInfoKHX newInstance(long address) {
            return new VkAcquireNextImageInfoKHX(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkAcquireNextImageInfoKHX.nsType(this.address());
        }

        public long pNext() {
            return VkAcquireNextImageInfoKHX.npNext(this.address());
        }

        public long swapchain() {
            return VkAcquireNextImageInfoKHX.nswapchain(this.address());
        }

        public long timeout() {
            return VkAcquireNextImageInfoKHX.ntimeout(this.address());
        }

        public long semaphore() {
            return VkAcquireNextImageInfoKHX.nsemaphore(this.address());
        }

        public long fence() {
            return VkAcquireNextImageInfoKHX.nfence(this.address());
        }

        public int deviceMask() {
            return VkAcquireNextImageInfoKHX.ndeviceMask(this.address());
        }

        public Buffer sType(int value) {
            VkAcquireNextImageInfoKHX.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkAcquireNextImageInfoKHX.npNext(this.address(), value);
            return this;
        }

        public Buffer swapchain(long value) {
            VkAcquireNextImageInfoKHX.nswapchain(this.address(), value);
            return this;
        }

        public Buffer timeout(long value) {
            VkAcquireNextImageInfoKHX.ntimeout(this.address(), value);
            return this;
        }

        public Buffer semaphore(long value) {
            VkAcquireNextImageInfoKHX.nsemaphore(this.address(), value);
            return this;
        }

        public Buffer fence(long value) {
            VkAcquireNextImageInfoKHX.nfence(this.address(), value);
            return this;
        }

        public Buffer deviceMask(int value) {
            VkAcquireNextImageInfoKHX.ndeviceMask(this.address(), value);
            return this;
        }
    }
}

