/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBindBufferMemoryInfoKHX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int BUFFER;
    public static final int MEMORY;
    public static final int MEMORYOFFSET;
    public static final int DEVICEINDEXCOUNT;
    public static final int PDEVICEINDICES;

    VkBindBufferMemoryInfoKHX(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkBindBufferMemoryInfoKHX(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkBindBufferMemoryInfoKHX.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkBindBufferMemoryInfoKHX.nsType(this.address());
    }

    public long pNext() {
        return VkBindBufferMemoryInfoKHX.npNext(this.address());
    }

    public long buffer() {
        return VkBindBufferMemoryInfoKHX.nbuffer(this.address());
    }

    public long memory() {
        return VkBindBufferMemoryInfoKHX.nmemory(this.address());
    }

    public long memoryOffset() {
        return VkBindBufferMemoryInfoKHX.nmemoryOffset(this.address());
    }

    public int deviceIndexCount() {
        return VkBindBufferMemoryInfoKHX.ndeviceIndexCount(this.address());
    }

    public IntBuffer pDeviceIndices() {
        return VkBindBufferMemoryInfoKHX.npDeviceIndices(this.address());
    }

    public VkBindBufferMemoryInfoKHX sType(int value) {
        VkBindBufferMemoryInfoKHX.nsType(this.address(), value);
        return this;
    }

    public VkBindBufferMemoryInfoKHX pNext(long value) {
        VkBindBufferMemoryInfoKHX.npNext(this.address(), value);
        return this;
    }

    public VkBindBufferMemoryInfoKHX buffer(long value) {
        VkBindBufferMemoryInfoKHX.nbuffer(this.address(), value);
        return this;
    }

    public VkBindBufferMemoryInfoKHX memory(long value) {
        VkBindBufferMemoryInfoKHX.nmemory(this.address(), value);
        return this;
    }

    public VkBindBufferMemoryInfoKHX memoryOffset(long value) {
        VkBindBufferMemoryInfoKHX.nmemoryOffset(this.address(), value);
        return this;
    }

    public VkBindBufferMemoryInfoKHX pDeviceIndices(IntBuffer value) {
        VkBindBufferMemoryInfoKHX.npDeviceIndices(this.address(), value);
        return this;
    }

    public VkBindBufferMemoryInfoKHX set(int sType, long pNext, long buffer, long memory, long memoryOffset, IntBuffer pDeviceIndices) {
        this.sType(sType);
        this.pNext(pNext);
        this.buffer(buffer);
        this.memory(memory);
        this.memoryOffset(memoryOffset);
        this.pDeviceIndices(pDeviceIndices);
        return this;
    }

    public VkBindBufferMemoryInfoKHX set(VkBindBufferMemoryInfoKHX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBindBufferMemoryInfoKHX malloc() {
        return VkBindBufferMemoryInfoKHX.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkBindBufferMemoryInfoKHX calloc() {
        return VkBindBufferMemoryInfoKHX.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkBindBufferMemoryInfoKHX create() {
        return new VkBindBufferMemoryInfoKHX(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkBindBufferMemoryInfoKHX create(long address) {
        return address == 0L ? null : new VkBindBufferMemoryInfoKHX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkBindBufferMemoryInfoKHX.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBindBufferMemoryInfoKHX.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkBindBufferMemoryInfoKHX mallocStack() {
        return VkBindBufferMemoryInfoKHX.mallocStack(MemoryStack.stackGet());
    }

    public static VkBindBufferMemoryInfoKHX callocStack() {
        return VkBindBufferMemoryInfoKHX.callocStack(MemoryStack.stackGet());
    }

    public static VkBindBufferMemoryInfoKHX mallocStack(MemoryStack stack) {
        return VkBindBufferMemoryInfoKHX.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBindBufferMemoryInfoKHX callocStack(MemoryStack stack) {
        return VkBindBufferMemoryInfoKHX.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkBindBufferMemoryInfoKHX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkBindBufferMemoryInfoKHX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBindBufferMemoryInfoKHX.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBindBufferMemoryInfoKHX.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nbuffer(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BUFFER);
    }

    public static long nmemory(long struct) {
        return MemoryUtil.memGetLong(struct + (long)MEMORY);
    }

    public static long nmemoryOffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)MEMORYOFFSET);
    }

    public static int ndeviceIndexCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEVICEINDEXCOUNT);
    }

    public static IntBuffer npDeviceIndices(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)PDEVICEINDICES), VkBindBufferMemoryInfoKHX.ndeviceIndexCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nbuffer(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)BUFFER, value);
    }

    public static void nmemory(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)MEMORY, value);
    }

    public static void nmemoryOffset(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)MEMORYOFFSET, value);
    }

    public static void ndeviceIndexCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEVICEINDEXCOUNT, value);
    }

    public static void npDeviceIndices(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDEVICEINDICES, MemoryUtil.memAddressSafe(value));
        VkBindBufferMemoryInfoKHX.ndeviceIndexCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkBindBufferMemoryInfoKHX.ndeviceIndexCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PDEVICEINDICES));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkBindBufferMemoryInfoKHX.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkBindBufferMemoryInfoKHX.__struct(VkBindBufferMemoryInfoKHX.__member(4), VkBindBufferMemoryInfoKHX.__member(POINTER_SIZE), VkBindBufferMemoryInfoKHX.__member(8), VkBindBufferMemoryInfoKHX.__member(8), VkBindBufferMemoryInfoKHX.__member(8), VkBindBufferMemoryInfoKHX.__member(4), VkBindBufferMemoryInfoKHX.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        BUFFER = layout.offsetof(2);
        MEMORY = layout.offsetof(3);
        MEMORYOFFSET = layout.offsetof(4);
        DEVICEINDEXCOUNT = layout.offsetof(5);
        PDEVICEINDICES = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkBindBufferMemoryInfoKHX, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkBindBufferMemoryInfoKHX newInstance(long address) {
            return new VkBindBufferMemoryInfoKHX(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkBindBufferMemoryInfoKHX.nsType(this.address());
        }

        public long pNext() {
            return VkBindBufferMemoryInfoKHX.npNext(this.address());
        }

        public long buffer() {
            return VkBindBufferMemoryInfoKHX.nbuffer(this.address());
        }

        public long memory() {
            return VkBindBufferMemoryInfoKHX.nmemory(this.address());
        }

        public long memoryOffset() {
            return VkBindBufferMemoryInfoKHX.nmemoryOffset(this.address());
        }

        public int deviceIndexCount() {
            return VkBindBufferMemoryInfoKHX.ndeviceIndexCount(this.address());
        }

        public IntBuffer pDeviceIndices() {
            return VkBindBufferMemoryInfoKHX.npDeviceIndices(this.address());
        }

        public Buffer sType(int value) {
            VkBindBufferMemoryInfoKHX.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkBindBufferMemoryInfoKHX.npNext(this.address(), value);
            return this;
        }

        public Buffer buffer(long value) {
            VkBindBufferMemoryInfoKHX.nbuffer(this.address(), value);
            return this;
        }

        public Buffer memory(long value) {
            VkBindBufferMemoryInfoKHX.nmemory(this.address(), value);
            return this;
        }

        public Buffer memoryOffset(long value) {
            VkBindBufferMemoryInfoKHX.nmemoryOffset(this.address(), value);
            return this;
        }

        public Buffer pDeviceIndices(IntBuffer value) {
            VkBindBufferMemoryInfoKHX.npDeviceIndices(this.address(), value);
            return this;
        }
    }
}

