/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkRect2D;

public class VkBindImageMemoryInfoKHX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int IMAGE;
    public static final int MEMORY;
    public static final int MEMORYOFFSET;
    public static final int DEVICEINDEXCOUNT;
    public static final int PDEVICEINDICES;
    public static final int SFRRECTCOUNT;
    public static final int PSFRRECTS;

    VkBindImageMemoryInfoKHX(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkBindImageMemoryInfoKHX(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkBindImageMemoryInfoKHX.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkBindImageMemoryInfoKHX.nsType(this.address());
    }

    public long pNext() {
        return VkBindImageMemoryInfoKHX.npNext(this.address());
    }

    public long image() {
        return VkBindImageMemoryInfoKHX.nimage(this.address());
    }

    public long memory() {
        return VkBindImageMemoryInfoKHX.nmemory(this.address());
    }

    public long memoryOffset() {
        return VkBindImageMemoryInfoKHX.nmemoryOffset(this.address());
    }

    public int deviceIndexCount() {
        return VkBindImageMemoryInfoKHX.ndeviceIndexCount(this.address());
    }

    public IntBuffer pDeviceIndices() {
        return VkBindImageMemoryInfoKHX.npDeviceIndices(this.address());
    }

    public int SFRRectCount() {
        return VkBindImageMemoryInfoKHX.nSFRRectCount(this.address());
    }

    public VkRect2D.Buffer pSFRRects() {
        return VkBindImageMemoryInfoKHX.npSFRRects(this.address());
    }

    public VkBindImageMemoryInfoKHX sType(int value) {
        VkBindImageMemoryInfoKHX.nsType(this.address(), value);
        return this;
    }

    public VkBindImageMemoryInfoKHX pNext(long value) {
        VkBindImageMemoryInfoKHX.npNext(this.address(), value);
        return this;
    }

    public VkBindImageMemoryInfoKHX image(long value) {
        VkBindImageMemoryInfoKHX.nimage(this.address(), value);
        return this;
    }

    public VkBindImageMemoryInfoKHX memory(long value) {
        VkBindImageMemoryInfoKHX.nmemory(this.address(), value);
        return this;
    }

    public VkBindImageMemoryInfoKHX memoryOffset(long value) {
        VkBindImageMemoryInfoKHX.nmemoryOffset(this.address(), value);
        return this;
    }

    public VkBindImageMemoryInfoKHX pDeviceIndices(IntBuffer value) {
        VkBindImageMemoryInfoKHX.npDeviceIndices(this.address(), value);
        return this;
    }

    public VkBindImageMemoryInfoKHX pSFRRects(VkRect2D.Buffer value) {
        VkBindImageMemoryInfoKHX.npSFRRects(this.address(), value);
        return this;
    }

    public VkBindImageMemoryInfoKHX set(int sType, long pNext, long image, long memory, long memoryOffset, IntBuffer pDeviceIndices, VkRect2D.Buffer pSFRRects) {
        this.sType(sType);
        this.pNext(pNext);
        this.image(image);
        this.memory(memory);
        this.memoryOffset(memoryOffset);
        this.pDeviceIndices(pDeviceIndices);
        this.pSFRRects(pSFRRects);
        return this;
    }

    public VkBindImageMemoryInfoKHX set(VkBindImageMemoryInfoKHX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBindImageMemoryInfoKHX malloc() {
        return VkBindImageMemoryInfoKHX.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkBindImageMemoryInfoKHX calloc() {
        return VkBindImageMemoryInfoKHX.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkBindImageMemoryInfoKHX create() {
        return new VkBindImageMemoryInfoKHX(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkBindImageMemoryInfoKHX create(long address) {
        return address == 0L ? null : new VkBindImageMemoryInfoKHX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkBindImageMemoryInfoKHX.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBindImageMemoryInfoKHX.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkBindImageMemoryInfoKHX mallocStack() {
        return VkBindImageMemoryInfoKHX.mallocStack(MemoryStack.stackGet());
    }

    public static VkBindImageMemoryInfoKHX callocStack() {
        return VkBindImageMemoryInfoKHX.callocStack(MemoryStack.stackGet());
    }

    public static VkBindImageMemoryInfoKHX mallocStack(MemoryStack stack) {
        return VkBindImageMemoryInfoKHX.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBindImageMemoryInfoKHX callocStack(MemoryStack stack) {
        return VkBindImageMemoryInfoKHX.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkBindImageMemoryInfoKHX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkBindImageMemoryInfoKHX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBindImageMemoryInfoKHX.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBindImageMemoryInfoKHX.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nimage(long struct) {
        return MemoryUtil.memGetLong(struct + (long)IMAGE);
    }

    public static long nmemory(long struct) {
        return MemoryUtil.memGetLong(struct + (long)MEMORY);
    }

    public static long nmemoryOffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)MEMORYOFFSET);
    }

    public static int ndeviceIndexCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEVICEINDEXCOUNT);
    }

    public static IntBuffer npDeviceIndices(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)PDEVICEINDICES), VkBindImageMemoryInfoKHX.ndeviceIndexCount(struct));
    }

    public static int nSFRRectCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SFRRECTCOUNT);
    }

    public static VkRect2D.Buffer npSFRRects(long struct) {
        return VkRect2D.create(MemoryUtil.memGetAddress(struct + (long)PSFRRECTS), VkBindImageMemoryInfoKHX.nSFRRectCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nimage(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)IMAGE, value);
    }

    public static void nmemory(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)MEMORY, value);
    }

    public static void nmemoryOffset(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)MEMORYOFFSET, value);
    }

    public static void ndeviceIndexCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEVICEINDEXCOUNT, value);
    }

    public static void npDeviceIndices(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDEVICEINDICES, MemoryUtil.memAddressSafe(value));
        VkBindImageMemoryInfoKHX.ndeviceIndexCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nSFRRectCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SFRRECTCOUNT, value);
    }

    public static void npSFRRects(long struct, VkRect2D.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSFRRECTS, VkBindImageMemoryInfoKHX.addressSafe(value));
        VkBindImageMemoryInfoKHX.nSFRRectCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkBindImageMemoryInfoKHX.ndeviceIndexCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PDEVICEINDICES));
        }
        if (VkBindImageMemoryInfoKHX.nSFRRectCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PSFRRECTS));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkBindImageMemoryInfoKHX.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkBindImageMemoryInfoKHX.__struct(VkBindImageMemoryInfoKHX.__member(4), VkBindImageMemoryInfoKHX.__member(POINTER_SIZE), VkBindImageMemoryInfoKHX.__member(8), VkBindImageMemoryInfoKHX.__member(8), VkBindImageMemoryInfoKHX.__member(8), VkBindImageMemoryInfoKHX.__member(4), VkBindImageMemoryInfoKHX.__member(POINTER_SIZE), VkBindImageMemoryInfoKHX.__member(4), VkBindImageMemoryInfoKHX.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        IMAGE = layout.offsetof(2);
        MEMORY = layout.offsetof(3);
        MEMORYOFFSET = layout.offsetof(4);
        DEVICEINDEXCOUNT = layout.offsetof(5);
        PDEVICEINDICES = layout.offsetof(6);
        SFRRECTCOUNT = layout.offsetof(7);
        PSFRRECTS = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkBindImageMemoryInfoKHX, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkBindImageMemoryInfoKHX newInstance(long address) {
            return new VkBindImageMemoryInfoKHX(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkBindImageMemoryInfoKHX.nsType(this.address());
        }

        public long pNext() {
            return VkBindImageMemoryInfoKHX.npNext(this.address());
        }

        public long image() {
            return VkBindImageMemoryInfoKHX.nimage(this.address());
        }

        public long memory() {
            return VkBindImageMemoryInfoKHX.nmemory(this.address());
        }

        public long memoryOffset() {
            return VkBindImageMemoryInfoKHX.nmemoryOffset(this.address());
        }

        public int deviceIndexCount() {
            return VkBindImageMemoryInfoKHX.ndeviceIndexCount(this.address());
        }

        public IntBuffer pDeviceIndices() {
            return VkBindImageMemoryInfoKHX.npDeviceIndices(this.address());
        }

        public int SFRRectCount() {
            return VkBindImageMemoryInfoKHX.nSFRRectCount(this.address());
        }

        public VkRect2D.Buffer pSFRRects() {
            return VkBindImageMemoryInfoKHX.npSFRRects(this.address());
        }

        public Buffer sType(int value) {
            VkBindImageMemoryInfoKHX.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkBindImageMemoryInfoKHX.npNext(this.address(), value);
            return this;
        }

        public Buffer image(long value) {
            VkBindImageMemoryInfoKHX.nimage(this.address(), value);
            return this;
        }

        public Buffer memory(long value) {
            VkBindImageMemoryInfoKHX.nmemory(this.address(), value);
            return this;
        }

        public Buffer memoryOffset(long value) {
            VkBindImageMemoryInfoKHX.nmemoryOffset(this.address(), value);
            return this;
        }

        public Buffer pDeviceIndices(IntBuffer value) {
            VkBindImageMemoryInfoKHX.npDeviceIndices(this.address(), value);
            return this;
        }

        public Buffer pSFRRects(VkRect2D.Buffer value) {
            VkBindImageMemoryInfoKHX.npSFRRects(this.address(), value);
            return this;
        }
    }
}

