/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBufferCopy
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SRCOFFSET;
    public static final int DSTOFFSET;
    public static final int SIZE;

    VkBufferCopy(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkBufferCopy(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkBufferCopy.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long srcOffset() {
        return VkBufferCopy.nsrcOffset(this.address());
    }

    public long dstOffset() {
        return VkBufferCopy.ndstOffset(this.address());
    }

    public long size() {
        return VkBufferCopy.nsize(this.address());
    }

    public VkBufferCopy srcOffset(long value) {
        VkBufferCopy.nsrcOffset(this.address(), value);
        return this;
    }

    public VkBufferCopy dstOffset(long value) {
        VkBufferCopy.ndstOffset(this.address(), value);
        return this;
    }

    public VkBufferCopy size(long value) {
        VkBufferCopy.nsize(this.address(), value);
        return this;
    }

    public VkBufferCopy set(long srcOffset, long dstOffset, long size) {
        this.srcOffset(srcOffset);
        this.dstOffset(dstOffset);
        this.size(size);
        return this;
    }

    public VkBufferCopy set(VkBufferCopy src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBufferCopy malloc() {
        return VkBufferCopy.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkBufferCopy calloc() {
        return VkBufferCopy.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkBufferCopy create() {
        return new VkBufferCopy(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkBufferCopy create(long address) {
        return address == 0L ? null : new VkBufferCopy(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkBufferCopy.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBufferCopy.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkBufferCopy mallocStack() {
        return VkBufferCopy.mallocStack(MemoryStack.stackGet());
    }

    public static VkBufferCopy callocStack() {
        return VkBufferCopy.callocStack(MemoryStack.stackGet());
    }

    public static VkBufferCopy mallocStack(MemoryStack stack) {
        return VkBufferCopy.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBufferCopy callocStack(MemoryStack stack) {
        return VkBufferCopy.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkBufferCopy.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkBufferCopy.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBufferCopy.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBufferCopy.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nsrcOffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SRCOFFSET);
    }

    public static long ndstOffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DSTOFFSET);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SIZE);
    }

    public static void nsrcOffset(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SRCOFFSET, value);
    }

    public static void ndstOffset(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)DSTOFFSET, value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SIZE, value);
    }

    static {
        Struct.Layout layout = VkBufferCopy.__struct(VkBufferCopy.__member(8), VkBufferCopy.__member(8), VkBufferCopy.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SRCOFFSET = layout.offsetof(0);
        DSTOFFSET = layout.offsetof(1);
        SIZE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkBufferCopy, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkBufferCopy newInstance(long address) {
            return new VkBufferCopy(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long srcOffset() {
            return VkBufferCopy.nsrcOffset(this.address());
        }

        public long dstOffset() {
            return VkBufferCopy.ndstOffset(this.address());
        }

        public long size() {
            return VkBufferCopy.nsize(this.address());
        }

        public Buffer srcOffset(long value) {
            VkBufferCopy.nsrcOffset(this.address(), value);
            return this;
        }

        public Buffer dstOffset(long value) {
            VkBufferCopy.ndstOffset(this.address(), value);
            return this;
        }

        public Buffer size(long value) {
            VkBufferCopy.nsize(this.address(), value);
            return this;
        }
    }
}

